/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CElement;
import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.DoubleRect;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.NumberFormat;

class BarChart
extends CElement {
    double te = 0.0;
    double pe = 0.0;
    double re = 0.0;
    double work = 0.0;
    private double workZero = 0.0;
    private Font graphFont = null;
    private double graphFactor = 10.0;
    private double graphDelta = 2.0;
    private NumberFormat nf = NumberFormat.getNumberInstance();
    private final int LEFT_MARGIN = 10;
    private final int RIGHT_MARGIN = 0;
    private final int TOP_MARGIN = 10;
    private final int HEIGHT = 10;
    public String pes = "potential energy";
    public String tes = "translational energy";
    public String res = "rotational energy";
    public String wds = "work done by damping";
    private boolean needRescale = false;
    private Color potentialColor = Color.darkGray;
    private Color translationColor = Color.gray;
    private Color rotationColor = Color.lightGray;

    public BarChart(double X1, double Y1, double X2, double Y2) {
        super(X1, Y1, X2, Y2);
    }

    public BarChart(DoubleRect r) {
        this.setBounds(r);
    }

    public void draw(Graphics g, ConvertMap map) {
        int left = map.simToScreenX(this.m_X1);
        int width = map.simToScreenX(this.m_X2) - left;
        int y1 = map.simToScreenY(this.m_Y1);
        int y2 = map.simToScreenY(this.m_Y2);
        int top = Math.min(y1, y2);
        int height = Math.max(y1, y2) - top;
        int w = left + 10;
        int maxWidth = width - 10 - 0;
        double total = Math.max(this.work < 0.0 ? this.workZero : this.workZero + this.work, this.te + this.pe + this.re);
        if (total == 0.0) {
            return;
        }
        this.rescale(total, maxWidth);
        g.setColor(this.potentialColor);
        int w2 = (int)(0.5 + this.pe * this.graphFactor);
        g.fillRect(w, top + 10 + 10, w2, 10);
        g.setColor(this.rotationColor);
        w += w2;
        w2 = (int)(0.5 + this.re * this.graphFactor);
        g.fillRect(w, top + 10 + 10, w2, 10);
        g.setColor(this.translationColor);
        w += w2;
        w2 = (int)(0.5 + this.te * this.graphFactor);
        g.fillRect(w, top + 10 + 10, w2, 10);
        if (this.work != 0.0) {
            g.setColor(Color.black);
            w2 = left + 10 + (int)(0.5 + this.workZero * this.graphFactor);
            w = left + 10 + (int)(0.5 + (this.workZero + this.work) * this.graphFactor);
            if (this.work > 0.0) {
                int d = w;
                w = w2;
                w2 = d;
            }
            g.drawRect(w, top + 10, w2 - w, 10);
        }
        this.setFont(g);
        int y = this.drawScale(g, left + 10, top + 10 + 10, total);
        int x = left + 10;
        boolean FILLED = true;
        boolean OUTLINE = false;
        x = this.drawLegend(g, this.pes, this.potentialColor, true, x, y);
        if (this.re > 0.0) {
            x = this.drawLegend(g, this.res, this.rotationColor, true, x, y);
        }
        x = this.drawLegend(g, this.tes, this.translationColor, true, x, y);
        if (this.work != 0.0) {
            x = this.drawLegend(g, this.wds, Color.black, false, x, y);
        }
    }

    public void setWorkZero(double workZero) {
        this.workZero = workZero;
        this.needRescale = true;
    }

    private void rescale(double total, double maxWidth) {
        if (this.needRescale || total * this.graphFactor > maxWidth || total * this.graphFactor < 0.2 * maxWidth) {
            this.needRescale = false;
            this.graphFactor = total * this.graphFactor > maxWidth ? 0.75 * maxWidth / total : 0.9 * maxWidth / total;
            double power = Math.pow(10.0, Math.floor(Math.log(total) / Math.log(10.0)));
            double logTot = total / power;
            this.graphDelta = logTot >= 8.0 ? 2.0 : (logTot >= 5.0 ? 1.0 : (logTot >= 3.0 ? 0.5 : (logTot >= 2.0 ? 0.4 : 0.2)));
            this.graphDelta *= power;
        }
    }

    private void setFont(Graphics g) {
        if (this.graphFont == null) {
            this.graphFont = new Font("SansSerif", 0, 10);
        }
        g.setFont(this.graphFont);
    }

    private int drawScale(Graphics g, int left, int top, double total) {
        FontMetrics graphFM = g.getFontMetrics();
        int graphAscent = graphFM.getAscent();
        this.nf.setMaximumFractionDigits(4);
        this.nf.setMinimumFractionDigits(0);
        g.setColor(Color.black);
        double scale = 0.0;
        do {
            int x = left + (int)(scale * this.graphFactor);
            g.drawLine(x, top + 5, x, top + 10 + 2);
            String s = this.nf.format(scale);
            int textWidth = graphFM.stringWidth(s);
            g.drawString(s, x - textWidth / 2, top + 10 + graphAscent + 3);
        } while ((scale += this.graphDelta) < total);
        return top + 10 + graphAscent + 3 + graphFM.getDescent();
    }

    private int drawLegend(Graphics g, String s, Color c, boolean filled, int x, int y) {
        int BOX = 10;
        FontMetrics graphFM = g.getFontMetrics();
        g.setColor(c);
        if (filled) {
            g.fillRect(x, y, 10, 10);
        } else {
            g.drawRect(x, y, 10, 10);
        }
        int textWidth = graphFM.stringWidth(s);
        g.setColor(Color.black);
        g.drawString(s, x += 13, y + graphFM.getAscent());
        return x += textWidth + 5;
    }
}

