/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CElement;
import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.DoubleRect;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.NumberFormat;

class CText
extends CElement {
    public String m_text;
    private double m_num = 0.0;
    private int fontSize = 14;
    private boolean show_num = false;
    private Font myFont = null;
    private FontMetrics myFM = null;
    private int ascent = 20;
    private int descent = 10;
    private int leading = 5;
    private NumberFormat nf = null;
    public int line_height = 10;
    public boolean centered = false;

    public CText(double X1, double Y1, String t) {
        super(X1, Y1, X1, Y1);
        this.m_text = t;
        this.m_Color = Color.gray;
    }

    public CText(String t) {
        this(0.0, 0.0, t);
        this.centered = true;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public void setNumber(double n) {
        this.show_num = true;
        this.m_num = n;
    }

    public void setText(String t) {
        this.m_text = t;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
    }

    private void setFont(Graphics g) {
        if (this.myFont != null) {
            return;
        }
        this.myFont = new Font("Serif", 0, this.fontSize);
        this.myFM = g.getFontMetrics(this.myFont);
        this.ascent = this.myFM.getAscent();
        this.descent = this.myFM.getDescent();
        this.leading = this.myFM.getLeading();
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(5);
        if (this.line_height != this.ascent + this.descent + this.leading) {
            this.line_height = this.ascent + this.descent + this.leading;
        }
    }

    public void draw(Graphics g, ConvertMap map) {
        int x1;
        int y1;
        String tx;
        this.setFont(g);
        g.setFont(this.myFont);
        g.setColor(this.m_Color);
        String string = tx = this.show_num ? this.m_text + this.nf.format(this.m_num) : this.m_text;
        if (this.centered) {
            DoubleRect r = map.getSimBounds();
            y1 = map.simToScreenY((r.getYMax() + r.getYMin()) / 2.0);
            int w = this.myFM.stringWidth(tx);
            x1 = map.simToScreenX((r.getXMax() + r.getXMin()) / 2.0) - w / 2;
        } else {
            x1 = map.simToScreenX(this.m_X1);
            y1 = map.simToScreenY(this.m_Y1);
        }
        g.drawString(tx, x1, y1);
    }
}

