/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CollisionException;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;
import java.text.NumberFormat;
import java.util.Vector;

public abstract class CollidingSim
extends Simulation {
    double TOL = 1.0E-4;
    private double[] old_vars = null;
    private NumberFormat dnf = NumberFormat.getNumberInstance();
    protected double lastTimeStep = 0.0;

    public CollidingSim(Container container) {
        super(container);
    }

    public CollidingSim(Container container, int numVars) {
        super(container, numVars);
    }

    private void debugPrint(int k, Vector collisions) {
        switch (k) {
            case 0: {
                this.dnf.setMaximumFractionDigits(7);
                String s = "starting vars";
                for (int i = 0; i < this.vars.length; ++i) {
                    s = s + " [" + i + "]=" + this.dnf.format(this.vars[i]);
                }
                System.out.println(s);
                break;
            }
            case 1: {
                if (collisions == null) break;
                for (int i = 0; i < collisions.size(); ++i) {
                    System.out.println("[" + i + "] " + collisions.elementAt(i));
                }
                break;
            }
        }
    }

    protected void advance(double timeStep) {
        double timeAdvanced = 0.0;
        double h = timeStep;
        int collisionCount = 0;
        while (timeAdvanced < timeStep) {
            if (this.old_vars == null || this.old_vars.length < this.vars.length) {
                this.old_vars = new double[this.vars.length];
            }
            for (int i = 0; i < this.vars.length; ++i) {
                this.old_vars[i] = this.vars[i];
            }
            Vector collisions = null;
            try {
                this.odeSolver.step(h);
                this.modifyObjects();
                collisions = this.findAllCollisions();
            }
            catch (CollisionException e) {
                collisions = e.collisions;
            }
            if (collisions != null) {
                for (int i = 0; i < this.vars.length; ++i) {
                    this.vars[i] = this.old_vars[i];
                }
                if (h <= this.TOL) {
                    this.handleCollisions(collisions);
                    h = timeStep - timeAdvanced;
                    if (++collisionCount < 10) continue;
                    System.out.println("stuck in advance(): many collisions in a row");
                    break;
                }
            } else {
                collisionCount = 0;
                timeAdvanced += h;
                this.simTime += h;
                if (h <= this.TOL) continue;
            }
            h /= 2.0;
        }
        this.lastTimeStep = timeAdvanced;
    }

    public abstract Vector findAllCollisions();

    public abstract void handleCollisions(Vector var1);
}

