/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.BarChart;
import com.myphysicslab.simlab.CRect;
import com.myphysicslab.simlab.CVector;
import com.myphysicslab.simlab.Collision;
import com.myphysicslab.simlab.CollisionException;
import com.myphysicslab.simlab.ContactObject;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Thruster5;
import com.myphysicslab.simlab.Thruster5Object;
import com.myphysicslab.simlab.Utility;
import java.awt.Color;
import java.awt.Container;
import java.util.Vector;

public class ContactSim
extends Thruster5 {
    public static final double SMALL_NEGATIVE = -1.0E-10;
    public static final double SMALL_POSITIVE = 1.0E-10;
    private boolean debugContact = false;
    private static final String START_CONFIG = "start position";
    private Vector contactsFound = new Vector(10);

    public ContactSim(Container container) {
        super(container, false);
        this.setParameter("number bodies", 4.0);
        this.setParameter("gravity", 3.0);
        this.setParameter("elasticity", 0.8);
    }

    protected Thruster5Object createBlock(double width, double height) {
        return new ContactObject(width, height);
    }

    protected boolean showMomentum() {
        return false;
    }

    protected void reset() {
        int i;
        this.cvs.removeAllElements();
        this.m_Walls = new CRect(new DoubleRect(this.m_Left, this.m_Bottom, this.m_Right, this.m_Top));
        this.cvs.addElement(this.m_Walls);
        this.energyBar = new BarChart(this.cvs.getSimBounds());
        if (this.showEnergy) {
            this.cvs.addElement(this.energyBar);
        }
        this.bods = new Thruster5Object[this.numBods];
        for (i = 0; i < this.numBods; ++i) {
            this.bods[i] = this.createBlock(1.0, 3.0);
            this.bods[i].tMagnitude = this.thrust;
            this.cvs.addElement(this.bods[i]);
        }
        if (this.numBods > 0) {
            this.bods[0].moveTo(-2.0, -0.6, 1.0471975511965976);
            this.bods[0].color = Color.green;
        }
        if (this.numBods > 1) {
            this.bods[1].moveTo(2.0, 1.0, 0.5235987755982988);
            this.bods[1].color = Color.blue;
        }
        if (this.numBods > 2) {
            this.bods[2].moveTo(-0.5, 1.6, 0.1);
            this.bods[2].color = Color.lightGray;
        }
        if (this.numBods > 3) {
            this.bods[3].moveTo(-2.2, 2.5, 0.1);
            this.bods[3].color = Color.cyan;
        }
        if (this.numBods > 4) {
            this.bods[4].moveTo(2.4, -1.5, 1.3707963267948966);
            this.bods[4].color = Color.magenta;
        }
        if (this.numBods > 5) {
            this.bods[5].moveTo(2.0, 3.5, 1.8707963267948966);
            this.bods[5].color = Color.orange;
        }
        this.vars = new double[6 * this.numBods];
        this.calc = new boolean[this.vars.length];
        for (i = 0; i < this.calc.length; ++i) {
            this.calc[i] = true;
        }
        for (i = 0; i < this.numBods; ++i) {
            this.vars[6 * i] = this.bods[i].x;
            this.vars[6 * i + 2] = this.bods[i].y;
            this.vars[6 * i + 4] = this.bods[i].angle;
            double speed = 1.0;
            this.vars[6 * i + 1] = speed * (-0.5 + Math.random());
            this.vars[6 * i + 3] = speed * (-0.5 + Math.random());
            this.vars[6 * i + 5] = speed * (-0.5 + Math.random());
        }
    }

    public void evaluate(double[] x, double[] change) {
        super.evaluate(x, change);
        this.modifyObjects(x);
        Vector collisions = this.findAllCollisions();
        if (collisions != null) {
            throw new CollisionException(collisions);
        }
        this.findAllContacts(x);
        if (this.contactsFound.size() > 0) {
            for (int i = 0; i < this.contactsFound.size(); ++i) {
                Collision c = (Collision)this.contactsFound.elementAt(i);
                if (!c.colliding) continue;
                throw new IllegalStateException("unexpected collision at time=" + this.getTime());
            }
            double[] b = this.calculate_b_vector(this.contactsFound, change, x);
            double[][] A = this.calculate_a_matrix(this.contactsFound, change, x);
            try {
                double[] f = this.compute_forces(A, b);
                for (int i = 0; i < this.contactsFound.size(); ++i) {
                    Collision c = (Collision)this.contactsFound.elementAt(i);
                    this.applyContactForce(c, f[i], change);
                }
            }
            catch (IllegalStateException e) {
                System.out.println("caught " + e);
            }
        }
    }

    private void printMatrix(String s, double[][] m) {
        System.out.println(s);
        for (int i = 0; i < m.length; ++i) {
            this.printArray("[" + i + "]", m[i]);
        }
    }

    private void printArray(String s, double[] r) {
        this.nf.setMaximumFractionDigits(7);
        for (int i = 0; i < r.length; ++i) {
            s = s + " [" + i + "]=" + this.nf.format(r[i]);
        }
        System.out.println(s);
    }

    private void addWallContact(int obj, int normalObj, double impactX, double impactY, int corner) {
        Collision c = new Collision();
        c.impactX = impactX;
        c.impactY = impactY;
        c.object = obj;
        c.normalObj = normalObj;
        c.corner = corner;
        c.colliding = false;
        switch (normalObj) {
            case -2: {
                c.normalX = 0.0;
                c.normalY = 1.0;
                break;
            }
            case -4: {
                c.normalX = 0.0;
                c.normalY = -1.0;
                break;
            }
            case -3: {
                c.normalX = 1.0;
                c.normalY = 0.0;
                break;
            }
            case -1: {
                c.normalX = -1.0;
                c.normalY = 0.0;
            }
        }
        c.Rx = impactX - this.bods[obj].x;
        c.Ry = impactY - this.bods[obj].y;
        c.R2y = 0.0;
        c.R2x = 0.0;
        this.contactsFound.addElement(c);
    }

    private void checkForContact(int obj, int corner, double[] x) {
        double cornerY;
        double cornerX;
        switch (corner) {
            case 1: {
                cornerX = this.bods[obj].ax;
                cornerY = this.bods[obj].ay;
                break;
            }
            case 2: {
                cornerX = this.bods[obj].bx;
                cornerY = this.bods[obj].by;
                break;
            }
            case 3: {
                cornerX = this.bods[obj].cx;
                cornerY = this.bods[obj].cy;
                break;
            }
            case 4: {
                cornerX = this.bods[obj].dx;
                cornerY = this.bods[obj].dy;
                break;
            }
            default: {
                cornerX = 0.0;
                cornerY = 0.0;
            }
        }
        if (Math.abs(cornerX - this.m_Left) < 0.01 && Math.abs(x[6 * obj + 1] - x[6 * obj + 5] * (cornerY - x[6 * obj + 2])) < 0.5) {
            this.addWallContact(obj, -3, cornerX, cornerY, corner);
        }
        if (Math.abs(cornerX - this.m_Right) < 0.01 && Math.abs(x[6 * obj + 1] - x[6 * obj + 5] * (cornerY - x[6 * obj + 2])) < 0.5) {
            this.addWallContact(obj, -1, cornerX, cornerY, corner);
        }
        if (Math.abs(cornerY - this.m_Bottom) < 0.01 && Math.abs(x[6 * obj + 3] + x[6 * obj + 5] * (cornerX - x[6 * obj])) < 0.5) {
            this.addWallContact(obj, -2, cornerX, cornerY, corner);
        }
        if (Math.abs(cornerY - this.m_Top) < 0.01 && Math.abs(x[6 * obj + 3] + x[6 * obj + 5] * (cornerX - x[6 * obj])) < 0.5) {
            this.addWallContact(obj, -4, cornerX, cornerY, corner);
        }
        for (int i = 0; i < this.numBods; ++i) {
            if (i == obj) continue;
            ((ContactObject)this.bods[i]).testContacts(this.contactsFound, cornerX, cornerY, corner, obj, i, x);
        }
    }

    private void findAllContacts(double[] x) {
        int i;
        this.contactsFound.removeAllElements();
        for (i = 0; i < this.numBods; ++i) {
            this.bods[i].moveTo(x[6 * i + 0], x[6 * i + 2], x[6 * i + 4]);
        }
        for (i = 0; i < this.numBods; ++i) {
            for (int j = 1; j <= 4; ++j) {
                this.checkForContact(i, j, x);
            }
        }
    }

    private double[][] calculate_a_matrix(Vector contacts, double[] change, double[] x) {
        int nc = contacts.size();
        double[][] a = new double[nc][nc];
        for (int i = 0; i < nc; ++i) {
            Collision ci = (Collision)contacts.elementAt(i);
            double m1 = this.bods[ci.object].mass;
            double I1 = this.bods[ci.object].momentAboutCM();
            double m2 = ci.normalObj >= 0 ? this.bods[ci.normalObj].mass : Double.POSITIVE_INFINITY;
            double I2 = ci.normalObj >= 0 ? this.bods[ci.normalObj].momentAboutCM() : Double.POSITIVE_INFINITY;
            for (int j = 0; j < nc; ++j) {
                a[i][j] = 0.0;
                Collision cj = (Collision)contacts.elementAt(j);
                if (ci.object == cj.object) {
                    double[] dArray = a[i];
                    int n = j;
                    dArray[n] = dArray[n] + ci.normalX * (cj.normalX / m1 + (-ci.Ry * cj.Rx * cj.normalY + ci.Ry * cj.Ry * cj.normalX) / I1);
                    double[] dArray2 = a[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + ci.normalY * (cj.normalY / m1 + (-ci.Rx * cj.Ry * cj.normalX + ci.Rx * cj.Rx * cj.normalY) / I1);
                }
                if (ci.object == cj.normalObj) {
                    double[] dArray = a[i];
                    int n = j;
                    dArray[n] = dArray[n] - ci.normalX * (cj.normalX / m1 + (-ci.Ry * cj.R2x * cj.normalY + ci.Ry * cj.R2y * cj.normalX) / I1);
                    double[] dArray3 = a[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] - ci.normalY * (cj.normalY / m1 + (-ci.Rx * cj.R2y * cj.normalX + ci.Rx * cj.R2x * cj.normalY) / I1);
                }
                if (ci.normalObj >= 0 && ci.normalObj == cj.object) {
                    double[] dArray = a[i];
                    int n = j;
                    dArray[n] = dArray[n] - ci.normalX * (cj.normalX / m2 + (-ci.R2y * cj.Rx * cj.normalY + ci.R2y * cj.Ry * cj.normalX) / I2);
                    double[] dArray4 = a[i];
                    int n4 = j;
                    dArray4[n4] = dArray4[n4] - ci.normalY * (cj.normalY / m2 + (-ci.R2x * cj.Ry * cj.normalX + ci.R2x * cj.Rx * cj.normalY) / I2);
                }
                if (ci.normalObj < 0 || ci.normalObj != cj.normalObj) continue;
                double[] dArray = a[i];
                int n = j;
                dArray[n] = dArray[n] + ci.normalX * (cj.normalX / m2 + (-ci.R2y * cj.R2x * cj.normalY + ci.R2y * cj.R2y * cj.normalX) / I2);
                double[] dArray5 = a[i];
                int n5 = j;
                dArray5[n5] = dArray5[n5] + ci.normalY * (cj.normalY / m2 + (-ci.R2x * cj.R2y * cj.normalX + ci.R2x * cj.R2x * cj.normalY) / I2);
            }
        }
        return a;
    }

    private double[] calculate_b_vector(Vector contacts, double[] change, double[] x) {
        double[] b = new double[contacts.size()];
        for (int i = 0; i < contacts.size(); ++i) {
            double w2;
            b[i] = 0.0;
            Collision c = (Collision)contacts.elementAt(i);
            double w = x[c.object * 6 + 5];
            if (c.normalObj >= 0) {
                w2 = x[c.normalObj * 6 + 5];
                double v1x = x[c.object * 6 + 1] - w * c.Ry;
                double v1y = x[c.object * 6 + 3] + w * c.Rx;
                double v2x = x[c.normalObj * 6 + 1] - w2 * c.R2y;
                double v2y = x[c.normalObj * 6 + 3] + w2 * c.R2x;
                int n = i;
                b[n] = b[n] + 2.0 * w2 * (-c.normalY * (v1x - v2x) + c.normalX * (v1y - v2y));
            }
            int n = i;
            b[n] = b[n] + c.normalX * (change[c.object * 6 + 1] - w * w * c.Rx - change[c.object * 6 + 5] * c.Ry);
            int n2 = i;
            b[n2] = b[n2] + c.normalY * (change[c.object * 6 + 3] - w * w * c.Ry + change[c.object * 6 + 5] * c.Rx);
            if (c.normalObj < 0) continue;
            w2 = x[c.normalObj * 6 + 5];
            int n3 = i;
            b[n3] = b[n3] - c.normalX * (change[c.normalObj * 6 + 1] - w2 * w2 * c.R2x - change[c.normalObj * 6 + 5] * c.R2y);
            int n4 = i;
            b[n4] = b[n4] - c.normalY * (change[c.normalObj * 6 + 3] - w2 * w2 * c.R2y + change[c.normalObj * 6 + 5] * c.R2x);
        }
        return b;
    }

    private double[] compute_forces(double[][] A, double[] b) {
        int n = b.length;
        double[] f = new double[n];
        double[] a = new double[n];
        boolean[] C = new boolean[n];
        boolean[] NC = new boolean[n];
        for (int i = 0; i < n; ++i) {
            f[i] = 0.0;
            a[i] = b[i];
            NC[i] = false;
            C[i] = false;
        }
        for (int d = 0; d < n; ++d) {
            this.drive_to_zero(d, f, a, C, NC, A);
        }
        return f;
    }

    private void drive_to_zero(int d, double[] f, double[] a, boolean[] C, boolean[] NC, double[][] A) {
        int n = f.length;
        double[] delta_a = new double[n];
        double[] delta_f = new double[n];
        int loopCtr = 0;
        if (a[d] >= 0.0) {
            NC[d] = true;
        }
        while (a[d] < 0.0) {
            int j;
            if (++loopCtr > 200) {
                throw new IllegalStateException("drive_to_zero() loopCtr=" + loopCtr + " d=" + d + " a[d]=" + a[d]);
            }
            this.fdirection(delta_f, d, A, C);
            for (int i = 0; i < n; ++i) {
                delta_a[i] = 0.0;
                for (j = 0; j < n; ++j) {
                    int n2 = i;
                    delta_a[n2] = delta_a[n2] + A[i][j] * delta_f[j];
                }
                if (delta_a[i] < 0.0 && -1.0E-10 < delta_a[i]) {
                    delta_a[i] = 0.0;
                }
                if (!C[i] || !(Math.abs(delta_a[i]) > 1.0E-10)) continue;
                throw new IllegalStateException("fdirection failed, should be zero:  delta_a[" + i + "]=" + delta_a[i]);
            }
            double[] stepSize = new double[1];
            j = this.maxStep(f, a, delta_f, delta_a, d, C, NC, stepSize);
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                f[n3] = f[n3] + stepSize[0] * delta_f[i];
                int n4 = i;
                a[n4] = a[n4] + stepSize[0] * delta_a[i];
                if (f[i] < 0.0 && -1.0E-10 < f[i]) {
                    f[i] = 0.0;
                }
                if (a[i] < 0.0 && -1.0E-10 < a[i]) {
                    a[i] = 0.0;
                }
                if ((NC[i] || C[i]) && a[i] < 0.0) {
                    throw new IllegalStateException("acceleration cannot be negative,  a[" + i + "]=" + a[i]);
                }
                if (!(f[i] < 0.0)) continue;
                throw new IllegalStateException("reaction force cannot be negative,  f[" + i + "]=" + f[i]);
            }
            if (C[j]) {
                C[j] = false;
                NC[j] = true;
                continue;
            }
            if (NC[j]) {
                NC[j] = false;
                C[j] = true;
                continue;
            }
            C[j] = true;
            break;
        }
    }

    private void fdirection(double[] delta_f, int d, double[][] A, boolean[] C) {
        int n = C.length;
        for (int i = 0; i < n; ++i) {
            delta_f[i] = 0.0;
        }
        delta_f[d] = 1.0;
        int c = 0;
        for (int i = 0; i < n; ++i) {
            if (!C[i]) continue;
            ++c;
        }
        if (c > 0) {
            double[][] Acc = new double[c][c + 1];
            int p = 0;
            for (int i = 0; i < n; ++i) {
                if (!C[i]) continue;
                int q = 0;
                for (int j = 0; j < n; ++j) {
                    if (!C[j]) continue;
                    Acc[p][q] = A[i][j];
                    ++q;
                }
                Acc[p][c] = -A[i][d];
                ++p;
            }
            double[] x = new double[c];
            Utility.matrixSolve(Acc, x);
            p = 0;
            for (int i = 0; i < n; ++i) {
                if (!C[i]) continue;
                delta_f[i] = x[p++];
            }
        }
    }

    private int maxStep(double[] f, double[] a, double[] delta_f, double[] delta_a, int d, boolean[] C, boolean[] NC, double[] stepSize) {
        double sPrime;
        int i;
        double s = Double.POSITIVE_INFINITY;
        int j = -1;
        int n = f.length;
        if (delta_a[d] > 0.0) {
            j = d;
            s = -a[d] / delta_a[d];
        }
        for (i = 0; i < n; ++i) {
            if (!C[i] || !(delta_f[i] < 0.0) || !((sPrime = -f[i] / delta_f[i]) < s)) continue;
            s = sPrime;
            j = i;
        }
        for (i = 0; i < n; ++i) {
            if (!NC[i] || !(delta_a[i] < 0.0) || !((sPrime = -a[i] / delta_a[i]) < s)) continue;
            s = sPrime;
            j = i;
        }
        if (s < 0.0) {
            throw new IllegalStateException("maxStep negative.  d=" + d + " s=" + s);
        }
        stepSize[0] = s;
        return j;
    }

    private void applyContactForce(Collision c, double f, double[] change) {
        if (f == 0.0) {
            return;
        }
        CVector v = new CVector(c.impactX, c.impactY, c.normalX * f, c.normalY * f);
        v.m_Color = Color.red;
        this.cvs.addElement(v);
        this.rxnForces.addElement(v);
        int obj = c.object;
        double invMass = this.bods[obj].invMass();
        double invMoment = this.bods[obj].invMomentAboutCM();
        int n = 6 * obj + 1;
        change[n] = change[n] + c.normalX * f * invMass;
        int n2 = 6 * obj + 3;
        change[n2] = change[n2] + c.normalY * f * invMass;
        int n3 = 6 * obj + 5;
        change[n3] = change[n3] + (-c.Ry * c.normalX * f + c.Rx * c.normalY * f) * invMoment;
        obj = c.normalObj;
        if (obj >= 0) {
            invMass = this.bods[obj].invMass();
            invMoment = this.bods[obj].invMomentAboutCM();
            int n4 = 6 * obj + 1;
            change[n4] = change[n4] - c.normalX * f * invMass;
            int n5 = 6 * obj + 3;
            change[n5] = change[n5] - c.normalY * f * invMass;
            int n6 = 6 * obj + 5;
            change[n6] = change[n6] - (-c.R2y * c.normalX * f + c.R2x * c.normalY * f) * invMoment;
        }
    }
}

