/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class DangleStick
extends Simulation
implements ActionListener {
    private CMass m_Mass1;
    private CMass m_Mass2;
    private CSpring m_Spring;
    private CSpring m_Stick;
    private double gravity = 9.8;
    private JButton button_stop;
    private static final String MASS1 = "upper mass";
    private static final String MASS2 = "lower mass";
    private static final String GRAVITY = "gravity";
    private static final String STICK_LENGTH = "stick length";
    private static final String SPRING_LENGTH = "spring rest length";
    private static final String STIFFNESS = "spring stiffness";
    private String[] params = new String[]{"upper mass", "lower mass", "spring stiffness", "spring rest length", "stick length", "gravity"};

    public DangleStick(Container container) {
        super(container, 6);
        this.var_names = new String[]{"spring angle", "spring angle vel", "spring length", "spring length vel", "stick angle", "stick angle vel"};
        this.setCoordMap(new CoordMap(-1, -2.0, 2.0, -4.0, 2.0, 0, 0));
        double w = 0.3;
        this.m_Mass1 = new CMass(0.4, -1.2, w, w, 2);
        this.m_Mass1.m_Mass = 0.5;
        this.cvs.addElement(this.m_Mass1);
        this.m_Stick = new CSpring(0.4, -1.2, 1.0, 0.4);
        this.m_Stick.m_DrawMode = 4;
        this.cvs.addElement(this.m_Stick);
        this.m_Mass2 = new CMass(0.4, -2.2, w, w, 2);
        this.m_Mass2.m_Mass = 0.5;
        this.m_Mass2.m_Damping = 0.0;
        this.cvs.addElement(this.m_Mass2);
        this.m_Spring = new CSpring(0.0, 0.0, 1.0, 0.4);
        this.m_Spring.m_SpringConst = 20.0;
        this.cvs.addElement(this.m_Spring);
        this.vars[0] = 0.5235987755982988;
        this.vars[1] = 0.0;
        this.vars[2] = 2.0;
        this.vars[3] = 0.0;
        this.vars[4] = -0.5235987755982988;
        this.vars[5] = 0.0;
        this.modifyObjects();
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 1);
        }
        this.showGraph(false);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS1)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            this.m_Mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            this.m_Spring.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(SPRING_LENGTH)) {
            this.m_Spring.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(STICK_LENGTH)) {
            this.m_Stick.m_RestLength = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS1)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            return this.m_Mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.m_Spring.m_SpringConst;
        }
        if (name.equalsIgnoreCase(SPRING_LENGTH)) {
            return this.m_Spring.m_RestLength;
        }
        if (name.equalsIgnoreCase(STICK_LENGTH)) {
            return this.m_Stick.m_RestLength;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.stop();
        }
    }

    private void stop() {
        this.vars[5] = 0.0;
        this.vars[4] = 0.0;
        this.vars[3] = 0.0;
        this.vars[1] = 0.0;
        this.vars[0] = 0.0;
        double r = this.gravity * (this.m_Mass1.m_Mass + this.m_Mass2.m_Mass) / this.m_Spring.m_SpringConst;
        this.vars[2] = this.m_Spring.m_RestLength + r;
    }

    public void modifyObjects() {
        double w = this.m_Mass1.m_Width / 2.0;
        this.m_Mass1.setX1(this.vars[2] * Math.sin(this.vars[0]) - w);
        this.m_Mass1.setY1(-this.vars[2] * Math.cos(this.vars[0]) - w);
        double L = this.m_Stick.m_RestLength;
        this.m_Mass2.setX1(this.m_Mass1.m_X1 + L * Math.sin(this.vars[4]));
        this.m_Mass2.setY1(this.m_Mass1.m_Y1 - L * Math.cos(this.vars[4]));
        this.m_Spring.setX2(this.m_Mass1.m_X1 + w);
        this.m_Spring.setY2(this.m_Mass1.m_Y1 + w);
        this.m_Stick.setX1(this.m_Mass1.m_X1 + w);
        this.m_Stick.setY1(this.m_Mass1.m_Y1 + w);
        this.m_Stick.setX2(this.m_Mass2.m_X1 + w);
        this.m_Stick.setY2(this.m_Mass2.m_Y1 + w);
    }

    public void startDrag(Dragable e) {
        for (int i = 0; i < this.vars.length; ++i) {
            this.calc[i] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        double w = this.m_Mass1.m_Width / 2.0;
        if (e == this.m_Mass1) {
            double th;
            double xx = x + w;
            double yy = y + w;
            this.vars[0] = th = Math.atan2(xx, -yy);
            this.vars[2] = Math.sqrt(xx * xx + yy * yy);
            this.vars[1] = 0.0;
            this.vars[3] = 0.0;
            this.vars[5] = 0.0;
        } else if (e == this.m_Mass2) {
            double th;
            double x1 = this.vars[2] * Math.sin(this.vars[0]);
            double y1 = -this.vars[2] * Math.cos(this.vars[0]);
            double x2 = x + w;
            double y2 = y + w;
            this.vars[4] = th = Math.atan2(x2 - x1, -(y2 - y1));
            this.vars[1] = 0.0;
            this.vars[3] = 0.0;
            this.vars[5] = 0.0;
        }
    }

    public void evaluate(double[] x, double[] change) {
        double m2 = this.m_Mass2.m_Mass;
        double m1 = this.m_Mass1.m_Mass;
        double L = this.m_Stick.m_RestLength;
        double k = this.m_Spring.m_SpringConst;
        double b = this.m_Spring.m_RestLength;
        change[0] = x[1];
        change[2] = x[3];
        change[4] = x[5];
        double sum = -4.0 * m1 * (m1 + m2) * x[3] * x[1];
        sum += 2.0 * m1 * m2 * L * x[5] * x[5] * Math.sin(x[4] - x[0]);
        sum -= 2.0 * this.gravity * m1 * (m1 + m2) * Math.sin(x[0]);
        sum += k * m2 * (b - x[2]) * Math.sin(2.0 * (x[0] - x[4]));
        change[1] = sum /= 2.0 * m1 * (m1 + m2) * x[2];
        sum = 2.0 * b * k * m1 + b * k * m2 - 2.0 * k * m1 * x[2] - k * m2 * x[2];
        sum -= k * m2 * (b - x[2]) * Math.cos(2.0 * (x[0] - x[4]));
        sum += 2.0 * L * m1 * m2 * Math.cos(x[4] - x[0]) * x[5] * x[5];
        sum /= 2.0 * m1 * (m1 + m2);
        sum += x[2] * x[1] * x[1];
        change[3] = sum += this.gravity * Math.cos(x[0]);
        change[5] = k * (b - x[2]) * Math.sin(x[4] - x[0]) / (L * m1);
    }
}

