/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.MoveableDoublePendulumCanvas;
import com.myphysicslab.simlab.SimCanvas;
import com.myphysicslab.simlab.Simulation;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class MoveableDoublePendulum
extends Simulation
implements ActionListener {
    private CMass m_Mass1;
    private CMass m_Mass2;
    private CMass topMass;
    private CSpring m_Stick1;
    private CSpring m_Stick2;
    private double gravity = 9.8;
    private JButton button_stop;
    private boolean mouseDown = false;
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private double damping1 = 0.5;
    private double damping2 = 0.5;
    private double stiffness = 3.0;
    private double anchorDamping = 0.8;
    private static final String MASS1 = "mass1";
    private static final String MASS2 = "mass2";
    private static final String LENGTH1 = "stick1 length";
    private static final String LENGTH2 = "stick2 length";
    private static final String GRAVITY = "gravity";
    private static final String DAMPING1 = "damping1";
    private static final String DAMPING2 = "damping2";
    private static final String STIFFNESS = "mouse spring stiffness";
    private static final String ANCHOR_DAMPING = "anchor damping";
    private String[] params = new String[]{"mass1", "mass2", "stick1 length", "stick2 length", "gravity", "damping1", "damping2", "mouse spring stiffness", "anchor damping"};
    double period = 5.0;

    public MoveableDoublePendulum(Container container) {
        super(container, 9);
        this.var_names = new String[]{"angle1", "angle1 velocity", "angle2", "angle2 velocity", "time", "anchorX", "anchorX velocity", "anchorY", "anchorY velocity"};
        this.setCoordMap(new CoordMap(-1, -4.0, 4.0, -2.2, 1.5, 0, 0));
        double xx = 0.0;
        double yy = 0.0;
        double w = 0.5;
        this.topMass = new CMass(xx - w / 2.0, yy - w / 2.0, w, w, 1);
        this.topMass.m_Color = Color.red;
        this.cvs.addElement(this.topMass);
        this.m_Stick1 = new CSpring(0.0, 0.0, 1.0, 0.4);
        this.m_Stick1.m_DrawMode = 4;
        this.cvs.addElement(this.m_Stick1);
        this.m_Stick2 = new CSpring(0.0, 0.0, 1.0, 0.4);
        this.m_Stick2.m_DrawMode = 4;
        this.cvs.addElement(this.m_Stick2);
        w = 0.2;
        this.m_Mass1 = new CMass(0.0, 0.0, w, w, 5);
        this.m_Mass1.m_Mass = 0.5;
        this.m_Mass1.m_Color = Color.blue;
        this.cvs.addElement(this.m_Mass1);
        this.m_Mass2 = new CMass(0.0, 0.0, w, w, 5);
        this.m_Mass2.m_Mass = 0.5;
        this.m_Mass2.m_Damping = 0.0;
        this.m_Mass2.m_Color = Color.blue;
        this.cvs.addElement(this.m_Mass2);
        this.vars[3] = 0.0;
        this.vars[2] = 0.0;
        this.vars[1] = 0.0;
        this.vars[0] = 0.0;
        this.vars[4] = 0.0;
        this.vars[5] = 0.0;
        this.vars[6] = 0.0;
        this.vars[7] = 0.0;
        this.vars[8] = 0.0;
        this.modifyObjects();
    }

    protected SimCanvas makeSimCanvas() {
        return new MoveableDoublePendulumCanvas(this);
    }

    public void setupControls() {
        super.setupControls();
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.vars[3] = 0.0;
            this.vars[2] = 0.0;
            this.vars[1] = 0.0;
            this.vars[0] = 0.0;
            this.vars[4] = 0.0;
            this.vars[5] = 0.0;
            this.vars[6] = 0.0;
            this.vars[7] = 0.0;
            this.vars[8] = 0.0;
        }
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 2);
            this.graph.setDrawMode(0);
        }
    }

    protected void setValue(int param, double value) {
        switch (param) {
            case 0: {
                this.m_Mass1.m_Mass = value;
                break;
            }
            case 1: {
                this.m_Mass2.m_Mass = value;
                break;
            }
            case 2: {
                this.m_Stick1.m_RestLength = value;
                break;
            }
            case 3: {
                this.m_Stick2.m_RestLength = value;
                break;
            }
            case 4: {
                this.gravity = value;
                break;
            }
            case 5: {
                this.damping1 = value;
                break;
            }
            case 6: {
                this.damping2 = value;
                break;
            }
            case 7: {
                this.stiffness = value;
                break;
            }
            case 8: {
                this.anchorDamping = value;
            }
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS1)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            this.m_Mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH1)) {
            this.m_Stick1.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH2)) {
            this.m_Stick2.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING1)) {
            this.damping1 = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING2)) {
            this.damping2 = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            this.stiffness = value;
            return true;
        }
        if (name.equalsIgnoreCase(ANCHOR_DAMPING)) {
            this.anchorDamping = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS1)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            return this.m_Mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(LENGTH1)) {
            return this.m_Stick1.m_RestLength;
        }
        if (name.equalsIgnoreCase(LENGTH2)) {
            return this.m_Stick2.m_RestLength;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        if (name.equalsIgnoreCase(DAMPING1)) {
            return this.damping1;
        }
        if (name.equalsIgnoreCase(DAMPING2)) {
            return this.damping2;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.stiffness;
        }
        if (name.equalsIgnoreCase(ANCHOR_DAMPING)) {
            return this.anchorDamping;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void modifyObjects() {
        if (this.vars[0] > Math.PI) {
            this.vars[0] = this.vars[0] - Math.PI * 2 * Math.floor(this.vars[0] / Math.PI);
        } else if (this.vars[0] < -Math.PI) {
            this.vars[0] = this.vars[0] - Math.PI * 2 * Math.ceil(this.vars[0] / Math.PI);
        }
        if (this.vars[2] > Math.PI) {
            this.vars[2] = this.vars[2] - Math.PI * 2 * Math.floor(this.vars[2] / Math.PI);
        } else if (this.vars[2] < -Math.PI) {
            this.vars[2] = this.vars[2] - Math.PI * 2 * Math.ceil(this.vars[2] / Math.PI);
        }
        this.topMass.setPosition(this.vars[5] - this.topMass.m_Width / 2.0, this.vars[7] - this.topMass.m_Height / 2.0);
        double x0 = this.topMass.m_X1 + this.topMass.m_Width / 2.0;
        double y0 = this.topMass.m_Y1 + this.topMass.m_Height / 2.0;
        double w = this.m_Mass1.m_Width / 2.0;
        double L1 = this.m_Stick1.m_RestLength;
        double L2 = this.m_Stick2.m_RestLength;
        double th1 = this.vars[0];
        double th2 = this.vars[2];
        double x1 = x0 + L1 * Math.sin(th1);
        double y1 = y0 - L1 * Math.cos(th1);
        double x2 = x1 + L2 * Math.sin(th2);
        double y2 = y1 - L2 * Math.cos(th2);
        this.m_Stick1.setBounds(x0, y0, x1, y1);
        this.m_Mass1.setPosition(x1 - w, y1 - w);
        this.m_Stick2.setBounds(x1, y1, x2, y2);
        this.m_Mass2.setPosition(x2 - w, y2 - w);
    }

    public void startDrag(Dragable e) {
        if (e == this.topMass) {
            this.mouseDown = true;
        }
        if (e == this.m_Mass1 || e == this.m_Mass2) {
            this.calc[3] = false;
            this.calc[2] = false;
            this.calc[1] = false;
            this.calc[0] = false;
        }
    }

    public void finishDrag(Dragable e) {
        super.finishDrag(e);
        if (e == this.topMass) {
            this.mouseDown = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        double x0 = this.vars[5];
        double y0 = this.vars[7];
        double w = this.m_Mass1.m_Width / 2.0;
        if (e == this.topMass) {
            this.mouseX = x;
            this.mouseY = y;
        } else if (e == this.m_Mass1) {
            double th1;
            double xx = x - x0 + w;
            double yy = y - y0 + w;
            this.vars[0] = th1 = Math.atan2(xx, -yy);
            this.vars[1] = 0.0;
            this.vars[3] = 0.0;
            this.modifyObjects();
        } else if (e == this.m_Mass2) {
            double L1 = this.m_Stick1.m_RestLength;
            double L2 = this.m_Stick2.m_RestLength;
            double x1 = x0 + L1 * Math.sin(this.vars[0]);
            double y1 = y0 - L1 * Math.cos(this.vars[0]);
            double x2 = x + w;
            double y2 = y + w;
            double th2 = Math.atan2(x2 - x1, -(y2 - y1));
            this.vars[1] = 0.0;
            this.vars[2] = th2;
            this.vars[3] = 0.0;
            this.modifyObjects();
        }
    }

    public void evaluate(double[] x, double[] change) {
        change[4] = 1.0;
        change[5] = x[6];
        change[6] = -this.anchorDamping * x[6] + (this.mouseDown ? this.stiffness * (this.mouseX - x[5]) : 0.0);
        change[7] = x[8];
        change[8] = -this.anchorDamping * x[8] + (this.mouseDown ? this.stiffness * (this.mouseY - x[7]) : 0.0);
        double ddx0 = change[6];
        double ddy0 = change[8];
        double th1 = x[0];
        double dth1 = x[1];
        double th2 = x[2];
        double dth2 = x[3];
        double m2 = this.m_Mass2.m_Mass;
        double m1 = this.m_Mass1.m_Mass;
        double L1 = this.m_Stick1.m_RestLength;
        double L2 = this.m_Stick2.m_RestLength;
        double g = this.gravity;
        double b = this.damping1;
        double b2 = this.damping2;
        change[0] = dth1;
        change[1] = -((2.0 * b * dth1 + ddx0 * L1 * (2.0 * m1 + m2) * Math.cos(th1) - ddx0 * L1 * m2 * Math.cos(th1 - 2.0 * th2) + 2.0 * ddy0 * L1 * m1 * Math.sin(th1) + 2.0 * g * L1 * m1 * Math.sin(th1) + ddy0 * L1 * m2 * Math.sin(th1) + g * L1 * m2 * Math.sin(th1) + ddy0 * L1 * m2 * Math.sin(th1 - 2.0 * th2) + g * L1 * m2 * Math.sin(th1 - 2.0 * th2) + 2.0 * dth2 * dth2 * L1 * L2 * m2 * Math.sin(th1 - th2) + dth1 * dth1 * L1 * L1 * m2 * Math.sin(2.0 * (th1 - th2))) / (L1 * L1 * (2.0 * m1 + m2 - m2 * Math.cos(2.0 * (th1 - th2)))));
        change[2] = dth2;
        change[3] = -((2.0 * b * dth1 * L2 * m2 * Math.cos(th1 - th2) - b2 * (dth1 - dth2) * L1 * m2 * Math.cos(2.0 * (th1 - th2)) + L1 * (2.0 * b2 * dth1 * m1 - 2.0 * b2 * dth2 * m1 + b2 * dth1 * m2 - b2 * dth2 * m2 + ddx0 * L2 * m2 * (m1 + m2) * Math.cos(2.0 * th1 - th2) - ddx0 * L2 * m2 * (m1 + m2) * Math.cos(th2) + 2.0 * dth1 * dth1 * L1 * L2 * m1 * m2 * Math.sin(th1 - th2) + 2.0 * dth1 * dth1 * L1 * L2 * m2 * m2 * Math.sin(th1 - th2) + dth2 * dth2 * L2 * L2 * m2 * m2 * Math.sin(2.0 * (th1 - th2)) + ddy0 * L2 * m1 * m2 * Math.sin(2.0 * th1 - th2) + g * L2 * m1 * m2 * Math.sin(2.0 * th1 - th2) + ddy0 * L2 * m2 * m2 * Math.sin(2.0 * th1 - th2) + g * L2 * m2 * m2 * Math.sin(2.0 * th1 - th2) - ddy0 * L2 * m1 * m2 * Math.sin(th2) - g * L2 * m1 * m2 * Math.sin(th2) - ddy0 * L2 * m2 * m2 * Math.sin(th2) - g * L2 * m2 * m2 * Math.sin(th2))) / (L1 * L2 * L2 * m2 * (-2.0 * m1 - m2 + m2 * Math.cos(2.0 * (th1 - th2)))));
    }

    public void drawRubberBand(Graphics g, ConvertMap map) {
        if (this.mouseDown) {
            g.setColor(Color.red);
            g.drawLine(map.simToScreenX(this.mouseX), map.simToScreenY(this.mouseY), map.simToScreenX(this.topMass.getCenterX()), map.simToScreenY(this.topMass.getCenterY()));
        }
    }
}

