/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.BarChart;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.MyCheckbox;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class PendulumCart
extends Simulation
implements ActionListener {
    private CMass cart;
    private CMass pendulum;
    private CSpring rod;
    private CSpring spring;
    private BarChart chart;
    private boolean showEnergy = true;
    private double gravity = 9.8;
    private double damping_cart = 0.1;
    private double damping_pendulum = 0.1;
    private JButton button_stop;
    private static final String MASS_CART = "cart mass";
    private static final String MASS_PENDULUM = "pendulum mass";
    private static final String DAMPING_CART = "cart damping";
    private static final String DAMPING_PENDULUM = "pendulum damping";
    private static final String LENGTH_PENDULUM = "pendulum length";
    private static final String STIFFNESS = "spring stiffness";
    private static final String GRAVITY = "gravity";
    private static final String SHOW_ENERGY = "show energy";
    private String[] params = new String[]{"cart mass", "pendulum mass", "pendulum length", "spring stiffness", "gravity", "cart damping", "pendulum damping", "show energy"};

    public PendulumCart(Container container) {
        super(container, 5);
        this.var_names = new String[]{"cart position", "pendulum angle", "cart velocity", "angle velocity", "work done by damping"};
        this.setCoordMap(new CoordMap(-1, -3.0, 3.0, -2.0, 2.0, 0, 0));
        double len = 1.0;
        this.rod = new CSpring(0.0, 0.0, len, 0.4);
        this.rod.m_DrawMode = 4;
        this.rod.m_SpringConst = 6.0;
        this.cvs.addElement(this.rod);
        double w = 0.3;
        this.cart = new CMass(-w / 2.0, -w / 2.0, w, w, 1);
        this.cart.m_Mass = 1.0;
        this.cvs.addElement(this.cart);
        this.pendulum = new CMass(-w / 2.0 - Math.sin(0.0) * len, w / 2.0 - Math.cos(0.0) * len, w, w, 2);
        this.rod.setX2(this.pendulum.m_X2 + w / 2.0);
        this.rod.setY2(this.pendulum.m_Y2 + w / 2.0);
        this.pendulum.m_Mass = 1.0;
        this.pendulum.m_Damping = 0.0;
        this.cvs.addElement(this.pendulum);
        this.spring = new CSpring(3.0, 0.0, 3.0, 0.4);
        this.spring.m_SpringConst = 6.0;
        this.cvs.addElement(this.spring);
        this.chart = new BarChart(this.cvs.getSimBounds());
        this.chart.tes = "kinetic energy";
        if (this.showEnergy) {
            this.cvs.addElement(this.chart);
        }
        this.stop();
        this.vars[1] = 0.39269908169872414;
        this.modifyObjects();
        this.initWork();
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        for (int i = 0; i < this.params.length - 1; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.addObserverControl(new MyCheckbox(this, SHOW_ENERGY));
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 1);
            this.showGraph(true);
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS_CART)) {
            this.cart.m_Mass = value;
            this.initWork();
            return true;
        }
        if (name.equalsIgnoreCase(MASS_PENDULUM)) {
            this.pendulum.m_Mass = value;
            this.initWork();
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING_CART)) {
            this.damping_cart = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING_PENDULUM)) {
            this.damping_pendulum = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            this.spring.m_SpringConst = value;
            this.initWork();
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH_PENDULUM)) {
            this.rod.m_RestLength = value;
            this.initWork();
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            this.initWork();
            return true;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            this.showEnergy = value != 0.0;
            boolean chartVisible = this.cvs.containsElement(this.chart);
            if (this.showEnergy && !chartVisible) {
                this.cvs.addElement(this.chart);
            } else if (!this.showEnergy && chartVisible) {
                this.cvs.removeElement(this.chart);
            }
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS_CART)) {
            return this.cart.m_Mass;
        }
        if (name.equalsIgnoreCase(MASS_PENDULUM)) {
            return this.pendulum.m_Mass;
        }
        if (name.equalsIgnoreCase(DAMPING_CART)) {
            return this.damping_cart;
        }
        if (name.equalsIgnoreCase(DAMPING_PENDULUM)) {
            return this.damping_pendulum;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.spring.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH_PENDULUM)) {
            return this.rod.m_RestLength;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            return this.showEnergy ? 1.0 : 0.0;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.stop();
        }
    }

    private void stop() {
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i] = 0.0;
        }
    }

    public void setVariable(int i, double value) {
        super.setVariable(i, value);
        this.initWork();
    }

    private void initWork() {
        this.vars[4] = 0.0;
        this.calcEnergy();
        this.chart.setWorkZero(this.chart.te + this.chart.pe);
    }

    private void calcEnergy() {
        this.chart.te = 0.5 * this.cart.m_Mass * this.vars[2] * this.vars[2];
        double csh = Math.cos(this.vars[1]);
        double snh = Math.sin(this.vars[1]);
        double d1 = this.vars[2] + this.rod.m_RestLength * this.vars[3] * csh;
        double d2 = this.rod.m_RestLength * this.vars[3] * snh;
        this.chart.te += 0.5 * this.pendulum.m_Mass * (d1 * d1 + d2 * d2);
        this.chart.pe = 0.5 * this.spring.m_SpringConst * this.vars[0] * this.vars[0];
        this.chart.pe += this.pendulum.m_Mass * this.gravity * this.rod.m_RestLength * (1.0 - csh);
        this.chart.work = this.vars[4];
    }

    public void modifyObjects() {
        double w = this.cart.m_Width / 2.0;
        this.cart.setX1(this.vars[0] - w);
        double L = this.rod.m_RestLength;
        this.pendulum.setX1(this.cart.m_X1 + L * Math.sin(this.vars[1]));
        this.pendulum.setY1(this.cart.m_Y1 - L * Math.cos(this.vars[1]));
        this.rod.setX1(this.cart.m_X1 + w);
        this.rod.setX2(this.pendulum.m_X1 + w);
        this.rod.setY2(this.pendulum.m_Y1 + w);
        this.spring.setX2(this.cart.m_X1 + w);
        this.calcEnergy();
    }

    public void startDrag(Dragable e) {
        for (int i = 0; i < this.vars.length; ++i) {
            this.calc[i] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        double w = this.cart.m_Width / 2.0;
        if (e == this.cart) {
            this.vars[0] = x + w;
            this.vars[2] = 0.0;
            this.initWork();
        } else if (e == this.pendulum) {
            double th;
            double x1 = this.vars[0];
            double y1 = -w;
            double x2 = x + w;
            double y2 = y;
            this.vars[1] = th = Math.atan2(x2 - x1, -(y2 - y1));
            this.vars[3] = 0.0;
            this.initWork();
        }
    }

    public void evaluate(double[] x, double[] change) {
        double m = this.pendulum.m_Mass;
        double M = this.cart.m_Mass;
        double L = this.rod.m_RestLength;
        double k = this.spring.m_SpringConst;
        double sh = Math.sin(x[1]);
        double csh = Math.cos(x[1]);
        double cs2h = csh * csh - sh * sh;
        change[0] = x[2];
        change[1] = x[3];
        double numer = m * x[3] * x[3] * L * sh + m * this.gravity * sh * csh - k * x[0] - this.damping_cart * x[2] + this.damping_pendulum * x[3] * csh / L;
        change[2] = numer / (M + m * sh * sh);
        numer = -m * x[3] * x[3] * L * sh * csh + k * x[0] * csh - (M + m) * this.gravity * sh + this.damping_cart * x[2] * csh;
        change[3] = (numer += -(m + M) * this.damping_pendulum * x[3] / (m * L)) / (L * (M + m * sh * sh));
        change[4] = -this.damping_cart * x[2] * x[2] - this.damping_pendulum * x[3] * x[3];
    }
}

