/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CBitmap;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CPath;
import com.myphysicslab.simlab.CPoint;
import com.myphysicslab.simlab.CText;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.MyCheckbox;
import com.myphysicslab.simlab.MyChoice;
import com.myphysicslab.simlab.ObjectListener;
import com.myphysicslab.simlab.PathName;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Vector;

public class Roller5
extends Simulation
implements ObjectListener {
    protected CMass m_Mass1;
    protected CBitmap m_TrackBM = null;
    protected double gravity = 2.0;
    protected CPath m_Path = null;
    protected CPoint m_Point = new CPoint();
    protected CText m_Text = null;
    protected int m_Path_Num = 0;
    protected boolean showEnergy = false;
    protected static final String MASS = "mass";
    protected static final String DAMPING = "damping";
    protected static final String GRAVITY = "gravity";
    protected static final String PATH = "path";
    protected static final String SHOW_ENERGY = "show energy";
    protected MyChoice pathControl;
    private String[] params = new String[]{"mass", "damping", "gravity", "path", "show energy"};

    public Roller5(Container app, int the_path) {
        super(app, 3);
        this.setCoordMap(new CoordMap(-1, 0.0, 1.0, 0.0, 1.0, 0, 0));
        this.var_names = new String[]{"x-position", "x-velocity", "position", "velocity"};
        this.createElements();
        this.set_path(the_path);
        this.modifyObjects();
        this.cvs.setObjectListener(this);
    }

    public void setupControls() {
        super.setupControls();
        this.pathControl = new MyChoice(this, PATH, this.m_Path_Num, 0.0, PathName.getPathNames());
        this.addObserverControl(this.pathControl);
        this.addObserverControl(new DoubleField(this, MASS, 2));
        this.addObserverControl(new DoubleField(this, DAMPING, 2));
        this.addObserverControl(new DoubleField(this, GRAVITY, 2));
        this.addObserverControl(new MyCheckbox(this, SHOW_ENERGY));
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(2, 3);
        }
    }

    protected void createElements() {
        this.m_Text = new CText(0.0, 0.0, "energy ");
        if (this.showEnergy) {
            this.cvs.addElement(this.m_Text);
        }
        this.m_Mass1 = new CMass(1.0, 1.0, 0.3, 0.3, 5);
        this.m_Mass1.m_Mass = 0.5;
        this.m_Mass1.m_Damping = 0.0;
        this.cvs.addElement(this.m_Mass1);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.m_Mass1.m_Damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(PATH)) {
            this.set_path((int)value);
            this.modifyObjects();
            return true;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            boolean wantEnergy;
            boolean bl = wantEnergy = value != 0.0;
            if (wantEnergy && !this.showEnergy) {
                this.cvs.addElement(this.m_Text);
            } else if (!wantEnergy && this.showEnergy) {
                this.cvs.removeElement(this.m_Text);
            }
            this.showEnergy = wantEnergy;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.m_Mass1.m_Damping;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        if (name.equalsIgnoreCase(PATH)) {
            return this.m_Path_Num;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            return this.showEnergy ? 1.0 : 0.0;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public int numVariables() {
        return this.var_names.length;
    }

    public double getVariable(int i) {
        if (i <= 2) {
            return this.vars[i];
        }
        if (i == 3) {
            double x = this.vars[0];
            double d = -2.3333333333333335 * x + 0.6666666666666666 * x * x * x;
            return Math.sqrt(1.0 + d * d) * this.vars[1];
        }
        return 0.0;
    }

    protected void resetTrackBitmap() {
        if (this.m_TrackBM != null) {
            this.cvs.removeElement(this.m_TrackBM);
        }
        this.m_TrackBM = new CBitmap(this.container, this.m_Path);
        Rectangle r = this.cvs.getConvertMap().getScreenRect();
        this.m_TrackBM.setGraphicsTopLeft(r.x, r.y);
        this.cvs.prependElement(this.m_TrackBM);
    }

    protected void set_path(int the_path) {
        System.out.println("path = " + the_path);
        PathName[] pNames = PathName.getPathNames();
        if (the_path >= 0 && the_path < pNames.length) {
            this.m_Path_Num = the_path;
            this.m_Path = CPath.makePath(pNames[the_path]);
            System.out.println("m_Path = " + this.m_Path);
            this.cvs.getCoordMap().setRange(this.m_Path.left, this.m_Path.right, this.m_Path.bottom, this.m_Path.top);
            this.resetTrackBitmap();
            if (this.graph != null) {
                this.graph.reset();
            }
        } else {
            throw new IllegalArgumentException("no such path number " + the_path);
        }
        DoubleRect r = this.cvs.getConvertMap().getSimBounds();
        this.m_Text.setX1(r.getXMin() + r.getWidth() * 0.1);
        this.m_Text.setY1(r.getYMax() - r.getHeight() * 0.1);
        this.vars[0] = 3.0;
        this.vars[1] = 0.0;
    }

    public void objectChanged(Object o) {
        if (this.cvs == o) {
            this.resetTrackBitmap();
        }
    }

    public void modifyObjects() {
        double x = this.vars[0];
        double y = 3.0 - x * x * 7.0 / 6.0 + x * x * x * x / 6.0;
        this.m_Mass1.setCenterX(x);
        this.m_Mass1.setCenterY(y);
    }

    protected double getEnergy() {
        double e = 0.5 * this.m_Mass1.m_Mass * this.vars[1] * this.vars[1];
        return e += this.m_Mass1.m_Mass * this.gravity * this.m_Mass1.getCenterY();
    }

    public void startDrag(Dragable e) {
        if (e == this.m_Mass1) {
            this.calc[0] = false;
            this.calc[1] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.m_Mass1) {
            double w = this.m_Mass1.m_Width / 2.0;
            this.vars[0] = this.m_Path.map_x_y_to_p(x + w, y + w);
            this.vars[1] = 0.0;
            this.modifyObjects();
        }
    }

    public void evaluate(double[] x, double[] change) {
        double x2 = x[0] * x[0];
        change[0] = x[1];
        double r = -(x[0] * (-7.0 + 2.0 * x2) * (3.0 * this.gravity + (-7.0 + 6.0 * x2) * x[1] * x[1]));
        change[1] = r / (9.0 + 49.0 * x2 - 28.0 * x2 * x2 + 4.0 * x2 * x2 * x2);
        double d = -2.3333333333333335 * x[0] + 0.6666666666666666 * x[0] * x[0] * x[0];
        change[2] = Math.sqrt(1.0 + d * d) * x[1];
    }

    public Vector findAllCollisions() {
        return null;
    }

    public void handleCollisions(Vector collisions) {
    }
}

