/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.SimPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class SimLayout
implements LayoutManager {
    private final int SPACER = 5;
    private boolean debug = false;

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container target) {
        return new Dimension(500, 500);
    }

    public Dimension minimumLayoutSize(Container target) {
        return new Dimension(100, 100);
    }

    private int countNumPanels(Container target) {
        int numPanels = 0;
        int n = target.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(target.getComponent(i) instanceof SimPanel)) continue;
            ++numPanels;
        }
        return numPanels;
    }

    private int grovelControls(Container target, int startComponent, boolean doMove, int startVertical, int[] lineHeights) {
        int n = target.getComponentCount();
        int canvasWidth = target.getSize().width;
        int verticalPosition = startVertical;
        int horizontalPosition = 5;
        int currentLineHeight = 0;
        int lineNum = 0;
        int itemOnLine = 0;
        boolean forceNewLine = false;
        for (int i = startComponent; i < n; ++i) {
            int w;
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            int h = d.height;
            boolean wideLabel = false;
            if (wideLabel) {
                w = canvasWidth;
                if (itemOnLine != 0) {
                    forceNewLine = true;
                }
            } else {
                w = d.width;
            }
            if (forceNewLine || !wideLabel && horizontalPosition + w > canvasWidth) {
                lineHeights[lineNum++] = currentLineHeight;
                horizontalPosition = 5;
                verticalPosition += currentLineHeight + 5;
                currentLineHeight = 0;
                itemOnLine = 0;
            }
            if (doMove) {
                m.setSize(w, h);
                int x = horizontalPosition;
                int y = verticalPosition + (lineHeights[lineNum] - m.getSize().height) / 2;
                m.setLocation(x, y);
                if (this.debug) {
                    System.out.println("component " + m);
                    System.out.println("verticalPosition = " + verticalPosition + " lineHeight=" + lineHeights[lineNum] + " lineNum=" + lineNum);
                    System.out.println("setlocation " + x + " " + y + "  setsize " + w + " " + h);
                }
            }
            if (h > currentLineHeight) {
                currentLineHeight = h;
            }
            horizontalPosition += w + 5;
            forceNewLine = wideLabel;
            ++itemOnLine;
        }
        lineHeights[lineNum] = currentLineHeight;
        return verticalPosition + currentLineHeight;
    }

    public void layoutContainer(Container target) {
        int canvasWidth = target.getSize().width;
        int numPanels = this.countNumPanels(target);
        int[] lineHeights = new int[100];
        int lastY = this.grovelControls(target, numPanels, false, 0, lineHeights);
        int canvasHeight = target.getSize().height - (lastY + 5);
        Component cnvs = target.getComponent(0);
        if (numPanels == 1) {
            cnvs.setLocation(0, 0);
            cnvs.setSize(canvasWidth, canvasHeight);
        } else if (numPanels >= 2) {
            cnvs.setLocation(canvasWidth / 2, 0);
            cnvs.setSize(canvasWidth / 2, canvasHeight);
            Component graph = target.getComponent(1);
            graph.setLocation(0, 0);
            graph.setSize(canvasWidth / 2, canvasHeight);
        }
        this.grovelControls(target, numPanels, true, canvasHeight + 5, lineHeights);
    }
}

