/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DiffEq;
import com.myphysicslab.simlab.DiffEqSolver;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Graph;
import com.myphysicslab.simlab.Graphable;
import com.myphysicslab.simlab.MouseDragHandler;
import com.myphysicslab.simlab.Observer;
import com.myphysicslab.simlab.RungeKutta;
import com.myphysicslab.simlab.SimCanvas;
import com.myphysicslab.simlab.SimLayout;
import com.myphysicslab.simlab.SimLine;
import com.myphysicslab.simlab.Subject;
import com.myphysicslab.simlab.Utility;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;

public abstract class Simulation
implements Runnable,
Graphable,
MouseDragHandler,
DiffEq,
Subject {
    private double lastTime = -9999.0;
    protected boolean m_Animating = true;
    protected String[] var_names;
    protected SimCanvas cvs;
    protected Graph graph;
    private JCheckBox showGraphCheckbox;
    private JCheckBox showControlsCheckbox;
    private Listener listener = new Listener();
    protected double[] vars;
    protected boolean[] calc;
    protected DiffEqSolver odeSolver;
    protected Container container;
    private Vector controls = new Vector(10);
    private Vector observers = new Vector(10);
    private SimLine separatorLine = null;
    protected double startTime = 0.0;
    protected double simTime = 0.0;
    private boolean paintControlCludge = true;

    public Simulation(Container applet, int numVars) {
        this(applet);
        this.vars = new double[numVars];
        this.calc = new boolean[numVars];
        for (int i = 0; i < this.calc.length; ++i) {
            this.calc[i] = true;
        }
    }

    public Simulation(Container applet) {
        this.container = applet;
        this.cvs = this.makeSimCanvas();
        this.container.add((Component)this.cvs, 0);
        this.odeSolver = this.makeDiffEqSolver();
    }

    protected SimCanvas makeSimCanvas() {
        return new SimCanvas(this);
    }

    protected LayoutManager makeLayoutManager() {
        return new SimLayout();
    }

    protected DiffEqSolver makeDiffEqSolver() {
        return new RungeKutta(this);
    }

    protected Graph makeGraph() {
        return new Graph(this, this.container);
    }

    public void setupControls() {
        this.showControlsCheckbox = new JCheckBox("show controls");
        this.container.add(this.showControlsCheckbox);
        this.showControlsCheckbox.setSelected(false);
        this.showControlsCheckbox.addItemListener(this.listener);
    }

    protected int getComponentIndex(Component c) {
        Component[] cArray = this.container.getComponents();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    private boolean containerHas(Component c) {
        int n = this.container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (c != this.container.getComponent(i)) continue;
            return true;
        }
        return false;
    }

    public CoordMap getCoordMap() {
        return this.cvs.getCoordMap();
    }

    public void setCoordMap(CoordMap map) {
        this.cvs.setCoordMap(map);
    }

    public Graph getGraph() {
        return this.graph;
    }

    protected void addControl(Component c) {
        if (this.showControlsCheckbox != null && null != this.showControlsCheckbox.getSelectedObjects()) {
            this.container.add(c);
        }
        this.controls.addElement(c);
    }

    protected void removeControl(Component c) {
        this.container.remove(c);
        this.controls.removeElement(c);
    }

    protected void addObserverControl(Observer obs) {
        this.addControl((Component)((Object)obs));
        this.attach(obs);
    }

    protected void removeObserverControl(Observer obs) {
        this.removeControl((Component)((Object)obs));
        this.detach(obs);
    }

    public void attach(Observer o) {
        this.observers.addElement(o);
    }

    public void detach(Observer o) {
        this.observers.removeElement(o);
    }

    public void setParameter(String name, double value) {
        if (this.trySetParameter(name, value)) {
            Enumeration e = this.observers.elements();
            while (e.hasMoreElements()) {
                ((Observer)e.nextElement()).update(this, name, value);
            }
        } else {
            throw new IllegalArgumentException("no such parameter " + name);
        }
    }

    public double getParameter(String name) {
        throw new IllegalArgumentException("no such parameter " + name);
    }

    protected boolean trySetParameter(String name, double value) {
        return false;
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    protected void graphSetup() {
        throw new IllegalStateException("graphSetup is deprecated");
    }

    public void setupGraph() {
        this.graph = this.makeGraph();
        if (this.graph != null) {
            this.container.add((Component)this.graph, 1);
            int index = this.getComponentIndex(this.showControlsCheckbox);
            if (index < 0) {
                throw new IllegalStateException("cannot setup graph because controls not yet created");
            }
            this.showGraphCheckbox = new JCheckBox("show graph");
            this.container.add((Component)this.showGraphCheckbox, ++index);
            this.showGraphCheckbox.setSelected(true);
            this.showGraphCheckbox.addItemListener(this.listener);
            this.separatorLine = new SimLine();
            this.container.add((Component)this.separatorLine, ++index);
            this.graph.createButtons(this.container, index);
            this.graph.setVars(0, 1);
            this.container.invalidate();
        }
    }

    public void showGraph(boolean wantGraph) {
        if (!wantGraph && this.graph == null) {
            return;
        }
        if (this.graph == null || this.showGraphCheckbox == null) {
            throw new IllegalStateException("cannot show graph because graph not created");
        }
        boolean hasGraph = this.containerHas(this.graph);
        if (!hasGraph && wantGraph) {
            this.container.add((Component)this.graph, 1);
            this.graph.setVisible(true);
            this.container.invalidate();
            this.container.validate();
            this.graph.showControls(this.container, this.getComponentIndex(this.separatorLine));
            this.graph.enableControls(true);
        } else if (hasGraph && !wantGraph) {
            this.graph.hideControls(this.container);
            this.container.remove(this.graph);
            this.container.invalidate();
            this.container.validate();
            this.graph.enableControls(false);
        }
        this.showGraphCheckbox.setSelected(wantGraph);
    }

    protected void shutDown() {
        this.showControls(false);
        if (this.graph != null) {
            this.graph.hideControls(this.container);
            this.container.remove(this.graph);
            this.graph.freeOffScreen();
        }
        this.container.remove(this.cvs);
        this.cvs.freeOffscreen();
        if (this.separatorLine != null) {
            this.container.remove(this.separatorLine);
        }
        if (this.showGraphCheckbox != null) {
            this.container.remove(this.showGraphCheckbox);
        }
        if (this.showControlsCheckbox != null) {
            this.container.remove(this.showControlsCheckbox);
        }
        this.controls.removeAllElements();
        this.observers.removeAllElements();
    }

    public synchronized void showControls(boolean wantControls) {
        Enumeration e = this.controls.elements();
        while (e.hasMoreElements()) {
            if (wantControls) {
                Component m = (Component)e.nextElement();
                this.container.add(m);
                continue;
            }
            this.container.remove((Component)e.nextElement());
        }
        if (this.showControlsCheckbox != null) {
            this.showControlsCheckbox.setSelected(wantControls);
        }
    }

    public void setVariable(int i, double value) {
        if (i >= 0 && i < this.vars.length) {
            this.vars[i] = value;
            this.modifyObjects();
        }
    }

    public int numVariables() {
        return this.vars != null ? this.vars.length : 0;
    }

    public String getVariableName(int i) {
        return this.var_names != null ? this.var_names[i] : "";
    }

    public double getVariable(int i) {
        return i < this.vars.length ? this.vars[i] : 0.0;
    }

    protected void advance(double time) {
        this.odeSolver.step(time);
        this.modifyObjects();
    }

    public void run() {
        if (this.m_Animating) {
            if (this.graph != null) {
                this.graph.memorize();
                this.graph.repaint();
            }
            this.advance(this.getTimeStep());
            this.cvs.repaint();
        }
        if (this.paintControlCludge && this.getTime() > 2.0) {
            Utility.println("repaint controls cludge at time=" + this.getTime());
            this.container.repaint();
            this.paintControlCludge = false;
        }
    }

    public abstract void modifyObjects();

    public double getTime() {
        double now = (double)System.currentTimeMillis() / 1000.0;
        if (this.startTime == 0.0) {
            this.startTime = now;
        }
        return now - this.startTime;
    }

    public double getTimeStep() {
        double h;
        double now = this.getTime();
        if (this.lastTime < 0.0) {
            h = 0.05;
        } else {
            h = now - this.lastTime;
            double limit = 0.01;
            if (h > 0.1) {
                Utility.println("time step of " + h + " reduced to " + 0.01);
                h = 0.01;
            }
        }
        this.lastTime = now;
        return h;
    }

    public void constrainedSet(Dragable e, double x, double y) {
    }

    public void startDrag(Dragable e) {
    }

    public void finishDrag(Dragable e) {
        for (int i = 0; i < this.calc.length; ++i) {
            this.calc[i] = true;
        }
    }

    public double[] getVars() {
        return this.vars;
    }

    public boolean[] getCalc() {
        return this.calc;
    }

    public String toString() {
        String s = this.getClass().getName() + " with " + (this.vars != null ? this.vars.length + " variables " : "no variables");
        return s;
    }

    protected class Listener
    implements ItemListener {
        protected Listener() {
        }

        public void itemStateChanged(ItemEvent event) {
            ItemSelectable isl = event.getItemSelectable();
            if (Simulation.this.showGraphCheckbox != null && isl == Simulation.this.showGraphCheckbox) {
                Simulation.this.showGraph(null != Simulation.this.showGraphCheckbox.getSelectedObjects());
                Simulation.this.container.invalidate();
                Simulation.this.container.validate();
                Simulation.this.container.repaint();
            } else if (Simulation.this.showControlsCheckbox != null && isl == Simulation.this.showControlsCheckbox) {
                Simulation.this.showControls(null != Simulation.this.showControlsCheckbox.getSelectedObjects());
                Simulation.this.container.invalidate();
                Simulation.this.container.validate();
                Simulation.this.container.repaint();
            }
        }
    }
}

