/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.BarChart;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;

public class SpringSim1
extends Simulation {
    private CSpring spring;
    private CMass block;
    private double m_Damping = 0.1;
    private BarChart chart;
    private static final String MASS = "mass";
    private static final String DAMPING = "damping";
    private static final String LENGTH = "spring rest length";
    private static final String STIFFNESS = "spring stiffness";
    private String[] params = new String[]{"mass", "damping", "spring stiffness", "spring rest length"};

    public SpringSim1(Container container) {
        super(container, 3);
        this.setCoordMap(new CoordMap(1, -0.5, 6.0, -3.0, 3.0, 1, 0));
        double w = 0.3;
        this.block = new CMass(0.5, -w, 2.0 * w, 2.0 * w, 1);
        this.block.m_Mass = 0.5;
        this.cvs.addElement(this.block);
        this.spring = new CSpring(0.0, 0.0, 2.5, 0.5);
        this.spring.m_SpringConst = 3.0;
        this.spring.setX2(this.block.m_X1);
        this.cvs.addElement(this.spring);
        this.chart = new BarChart(this.cvs.getSimBounds());
        this.cvs.addElement(this.chart);
        this.var_names = new String[]{"position", "velocity", "work from damping", "acceleration", "kinetic energy", "spring energy", "total energy"};
        this.vars[0] = this.block.m_X1;
        this.vars[1] = 0.0;
        this.vars[2] = 0.0;
        this.initWork();
    }

    public void setupControls() {
        super.setupControls();
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS)) {
            this.block.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.m_Damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            this.spring.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            this.spring.m_RestLength = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS)) {
            return this.block.m_Mass;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.m_Damping;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.spring.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.spring.m_RestLength;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    private void initWork() {
        this.calcEnergy();
        this.chart.setWorkZero(this.chart.te + this.chart.pe);
    }

    private void calcEnergy() {
        this.chart.te = 0.5 * this.block.m_Mass * this.vars[1] * this.vars[1];
        double x1 = this.vars[0] - this.spring.m_X1 - this.spring.m_RestLength;
        this.chart.pe = 0.5 * this.spring.m_SpringConst * x1 * x1;
        this.chart.work = this.vars[2];
    }

    public void modifyObjects() {
        this.block.setX1(this.vars[0]);
        this.spring.setX2(this.block.m_X1);
        this.calcEnergy();
    }

    public int numVariables() {
        return this.var_names.length;
    }

    public double getVariable(int i) {
        if (i <= 2) {
            return this.vars[i];
        }
        if (i == 3) {
            double[] rate = new double[this.vars.length];
            this.evaluate(this.vars, rate);
            return rate[1];
        }
        double ke = 0.5 * this.block.m_Mass * this.vars[1] * this.vars[1];
        if (i == 4) {
            return ke;
        }
        double x = this.vars[0] - this.spring.m_X1 - this.spring.m_RestLength;
        double pe = 0.5 * this.spring.m_SpringConst * x * x;
        if (i == 5) {
            return pe;
        }
        if (i == 6) {
            return ke + pe;
        }
        return 0.0;
    }

    public void startDrag(Dragable e) {
        if (e == this.block) {
            this.calc[0] = false;
            this.calc[1] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.block) {
            this.vars[0] = x;
            this.vars[1] = 0.0;
            this.vars[2] = 0.0;
            this.modifyObjects();
            this.initWork();
        }
    }

    public void evaluate(double[] x, double[] change) {
        change[0] = x[1];
        double r = -this.spring.m_SpringConst * (x[0] - this.spring.m_X1 - this.spring.m_RestLength) - this.m_Damping * x[1];
        change[1] = r / this.block.m_Mass;
        change[2] = -this.m_Damping * x[1] * x[1];
    }
}

