/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CElement;
import com.myphysicslab.simlab.ConvertMap;
import java.awt.Color;
import java.awt.Graphics;

class CArc
extends CElement {
    public double m_Radius;
    public double m_Angle;
    public double m_StartAngle;
    public double m_HeadLength = 0.2;

    public CArc(double X1, double Y1, double r, double angle0, double angle) {
        super(X1, Y1, 0.0, 0.0);
        this.m_Radius = r;
        this.m_StartAngle = angle0;
        this.m_Angle = angle;
    }

    public void draw(Graphics g, ConvertMap map) {
        int x1 = map.simToScreenX(this.m_X1);
        int y1 = map.simToScreenY(this.m_Y1);
        int r = map.simToScreenScaleX(this.m_Radius);
        g.setColor(Color.black);
        int ang = (int)(this.m_Angle + 0.5);
        if (Math.abs(ang) > 1) {
            g.drawArc(x1 - r, y1 - r, 2 * r, 2 * r, (int)this.m_StartAngle, ang);
        }
        if (ang != 0 && r > 0) {
            double a0 = Math.PI * this.m_StartAngle / 180.0;
            double a1 = Math.PI * this.m_Angle / 180.0;
            double a = -(a0 + a1);
            double x = this.m_X1 + this.m_Radius * Math.cos(a);
            double y = this.m_Y1 + this.m_Radius * Math.sin(a);
            double h = Math.min(this.m_HeadLength, 0.5 * this.m_Radius);
            if (a1 > 0.0) {
                h = -h;
            }
            double xp = x + h * Math.cos(1.5707963267948966 - a - 0.5235987755982988);
            double yp = y - h * Math.sin(1.5707963267948966 - a - 0.5235987755982988);
            x1 = map.simToScreenX(x);
            y1 = map.simToScreenY(y);
            int x2 = map.simToScreenX(xp);
            int y2 = map.simToScreenY(yp);
            g.drawLine(x1, y1, x2, y2);
            xp = x + h * Math.cos(1.5707963267948966 - a + 0.5235987755982988);
            yp = y - h * Math.sin(1.5707963267948966 - a + 0.5235987755982988);
            x2 = map.simToScreenX(xp);
            y2 = map.simToScreenY(yp);
            g.drawLine(x1, y1, x2, y2);
        }
    }
}

