/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.BarChart;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CRect;
import com.myphysicslab.simlab.CText;
import com.myphysicslab.simlab.CollidingSim;
import com.myphysicslab.simlab.Collision;
import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Drawable;
import com.myphysicslab.simlab.MyCheckbox;
import com.myphysicslab.simlab.MyChoice;
import com.myphysicslab.simlab.ObjectListener;
import com.myphysicslab.simlab.SimCanvas;
import com.myphysicslab.simlab.Thruster5Object;
import com.myphysicslab.simlab.ThrusterCanvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JButton;

public class Thruster5
extends CollidingSim
implements ActionListener,
ObjectListener {
    public static final double DISTANCE_TOL = 0.01;
    public static final double VELOCITY_TOL = 0.5;
    public static final int RIGHT_WALL = -1;
    public static final int BOTTOM_WALL = -2;
    public static final int LEFT_WALL = -3;
    public static final int TOP_WALL = -4;
    protected static final int MAX_BODIES = 6;
    protected int dragObj = -1;
    protected double mouseX;
    protected double mouseY;
    protected int numBods;
    protected Thruster5Object[] bods;
    protected Vector collisionsFound = new Vector(10);
    protected NumberFormat nf = NumberFormat.getNumberInstance();
    protected double gravity = 0.0;
    protected double damping;
    protected double elasticity = 1.0;
    protected double thrust = 0.5;
    protected double m_Left;
    protected double m_Right;
    protected double m_Bottom;
    protected double m_Top;
    protected CRect m_Walls;
    protected boolean debug = false;
    protected boolean doCollisions = true;
    protected boolean showCollisionDot = false;
    protected Vector rxnForces = new Vector(20);
    protected boolean showEnergy = false;
    protected BarChart energyBar;
    protected double zeroEnergyLevel = 0.0;
    private CText preText;
    private CText postText;
    protected int stuckCounter = 0;
    private CText message = null;
    protected boolean gameMode = false;
    private int winningHits = 10;
    private int greenHits = 0;
    private int blueHits = 0;
    private CText greenLabel;
    private CText blueLabel;
    private CText message2 = null;
    protected JButton buttonReset;
    protected static final String NUM_BODIES = "number bodies";
    protected static final String DAMPING = "damping";
    protected static final String GRAVITY = "gravity";
    protected static final String ELASTICITY = "elasticity";
    protected static final String THRUST = "thrust";
    protected static final String SHOW_ENERGY = "show energy";
    protected String[] params = new String[]{"number bodies", "damping", "gravity", "elasticity", "thrust", "show energy"};

    public Thruster5(Container container, boolean gameMode) {
        super(container);
        this.gameMode = gameMode;
        double w = 5.0;
        this.setCoordMap(new CoordMap(-1, -w, w, -w, w, 0, 0));
        DoubleRect box = this.cvs.getSimBounds();
        this.m_Left = box.getXMin();
        this.m_Right = box.getXMax();
        this.zeroEnergyLevel = this.m_Bottom = box.getYMin();
        this.m_Top = box.getYMax();
        this.cvs.setObjectListener(this);
        this.damping = gameMode ? 0.2 : 0.0;
        this.numBods = gameMode ? 2 : 3;
        this.reset();
        Collision c = new Collision();
        if (gameMode) {
            this.cvs.requestFocus();
        }
    }

    public void setupControls() {
        super.setupControls();
        this.buttonReset = new JButton("reset");
        this.addControl(this.buttonReset);
        this.buttonReset.addActionListener(this);
        if (!this.gameMode) {
            this.nf.setMinimumFractionDigits(0);
            Object[] choices = new String[6];
            for (int i = 0; i < 6; ++i) {
                choices[i] = this.nf.format(i + 1) + " object" + (i > 0 ? "s" : "");
            }
            this.addObserverControl(new MyChoice(this, NUM_BODIES, this.numBods, 1.0, choices));
        }
        this.addObserverControl(new DoubleField(this, ELASTICITY, 2));
        this.addObserverControl(new DoubleField(this, GRAVITY, 2));
        this.addObserverControl(new DoubleField(this, DAMPING, 2));
        this.addObserverControl(new DoubleField(this, THRUST, 2));
        if (!this.gameMode) {
            this.addObserverControl(new MyCheckbox(this, SHOW_ENERGY));
        }
        this.showControls(true);
    }

    public void setupGraph() {
    }

    public String getVariableName(int i) {
        int j = i % 6;
        int obj = i / 6;
        switch (j) {
            case 0: {
                return "x position " + obj;
            }
            case 1: {
                return "x velocity " + obj;
            }
            case 2: {
                return "y position " + obj;
            }
            case 3: {
                return "y velocity " + obj;
            }
            case 4: {
                return "angle " + obj;
            }
            case 5: {
                return "angular velocity " + obj;
            }
        }
        return "";
    }

    public void objectChanged(Object o) {
        if (o == this.cvs) {
            DoubleRect box = this.cvs.getSimBounds();
            this.m_Left = box.getXMin();
            this.m_Right = box.getXMax();
            this.zeroEnergyLevel = this.m_Bottom = box.getYMin();
            this.m_Top = box.getYMax();
            this.m_Walls.setBounds(new DoubleRect(this.m_Left, this.m_Bottom, this.m_Right, this.m_Top));
        }
    }

    public void startDrag(Dragable e) {
        this.dragObj = -1;
        for (int i = 0; i < this.bods.length; ++i) {
            if (e != this.bods[i]) continue;
            this.dragObj = i;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        this.mouseX = x;
        this.mouseY = y;
    }

    public void finishDrag(Dragable e) {
        super.finishDrag(e);
        this.dragObj = -1;
    }

    public void drawRubberBand(Graphics g, ConvertMap map) {
        if (this.dragObj >= 0) {
            g.setColor(Color.black);
            g.drawLine(map.simToScreenX(this.mouseX), map.simToScreenY(this.mouseY), map.simToScreenX(this.bods[this.dragObj].tx), map.simToScreenY(this.bods[this.dragObj].ty));
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(ELASTICITY)) {
            this.elasticity = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(THRUST)) {
            this.thrust = value;
            for (int i = 0; i < this.numBods; ++i) {
                this.bods[i].tMagnitude = this.thrust;
            }
            return true;
        }
        if (name.equalsIgnoreCase(NUM_BODIES)) {
            this.numBods = (int)value;
            this.m_Animating = false;
            this.reset();
            this.m_Animating = true;
            return true;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            this.showEnergy = value != 0.0;
            boolean chartVisible = this.cvs.containsElement(this.energyBar);
            if (this.showEnergy && !chartVisible) {
                this.cvs.prependElement(this.energyBar);
                if (this.showMomentum()) {
                    this.cvs.prependElement(this.preText);
                    this.cvs.prependElement(this.postText);
                }
            } else if (!this.showEnergy && chartVisible) {
                this.cvs.removeElement(this.energyBar);
                if (this.showMomentum()) {
                    this.cvs.removeElement(this.preText);
                    this.cvs.removeElement(this.postText);
                }
            }
            this.container.invalidate();
            this.container.validate();
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(ELASTICITY)) {
            return this.elasticity;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.damping;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        if (name.equalsIgnoreCase(THRUST)) {
            return this.thrust;
        }
        if (name.equalsIgnoreCase(NUM_BODIES)) {
            return this.numBods;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            return this.showEnergy ? 1.0 : 0.0;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonReset) {
            this.reset();
        }
    }

    protected SimCanvas makeSimCanvas() {
        return new ThrusterCanvas(this);
    }

    protected Thruster5Object createBlock(double width, double height) {
        return new Thruster5Object(width, height);
    }

    protected synchronized void reset() {
        int i;
        DoubleRect r;
        this.cvs.removeAllElements();
        this.message2 = null;
        this.m_Walls = new CRect(new DoubleRect(this.m_Left, this.m_Bottom, this.m_Right, this.m_Top));
        this.cvs.addElement(this.m_Walls);
        if (!this.gameMode) {
            r = this.cvs.getSimBounds();
            this.energyBar = new BarChart(r);
            this.preText = new CText(r.getXMin() + 0.05 * r.getWidth(), r.getYMin() + 0.75 * r.getHeight(), "");
            this.preText.setFontSize(12);
            this.postText = new CText(r.getXMin() + 0.05 * r.getWidth(), r.getYMin() + 0.7 * r.getHeight(), "");
            this.postText.setFontSize(12);
            if (this.showEnergy) {
                this.cvs.addElement(this.energyBar);
                if (this.showMomentum()) {
                    this.cvs.addElement(this.preText);
                    this.cvs.addElement(this.postText);
                }
            }
        } else {
            r = this.cvs.getSimBounds();
            this.greenLabel = new CText(r.getXMin() + 0.05 * r.getWidth(), r.getYMin() + 0.75 * r.getHeight(), "");
            this.greenLabel.setFontSize(16);
            this.greenLabel.m_Color = Color.green;
            this.blueLabel = new CText(r.getXMin() + 0.05 * r.getWidth(), r.getYMin() + 0.6 * r.getHeight(), "");
            this.blueLabel.setFontSize(16);
            this.blueLabel.m_Color = Color.blue;
            this.cvs.addElement(this.greenLabel);
            this.cvs.addElement(this.blueLabel);
        }
        this.bods = new Thruster5Object[this.numBods];
        for (i = 0; i < this.numBods; ++i) {
            this.bods[i] = this.createBlock(0.5, 3.0);
            this.bods[i].tMagnitude = this.thrust;
            this.cvs.addElement(this.bods[i]);
        }
        if (this.numBods > 0) {
            if (this.gameMode) {
                this.bods[0].moveTo(2.0, 0.0, 0.7853981633974483);
            } else {
                this.bods[0].moveTo(-2.0, 0.0, 1.5707963267948966);
            }
            this.bods[0].color = Color.green;
        }
        if (this.numBods > 1) {
            if (this.gameMode) {
                this.bods[1].moveTo(-2.0, 0.0, -0.7853981633974483);
            } else {
                this.bods[1].moveTo(2.0, 1.0, 0.0);
            }
            this.bods[1].color = Color.blue;
        }
        if (this.numBods > 2) {
            this.bods[2].moveTo(1.0, 0.0, 0.1);
            this.bods[2].color = Color.red;
        }
        if (this.numBods > 3) {
            this.bods[3].moveTo(-2.2, 1.0, 1.7707963267948965);
            this.bods[3].color = Color.cyan;
        }
        if (this.numBods > 4) {
            this.bods[4].moveTo(-2.4, -1.0, 1.3707963267948966);
            this.bods[4].color = Color.magenta;
        }
        if (this.numBods > 5) {
            this.bods[5].moveTo(-1.8, 2.0, 1.8707963267948966);
            this.bods[5].color = Color.orange;
        }
        this.vars = new double[6 * this.numBods];
        this.calc = new boolean[this.vars.length];
        for (i = 0; i < this.calc.length; ++i) {
            this.calc[i] = true;
        }
        for (i = 0; i < this.numBods; ++i) {
            this.vars[6 * i] = this.bods[i].x;
            this.vars[6 * i + 2] = this.bods[i].y;
            this.vars[6 * i + 4] = this.bods[i].angle;
        }
        this.message = null;
        this.message2 = null;
        if (this.gameMode) {
            this.nf.setMinimumFractionDigits(0);
            this.greenHits = 0;
            this.greenLabel.setText("green " + this.nf.format(0));
            this.blueHits = 0;
            this.blueLabel.setText("blue " + this.nf.format(0));
        }
    }

    public void handleKeyEvent(int keyCode, boolean pressed) {
        switch (keyCode) {
            case 37: 
            case 74: {
                this.bods[0].active[1] = pressed;
                break;
            }
            case 39: 
            case 76: {
                this.bods[0].active[0] = pressed;
                break;
            }
            case 38: 
            case 73: {
                this.bods[0].active[3] = pressed;
                break;
            }
            case 40: 
            case 75: {
                this.bods[0].active[2] = pressed;
                break;
            }
            case 83: {
                this.bods[1].active[1] = pressed;
                break;
            }
            case 70: {
                this.bods[1].active[0] = pressed;
                break;
            }
            case 69: {
                this.bods[1].active[3] = pressed;
                break;
            }
            case 67: 
            case 68: {
                this.bods[1].active[2] = pressed;
                break;
            }
        }
    }

    public void modifyObjects() {
        this.modifyObjects(this.vars);
    }

    public void modifyObjects(double[] x) {
        int i;
        for (i = 0; i < this.numBods; ++i) {
            this.bods[i].moveTo(x[6 * i + 0], x[6 * i + 2], x[6 * i + 4]);
        }
        if (this.energyBar != null) {
            this.energyBar.te = 0.0;
            this.energyBar.re = 0.0;
            this.energyBar.pe = 0.0;
            for (i = 0; i < this.numBods; ++i) {
                if (this.bods[i].mass == Double.POSITIVE_INFINITY) continue;
                this.energyBar.pe += (x[2 + 6 * i] - this.zeroEnergyLevel - this.bods[i].getMinHeight()) * this.bods[i].mass * this.gravity;
                this.energyBar.re += this.bods[i].rotationalEnergy(x[5 + 6 * i]);
                this.energyBar.te += this.bods[i].translationalEnergy(x[1 + 6 * i], x[3 + 6 * i]);
            }
        }
    }

    protected double getEnergy() {
        double e = 0.0;
        for (int i = 0; i < this.numBods; ++i) {
            if (this.bods[i].mass == Double.POSITIVE_INFINITY) continue;
            e += (this.vars[2 + 6 * i] - this.zeroEnergyLevel - this.bods[i].getMinHeight()) * this.bods[i].mass * this.gravity;
            e += this.bods[i].rotationalEnergy(this.vars[5 + 6 * i]);
            e += this.bods[i].translationalEnergy(this.vars[1 + 6 * i], this.vars[3 + 6 * i]);
        }
        return e;
    }

    protected boolean showMomentum() {
        return true;
    }

    public void printEnergy(int n, String s) {
        if (!this.showEnergy || !this.showMomentum()) {
            return;
        }
        double ke = 0.0;
        double pe = 0.0;
        double[] m0 = new double[]{0.0, 0.0, 0.0};
        double[] m1 = new double[3];
        for (int i = 0; i < this.numBods; ++i) {
            if (this.bods[i].mass == Double.POSITIVE_INFINITY) continue;
            pe += (this.vars[2 + 6 * i] - this.zeroEnergyLevel - this.bods[i].getMinHeight()) * this.bods[i].mass * this.gravity;
            ke += this.bods[i].kineticEnergy(this.vars[1 + 6 * i], this.vars[3 + 6 * i], this.vars[5 + 6 * i]);
            m1 = this.bods[i].momentum(this.vars[1 + 6 * i], this.vars[3 + 6 * i], this.vars[5 + 6 * i]);
            for (int j = 0; j < 3; ++j) {
                int n2 = j;
                m0[n2] = m0[n2] + m1[j];
            }
        }
        if (this.showMomentum()) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
            CText label = n == 0 ? this.preText : this.postText;
            label.m_text = s + " momentum x: " + this.nf.format(m0[0]) + "   y: " + this.nf.format(m0[1]) + "   angular: " + this.nf.format(m0[2]);
        }
    }

    protected void checkCollision(int obj, int corner) {
        double d;
        double d2;
        double d3;
        double d4;
        double cornerY;
        double cornerX;
        Collision result = null;
        switch (corner) {
            case 1: {
                cornerX = this.bods[obj].ax;
                cornerY = this.bods[obj].ay;
                break;
            }
            case 2: {
                cornerX = this.bods[obj].bx;
                cornerY = this.bods[obj].by;
                break;
            }
            case 3: {
                cornerX = this.bods[obj].cx;
                cornerY = this.bods[obj].cy;
                break;
            }
            case 4: {
                cornerX = this.bods[obj].dx;
                cornerY = this.bods[obj].dy;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad corner " + corner);
            }
        }
        double d5 = cornerX - this.m_Right;
        if (d4 > 0.0) {
            result = new Collision();
            result.depth = d5;
            result.normalX = -1.0;
            result.normalY = 0.0;
            result.normalObj = -1;
        }
        d5 = this.m_Left - cornerX;
        if (d3 > 0.0 && (result == null || d5 > result.depth)) {
            result = new Collision();
            result.depth = d5;
            result.normalX = 1.0;
            result.normalY = 0.0;
            result.normalObj = -3;
        }
        d5 = cornerY - this.m_Top;
        if (d2 > 0.0 && (result == null || d5 > result.depth)) {
            result = new Collision();
            result.depth = d5;
            result.normalX = 0.0;
            result.normalY = -1.0;
            result.normalObj = -4;
        }
        d5 = this.m_Bottom - cornerY;
        if (d > 0.0 && (result == null || d5 > result.depth)) {
            result = new Collision();
            result.depth = d5;
            result.normalX = 0.0;
            result.normalY = 1.0;
            result.normalObj = -2;
        }
        for (int i = 0; i < this.numBods; ++i) {
            Collision c;
            if (i == obj || (c = this.bods[i].testCollision(cornerX, cornerY, obj, i)) == null || result != null && !(c.depth > result.depth)) continue;
            result = c;
        }
        if (result != null) {
            result.colliding = true;
            result.impactX = cornerX;
            result.impactY = cornerY;
            result.object = obj;
            result.corner = corner;
            result.depth = -result.depth;
            Collision.addCollision(this.collisionsFound, result);
        }
    }

    public Vector findAllCollisions() {
        this.collisionsFound.removeAllElements();
        if (this.doCollisions) {
            int i;
            for (i = 0; i < this.numBods; ++i) {
                for (int j = 1; j <= 4; ++j) {
                    this.checkCollision(i, j);
                }
            }
            if (this.debug && this.collisionsFound.size() > 0) {
                System.out.println("--------------------------------");
                if (this.collisionsFound.size() > 1) {
                    System.out.println(this.collisionsFound.size() + " collisions detected time= " + this.simTime);
                }
                if (this.collisionsFound.size() > 0) {
                    for (i = 0; i < this.collisionsFound.size(); ++i) {
                        DecimalFormat df = new DecimalFormat("0.0###");
                        Collision c = (Collision)this.collisionsFound.elementAt(i);
                        System.out.println("collision obj=" + df.format(c.object) + " normalObj=" + df.format(c.normalObj) + " impact x=" + df.format(c.impactX) + " y=" + df.format(c.impactY));
                        System.out.println("normal x=" + df.format(c.normalX) + " y=" + df.format(c.normalY) + " depth= " + c.depth);
                    }
                }
            }
        }
        return this.collisionsFound.size() > 0 ? this.collisionsFound : null;
    }

    protected void findNormal(Collision c1, Collision c2) {
        if (c1.impactX == c2.impactX) {
            c1.normalY = 0.0;
            c1.normalX = this.vars[0 + 6 * c1.object] < c1.impactX ? -1.0 : 1.0;
        } else {
            double slope = (c2.impactY - c1.impactY) / (c2.impactX - c1.impactX);
            double b = c1.impactY - slope * c1.impactX;
            int obj = 6 * c1.object;
            double nx = -slope;
            double ny = 1.0;
            if (this.vars[2 + obj] - slope * this.vars[0 + obj] - b < 0.0) {
                nx = -nx;
                ny = -ny;
            }
            double magnitude = Math.sqrt(nx * nx + ny * ny);
            c1.normalX = nx / magnitude;
            c1.normalY = ny / magnitude;
        }
        if (this.debug) {
            System.out.println("findNormal " + c1.normalX + " " + c1.normalY);
        }
    }

    protected void gameScore(Collision c) {
        if (this.gameMode && c.normalObj < 0) {
            this.nf.setMinimumFractionDigits(0);
            if (c.object == 0) {
                this.greenLabel.setText("green " + this.nf.format(++this.greenHits));
                if (this.greenHits >= this.winningHits && this.message2 == null) {
                    this.message2 = new CText("Green hit wall " + this.winningHits + " times -- Blue wins!");
                    this.cvs.addElement(this.message2);
                }
            } else {
                this.blueLabel.setText("blue " + this.nf.format(++this.blueHits));
                if (this.blueHits >= this.winningHits && this.message2 == null) {
                    this.message2 = new CText("Blue hit wall " + this.winningHits + " times -- Green wins!");
                    this.cvs.addElement(this.message2);
                }
            }
        }
    }

    protected void addImpact(Collision cd, double[] velo) {
        this.gameScore(cd);
        double nx = cd.normalX;
        double ny = cd.normalY;
        if (cd.normalObj < 0) {
            int objB = cd.object;
            int offsetB = 6 * objB;
            double rbx = cd.impactX - this.bods[objB].x;
            double rby = cd.impactY - this.bods[objB].y;
            double Ib = this.bods[objB].momentAboutCM();
            double mb = this.bods[objB].mass;
            double vbx = this.vars[1 + offsetB];
            double vby = this.vars[3 + offsetB];
            double wb = this.vars[5 + offsetB];
            double e = this.elasticity;
            double j = rbx * ny - rby * nx;
            j = j * j / Ib + 1.0 / mb;
            double normalVelocity = (vbx - rby * wb) * nx + (vby + rbx * wb) * ny;
            if (normalVelocity >= 0.0) {
                if (this.debug) {
                    System.out.println("add Impact: positive relative velocity " + normalVelocity);
                }
                return;
            }
            j = -(1.0 + e) * normalVelocity / j;
            int n = 1 + offsetB;
            velo[n] = velo[n] + nx * j / mb;
            int n2 = 3 + offsetB;
            velo[n2] = velo[n2] + ny * j / mb;
            int n3 = 5 + offsetB;
            velo[n3] = velo[n3] + j * (rbx * ny - rby * nx) / Ib;
            this.addCollisionDot(cd.impactX, cd.impactY, j, Color.blue);
        } else {
            int objA = cd.object;
            int objB = cd.normalObj;
            int offsetA = 6 * objA;
            int offsetB = 6 * objB;
            double rax = cd.impactX - this.bods[objA].x;
            double ray = cd.impactY - this.bods[objA].y;
            double rbx = cd.impactX - this.bods[objB].x;
            double rby = cd.impactY - this.bods[objB].y;
            double invIa = this.bods[objA].invMomentAboutCM();
            double invIb = this.bods[objB].invMomentAboutCM();
            double invma = this.bods[objA].invMass();
            double invmb = this.bods[objB].invMass();
            nx = -nx;
            ny = -ny;
            double vax = this.vars[1 + offsetA];
            double vay = this.vars[3 + offsetA];
            double wa = this.vars[5 + offsetA];
            double vbx = this.vars[1 + offsetB];
            double vby = this.vars[3 + offsetB];
            double wb = this.vars[5 + offsetB];
            double d = rax * ny - ray * nx;
            double j = d * d * invIa;
            d = -rby * nx + rbx * ny;
            j += d * d * invIb + invma + invmb;
            double dx = vax + wa * -ray - vbx - wb * -rby;
            double dy = vay + wa * rax - vby - wb * rbx;
            j = -(1.0 + this.elasticity) * (dx * nx + dy * ny) / j;
            int n = 1 + offsetA;
            velo[n] = velo[n] + j * nx * invma;
            int n4 = 3 + offsetA;
            velo[n4] = velo[n4] + j * ny * invma;
            int n5 = 1 + offsetB;
            velo[n5] = velo[n5] + -j * nx * invmb;
            int n6 = 3 + offsetB;
            velo[n6] = velo[n6] + -j * ny * invmb;
            int n7 = 5 + offsetA;
            velo[n7] = velo[n7] + j * (-ray * nx + rax * ny) * invIa;
            int n8 = 5 + offsetB;
            velo[n8] = velo[n8] + -j * (-rby * nx + rbx * ny) * invIb;
            if (this.debug) {
                System.out.println("addImpact j= " + j + " normal= " + nx + " " + ny);
            }
            this.addCollisionDot(cd.impactX, cd.impactY, j, Color.blue);
        }
    }

    protected Collision[] findMatch(Vector collisions) {
        int n = collisions.size();
        for (int i = 0; i < n; ++i) {
            Collision c1 = (Collision)collisions.elementAt(i);
            if (c1.handled) continue;
            for (int j = i + 1; j < n; ++j) {
                Collision c2 = (Collision)collisions.elementAt(j);
                if (c2.handled || (c1.object != c2.object || c1.normalObj != c2.normalObj) && (c1.object != c2.normalObj || c1.normalObj != c2.object)) continue;
                Collision[] result = new Collision[]{c1, c2};
                return result;
            }
        }
        return null;
    }

    protected void specialImpact(Vector collisions, double[] velo) {
        Collision[] match;
        while ((match = this.findMatch(collisions)) != null) {
            Collision c1 = match[0];
            Collision c2 = match[1];
            this.findNormal(c1, c2);
            c1.impactX = (c1.impactX + c2.impactX) / 2.0;
            c1.impactY = (c1.impactY + c2.impactY) / 2.0;
            this.addImpact(c1, velo);
            System.out.println("special impact " + c1.object + " " + c1.normalObj);
            c1.handled = true;
            c2.handled = true;
        }
    }

    public void handleCollisions(Vector collisions) {
        int i;
        this.printEnergy(0, "pre-collision ");
        double[] velo = new double[this.vars.length];
        for (i = 0; i < this.vars.length; ++i) {
            velo[i] = 0.0;
        }
        if (this.debug) {
            System.out.println("handleCollisions " + collisions.size() + " collisions time=" + this.simTime);
        }
        this.specialImpact(collisions, velo);
        if (this.debug) {
            System.out.println("handleCollisions " + collisions.size() + " collisions after specialImpact");
        }
        for (i = 0; i < collisions.size(); ++i) {
            Collision c = (Collision)collisions.elementAt(i);
            if (c.handled) continue;
            this.addImpact((Collision)collisions.elementAt(i), velo);
            c.handled = true;
        }
        for (i = 0; i < this.vars.length; ++i) {
            if (this.debug && velo[i] != 0.0) {
                System.out.println("var " + i + " modified by " + velo[i]);
            }
            int n = i;
            this.vars[n] = this.vars[n] + velo[i];
        }
        this.printEnergy(1, "post-collision");
    }

    public void evaluate(double[] x, double[] change) {
        while (!this.rxnForces.isEmpty()) {
            Drawable d = (Drawable)this.rxnForces.lastElement();
            this.cvs.removeElement(d);
            this.rxnForces.removeElement(d);
        }
        block9: for (int i = 0; i < this.vars.length; ++i) {
            int j = i % 6;
            int obj = i / 6;
            int offset = 6 * obj;
            double result = 0.0;
            double invMass = this.bods[obj].invMass();
            double invMoment = this.bods[obj].invMomentAboutCM();
            double springConst = 1.0;
            switch (j) {
                case 0: {
                    change[i] = x[1 + offset];
                    continue block9;
                }
                case 1: {
                    double Fx;
                    double[] v;
                    int k;
                    result = -this.damping * x[1 + offset] * invMass;
                    for (k = 0; k < 4; ++k) {
                        if (!this.bods[obj].active[k]) continue;
                        v = this.bods[obj].calcVectors(x[0 + offset], x[2 + offset], x[4 + offset], k);
                        result += v[4] * invMass;
                    }
                    if (obj == this.dragObj) {
                        v = this.bods[obj].calcVectors(x[0 + offset], x[2 + offset], x[4 + offset], 0);
                        Fx = 1.0 * (this.mouseX - (x[0 + offset] + v[0]));
                        result += Fx * invMass;
                    }
                    change[i] = result;
                    continue block9;
                }
                case 2: {
                    change[i] = x[3 + offset];
                    continue block9;
                }
                case 3: {
                    double[] v;
                    int k;
                    result = -this.damping * x[3 + offset] / this.bods[obj].mass;
                    if (invMass != 0.0) {
                        result -= this.gravity;
                    }
                    for (k = 0; k < 4; ++k) {
                        if (!this.bods[obj].active[k]) continue;
                        v = this.bods[obj].calcVectors(x[0 + offset], x[2 + offset], x[4 + offset], k);
                        result += v[5] * invMass;
                    }
                    if (obj == this.dragObj) {
                        v = this.bods[obj].calcVectors(x[0 + offset], x[2 + offset], x[4 + offset], 0);
                        double Fy = 1.0 * (this.mouseY - (x[2 + offset] + v[1]));
                        result += Fy * invMass;
                    }
                    change[i] = result;
                    continue block9;
                }
                case 4: {
                    change[i] = x[5 + offset];
                    continue block9;
                }
                case 5: {
                    double Fx;
                    double[] v;
                    int k;
                    result = -this.damping * x[5 + offset];
                    for (k = 0; k < 4; ++k) {
                        if (!this.bods[obj].active[k]) continue;
                        v = this.bods[obj].calcVectors(x[0 + offset], x[2 + offset], x[4 + offset], k);
                        result += (v[0] * v[5] - v[1] * v[4]) * invMoment;
                    }
                    if (obj == this.dragObj) {
                        v = this.bods[obj].calcVectors(x[0 + offset], x[2 + offset], x[4 + offset], 0);
                        Fx = 1.0 * (this.mouseX - (x[0 + offset] + v[0]));
                        double Fy = 1.0 * (this.mouseY - (x[2 + offset] + v[1]));
                        result += (v[0] * Fy - v[1] * Fx) * invMoment;
                    }
                    change[i] = result;
                }
            }
        }
    }

    public void advance(double timeStep) {
        super.advance(timeStep);
        if (this.lastTimeStep == 0.0) {
            ++this.stuckCounter;
        }
        if (this.lastTimeStep > 0.0) {
            this.stuckCounter = 0;
            if (this.message != null) {
                this.cvs.removeElement(this.message);
                this.message = null;
            }
        } else if (this.stuckCounter >= 4) {
            System.out.println("we are stuck at time " + this.simTime);
            if (this.message == null) {
                this.message = new CText("Simulation is stuck!  Click reset to continue.");
                this.cvs.addElement(this.message);
            }
        }
    }

    protected void addCollisionDot(double x, double y, double magnitude, Color c) {
        if (this.showCollisionDot) {
            double w = Math.max(0.02, Math.abs(magnitude));
            CMass m = new CMass(x - w / 2.0, y - w / 2.0, w, w, 5);
            m.m_Color = c;
            this.cvs.addElement(m);
            this.rxnForces.addElement(m);
        }
    }
}

