/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CWall;
import com.myphysicslab.simlab.CollidingSim;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;

public class CollideSpring
extends CollidingSim
implements ActionListener {
    private double damping = 0.0;
    private CSpring m_Spring;
    private CMass m_Mass1;
    private CMass m_Mass2;
    private CWall m_Wall;
    private CWall m_Wall2;
    private static final int ID_MASS1 = 1;
    private static final int ID_MASS2 = 2;
    private static final int ID_LEFT_WALL = 3;
    private static final int ID_RIGHT_WALL = 4;
    private JButton button_stop;
    private Vector collisions = new Vector(10);
    private static final String MASS1 = "mass1";
    private static final String DAMPING = "damping";
    private static final String LENGTH = "spring rest length";
    private static final String STIFFNESS = "spring stiffness";
    private static final String MASS2 = "mass2";
    private String[] params = new String[]{"mass1", "damping", "spring stiffness", "spring rest length", "mass2"};

    public CollideSpring(Container container) {
        super(container, 4);
        this.var_names = new String[]{"position 1", "velocity 1", "position 2", "velocity 2"};
        this.setCoordMap(new CoordMap(1, -0.5, 7.5, -2.0, 2.0, 1, 0));
        double xx = 0.0;
        double yy = 0.0;
        this.m_Wall = new CWall(xx - 0.3, yy - 2.0, xx, yy + 2.0, 0.0);
        this.cvs.addElement(this.m_Wall);
        this.m_Spring = new CSpring(xx, yy, 2.5, 0.4);
        this.m_Spring.m_SpringConst = 6.0;
        this.cvs.addElement(this.m_Spring);
        double w = 0.3;
        this.m_Mass1 = new CMass(xx + this.m_Spring.m_RestLength - 2.0, yy - w, 2.0 * w, 2.0 * w, 1);
        this.m_Spring.setX2(this.m_Mass1.m_X1);
        this.m_Mass1.m_Mass = 0.5;
        this.damping = 0.0;
        this.cvs.addElement(this.m_Mass1);
        this.m_Mass2 = new CMass(this.m_Mass1.m_X2 + 1.0, yy - w, 2.0 * w, 2.0 * w, 1);
        this.m_Mass2.m_Mass = 1.5;
        this.cvs.addElement(this.m_Mass2);
        this.m_Wall2 = new CWall(7.0, yy - 2.0, 7.4, yy + 2.0, -90.0);
        this.cvs.addElement(this.m_Wall2);
        this.vars[0] = this.m_Mass1.m_X1;
        this.vars[1] = 0.0;
        this.vars[2] = this.m_Mass2.m_X1;
        this.vars[3] = 0.0;
        this.modifyObjects();
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 2);
        }
        this.showGraph(false);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS1)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            this.m_Mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            this.m_Spring.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            this.m_Spring.m_RestLength = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS1)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            return this.m_Mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.damping;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.m_Spring.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.m_Spring.m_RestLength;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.vars[0] = 1.0;
            this.vars[1] = 0.0;
            this.vars[2] = 3.0;
            this.vars[3] = 0.0;
        }
    }

    public void modifyObjects() {
        this.m_Mass1.setX1(this.vars[0]);
        this.m_Spring.setX2(this.m_Mass1.m_X1);
        this.m_Mass2.setX1(this.vars[2]);
    }

    public void startDrag(Dragable e) {
        this.calc[3] = false;
        this.calc[2] = false;
        this.calc[1] = false;
        this.calc[0] = false;
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.m_Mass1) {
            if (x < this.m_Wall.m_X2) {
                x = this.m_Wall.m_X2;
            }
            if (x + this.m_Mass1.m_Width + this.m_Mass2.m_Width > this.m_Wall2.m_X1) {
                x = this.m_Wall2.m_X1 - this.m_Mass2.m_Width - this.m_Mass1.m_Width;
            }
            if (x + this.m_Mass1.m_Width > this.m_Mass2.m_X1) {
                this.m_Mass2.setX1(x + this.m_Mass1.m_Width);
            }
            this.m_Mass1.setX1(x);
            this.m_Spring.setX2(x);
            this.vars[0] = this.m_Mass1.m_X1;
            this.vars[1] = 0.0;
            this.vars[2] = this.m_Mass2.m_X1;
            this.vars[3] = 0.0;
        } else if (e == this.m_Mass2) {
            if (x + this.m_Mass2.m_Width > this.m_Wall2.m_X1) {
                x = this.m_Wall2.m_X1 - this.m_Mass2.m_Width;
            }
            if (x - this.m_Mass1.m_Width < this.m_Wall.m_X2) {
                x = this.m_Wall.m_X2 + this.m_Mass1.m_Width;
            }
            if (x < this.m_Mass1.m_X2) {
                this.m_Mass1.setX1(x - this.m_Mass1.m_Width - 0.001);
                this.m_Spring.setX2(this.m_Mass1.m_X1);
            }
            this.m_Mass2.setX1(x);
            this.vars[0] = this.m_Mass1.m_X1;
            this.vars[1] = 0.0;
            this.vars[2] = this.m_Mass2.m_X1;
            this.vars[3] = 0.0;
        }
    }

    private void addCollision(int obj1, int obj2) {
        this.collisions.addElement(new int[]{obj1, obj2});
    }

    public Vector findAllCollisions() {
        this.collisions.removeAllElements();
        if (this.m_Mass1.m_X1 < this.m_Wall.m_X2) {
            this.addCollision(3, 1);
        }
        if (this.m_Mass1.m_X2 > this.m_Mass2.m_X1) {
            this.addCollision(1, 2);
        }
        if (this.m_Mass2.m_X2 > this.m_Wall2.m_X1) {
            this.addCollision(4, 2);
        }
        return this.collisions.size() > 0 ? this.collisions : null;
    }

    public void handleCollisions(Vector collisions) {
        Enumeration e = collisions.elements();
        while (e.hasMoreElements()) {
            int[] objs = (int[])e.nextElement();
            if (objs[0] == 3) {
                this.vars[1] = -this.vars[1];
                continue;
            }
            if (objs[0] == 4) {
                this.vars[3] = -this.vars[3];
                continue;
            }
            if (objs[0] != 1 || objs[1] != 2) continue;
            double vcm = (this.m_Mass1.m_Mass * this.vars[1] + this.m_Mass2.m_Mass * this.vars[3]) / (this.m_Mass1.m_Mass + this.m_Mass2.m_Mass);
            this.vars[1] = -this.vars[1] + 2.0 * vcm;
            this.vars[3] = -this.vars[3] + 2.0 * vcm;
        }
    }

    public void evaluate(double[] x, double[] change) {
        change[0] = x[1];
        double r = -this.m_Spring.m_SpringConst * (x[0] - this.m_Spring.m_X1 - this.m_Spring.m_RestLength) - this.damping * x[1];
        change[1] = r / this.m_Mass1.m_Mass;
        change[2] = x[3];
        change[3] = 0.0;
    }
}

