/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.Collision;
import com.myphysicslab.simlab.Thruster5Object;
import java.util.Vector;

class ContactObject
extends Thruster5Object {
    public ContactObject(double width, double height) {
        super(width, height);
    }

    private boolean testVelocity(Vector contacts, Collision c, int edge, double[] x) {
        this.getNormalForEdge(c, edge);
        int obj = 6 * c.object;
        int nobj = 6 * c.normalObj;
        boolean debugthis = false;
        double nrv = c.normalX * (x[1 + obj] + x[5 + obj] * -c.Ry - x[1 + nobj] - x[5 + nobj] * -c.R2y);
        nrv += c.normalY * (x[3 + obj] + x[5 + obj] * c.Rx - x[3 + nobj] - x[5 + nobj] * c.R2x);
        if (Math.abs(nrv) < 0.5) {
            Collision.addCollision(contacts, c);
            if (debugthis) {
                System.out.println("found contact on edge " + edge + " nrv=" + nrv);
                System.out.println("  contact info: " + c);
            }
            return true;
        }
        if (debugthis) {
            System.out.println("velocity too big, nrv=" + nrv);
        }
        return false;
    }

    public void testContacts(Vector contacts, double cornerX, double cornerY, int corner, int objIndex, int selfIndex, double[] x) {
        double dx = cornerX - this.x;
        double dy = cornerY - this.y;
        double d = dx * dx + dy * dy;
        if (d > (dx = this.width / 2.0 + 0.01) * dx + (dy = this.height / 2.0 + 0.01) * dy) {
            return;
        }
        double gx = cornerX;
        double gy = cornerY;
        double px = (gx -= this.x) * Math.cos(-this.angle) - (gy -= this.y) * Math.sin(-this.angle);
        double py = gx * Math.sin(-this.angle) + gy * Math.cos(-this.angle);
        px += this.cmx;
        py += this.cmy;
        int obj = 6 * objIndex;
        int nobj = 6 * selfIndex;
        Collision c = new Collision();
        c.colliding = false;
        c.Rx = cornerX - x[0 + obj];
        c.Ry = cornerY - x[2 + obj];
        c.R2x = cornerX - x[0 + nobj];
        c.R2y = cornerY - x[2 + nobj];
        c.impactX = cornerX;
        c.impactY = cornerY;
        c.normalObj = selfIndex;
        c.object = objIndex;
        c.corner = corner;
        double dtol = 0.01;
        if (0.0 <= py && py <= this.height) {
            if (0.0 <= px && px <= this.width) {
                c.colliding = true;
                contacts.addElement(c);
                return;
            }
            if (-dtol <= px && px <= 0.0) {
                c.depth = -px;
                if (this.testVelocity(contacts, c, 3, x)) {
                    return;
                }
            }
            if (this.width <= px && px <= this.width + dtol) {
                c.depth = px - this.width;
                if (this.testVelocity(contacts, c, 1, x)) {
                    return;
                }
            }
        }
        if (0.0 <= px && px <= this.width) {
            if (0.0 <= py && py <= this.height) {
                c.colliding = true;
                contacts.addElement(c);
                return;
            }
            if (-dtol <= py && py <= 0.0) {
                c.depth = -py;
                if (this.testVelocity(contacts, c, 0, x)) {
                    return;
                }
            }
            if (this.height <= py && py <= this.height + dtol) {
                c.depth = py - this.height;
                if (this.testVelocity(contacts, c, 2, x)) {
                    return;
                }
            }
        }
    }
}

