/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.MyLabel;
import com.myphysicslab.simlab.Observer;
import com.myphysicslab.simlab.Subject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JTextField;

class DoubleField
extends JComponent
implements Observer {
    private double value;
    private JTextField field;
    private MyLabel nameLabel;
    private NumberFormat nf;
    private NumberValidator validator;
    private Subject subj;
    private String name;

    public DoubleField(Subject subj, String name, double value, int digits, int columns) {
        this.setLayout(new BorderLayout(1, 1));
        this.subj = subj;
        this.value = value;
        this.name = name;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(digits);
        this.nf.setMinimumFractionDigits(digits);
        this.nameLabel = new MyLabel(name, 0);
        this.add((Component)this.nameLabel, "West");
        this.field = new JTextField(this.nf.format(value), columns);
        this.add((Component)this.field, "East");
        this.validator = new NumberValidator(this);
        this.field.addActionListener(this.validator);
        this.field.addFocusListener(this.validator);
    }

    public DoubleField(Subject subj, String name, int digits) {
        this(subj, name, subj.getParameter(name), digits, 4);
    }

    public DoubleField(Subject subj, String name, double value, int digits) {
        this(subj, name, value, digits, 4);
    }

    public String toString() {
        return "DoubleField \"" + this.name + "\" value=" + this.nf.format(this.value);
    }

    public void update(Subject subj, String param, double value) {
        if (param.equalsIgnoreCase(this.name) && this.value != value) {
            this.value = value;
            this.field.setText(this.nf.format(value));
        }
    }

    private void revert() {
        this.field.setText(this.nf.format(this.value));
    }

    private void modifyValue(double value) {
        this.value = value;
        this.field.setText(this.nf.format(value));
        if (this.subj != null) {
            this.subj.setParameter(this.name, value);
        }
    }

    protected class NumberValidator
    extends FocusAdapter
    implements ActionListener {
        DoubleField dblField;

        protected NumberValidator(DoubleField dblField) {
            this.dblField = dblField;
        }

        public void actionPerformed(ActionEvent event) {
            this.validate((JTextField)event.getSource());
        }

        public void focusGained(FocusEvent event) {
            JTextField tf = (JTextField)event.getSource();
            tf.selectAll();
        }

        public void focusLost(FocusEvent event) {
            JTextField tf = (JTextField)event.getSource();
            this.validate(tf);
            tf.select(0, 0);
        }

        private void validate(JTextField field) {
            try {
                double value = new Double(field.getText());
                if (value != this.dblField.value) {
                    this.dblField.modifyValue(value);
                }
            }
            catch (NumberFormatException e) {
                this.dblField.revert();
            }
        }
    }
}

