/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Drawable;
import java.awt.Color;
import java.awt.Graphics;

abstract class CElement
implements Drawable {
    public static final int NO_DRAW = 0;
    public static final int MODE_RECT = 1;
    public static final int MODE_CIRCLE = 2;
    public static final int MODE_SPRING = 3;
    public static final int MODE_LINE = 4;
    public static final int MODE_CIRCLE_FILLED = 5;
    public static final int MODE_FILLED = 6;
    public double m_X1;
    public double m_Y1;
    public double m_X2;
    public double m_Y2;
    public int m_DrawMode;
    public double m_Mass;
    public Color m_Color;

    public CElement() {
        this.m_Y2 = 0.0;
        this.m_X2 = 0.0;
        this.m_Y1 = 0.0;
        this.m_X1 = 0.0;
        this.m_DrawMode = 0;
        this.m_Mass = 0.0;
        this.m_Color = Color.black;
    }

    public CElement(double X1, double Y1, double X2, double Y2) {
        this.m_X1 = X1;
        this.m_Y1 = Y1;
        this.m_X2 = X2;
        this.m_Y2 = Y2;
        this.m_DrawMode = 0;
        this.m_Mass = 0.0;
        this.m_Color = Color.black;
    }

    public double distanceSquared(double x, double y) {
        double dx = (this.m_X2 + this.m_X1) / 2.0 - x;
        double dy = (this.m_Y2 + this.m_Y1) / 2.0 - y;
        return dx * dx + dy * dy;
    }

    public void setPosition(double x, double y) {
        this.m_X1 = x;
        this.m_Y1 = y;
    }

    public void setBounds(DoubleRect r) {
        this.m_X1 = r.getXMin();
        this.m_Y1 = r.getYMin();
        this.m_X2 = r.getXMax();
        this.m_Y2 = r.getYMax();
    }

    public void setBounds(double x1, double y1, double x2, double y2) {
        this.m_X1 = x1;
        this.m_Y1 = y1;
        this.m_X2 = x2;
        this.m_Y2 = y2;
    }

    public void setX1(double p) {
        this.m_X1 = p;
    }

    public void setX2(double p) {
        this.m_X2 = p;
    }

    public void setY1(double p) {
        this.m_Y1 = p;
    }

    public void setY2(double p) {
        this.m_Y2 = p;
    }

    public abstract void draw(Graphics var1, ConvertMap var2);

    public double getCenterX() {
        return (this.m_X1 + this.m_X2) / 2.0;
    }

    public double getCenterY() {
        return (this.m_Y1 + this.m_Y2) / 2.0;
    }

    public double getX() {
        return this.m_X1;
    }

    public double getY() {
        return this.m_Y1;
    }

    public double getWidth() {
        return this.m_X2 - this.m_X1;
    }

    public double getHeight() {
        return this.m_Y2 - this.m_Y1;
    }
}

