/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CElement;
import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.Dragable;
import java.awt.Color;
import java.awt.Graphics;

class CMass
extends CElement
implements Dragable {
    public double m_Height;
    public double m_Width;
    public double m_Damping = 0.0;
    public double m_Elasticity = 1.0;
    public boolean m_Dragable = false;

    public CMass(double X1, double Y1, double width, double height, int drawMode) {
        super(X1, Y1, X1 + width, Y1 + height);
        this.m_Height = height;
        this.m_Width = width;
        this.m_Mass = 1.0;
        this.m_DrawMode = drawMode;
        this.m_Dragable = true;
        this.m_Color = Color.red;
    }

    public boolean isDragable() {
        return this.m_Dragable;
    }

    public void setPosition(double Xpos, double Ypos) {
        this.m_X1 = Xpos;
        this.m_X2 = Xpos + this.m_Width;
        this.m_Y1 = Ypos;
        this.m_Y2 = Ypos + this.m_Height;
    }

    public void setWidth(double w) {
        this.m_Width = w;
    }

    public void setHeight(double h) {
        this.m_Height = h;
    }

    public void setX1(double Xpos) {
        this.m_X1 = Xpos;
        this.m_X2 = Xpos + this.m_Width;
    }

    public void setY1(double Ypos) {
        this.m_Y1 = Ypos;
        this.m_Y2 = Ypos + this.m_Height;
    }

    public void setCenterX(double Xpos) {
        double w = this.m_Width / 2.0;
        this.m_X1 = Xpos - w;
        this.m_X2 = Xpos + w;
    }

    public void setCenterY(double Ypos) {
        double w = this.m_Width / 2.0;
        this.m_Y1 = Ypos - w;
        this.m_Y2 = Ypos + w;
    }

    public void draw(Graphics g, ConvertMap map) {
        int x1 = map.simToScreenX(this.m_X1);
        int y1 = map.simToScreenY(this.m_Y1);
        int x2 = map.simToScreenX(this.m_X2);
        int y2 = map.simToScreenY(this.m_Y2);
        if (y2 < y1) {
            int d = y2;
            y2 = y1;
            y1 = d;
        }
        g.setColor(this.m_Color);
        switch (this.m_DrawMode) {
            case 0: {
                break;
            }
            case 1: {
                g.drawRect(x1, y1, x2 - x1, y2 - y1);
                break;
            }
            case 2: {
                g.drawOval(x1, y1, x2 - x1, y2 - y1);
                break;
            }
            case 5: {
                g.fillOval(x1, y1, x2 - x1, y2 - y1);
            }
        }
    }
}

