/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.C2Points;
import com.myphysicslab.simlab.CPath_Cardioid;
import com.myphysicslab.simlab.CPath_Circle;
import com.myphysicslab.simlab.CPath_Flat;
import com.myphysicslab.simlab.CPath_Hump;
import com.myphysicslab.simlab.CPath_Lemniscate;
import com.myphysicslab.simlab.CPath_Loop;
import com.myphysicslab.simlab.CPath_Oval;
import com.myphysicslab.simlab.CPath_Spiral;
import com.myphysicslab.simlab.CPoint;
import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.Drawable;
import com.myphysicslab.simlab.PathName;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

abstract class CPath
implements Drawable {
    protected static final int DRAW_POINTS = 500;
    protected static final int DATA_POINTS = 9000;
    private static final int BALLS = 4;
    private double[] xvals;
    private double[] yvals;
    private double[] pvals;
    protected boolean closed = false;
    protected double plen = 0.0;
    public double tLo = 0.0;
    public double tHi = 1.0;
    private PathName pathName;
    private int[] p_index;
    private int[] x_index;
    public double left = 0.0;
    public double top = 1.0;
    public double right = 1.0;
    public double bottom = 0.0;
    public boolean exact_slope = false;

    public static CPath makePath(PathName pName) {
        CPath p = null;
        if (pName == PathName.HUMP) {
            p = new CPath_Hump();
        } else if (pName == PathName.LOOP) {
            p = new CPath_Loop();
        } else if (pName == PathName.CIRCLE) {
            p = new CPath_Circle();
        } else if (pName == PathName.FLAT) {
            p = new CPath_Flat();
        } else if (pName == PathName.LEMNISCATE) {
            p = new CPath_Lemniscate();
        } else if (pName == PathName.OVAL) {
            p = new CPath_Oval();
        } else if (pName == PathName.SPIRAL) {
            p = new CPath_Spiral();
        } else if (pName == PathName.CARDIOID) {
            p = new CPath_Cardioid();
        } else {
            throw new IllegalArgumentException("no such path " + pName);
        }
        p.pathName = pName;
        return p;
    }

    CPath() {
        this.initialize();
        this.xvals = new double[9000];
        this.yvals = new double[9000];
        this.pvals = new double[9000];
        this.p_index = new int[4];
        this.x_index = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.p_index[i] = -1;
            this.x_index[i] = -1;
        }
        this.make_table();
    }

    public String toString() {
        return "Path " + this.pathName;
    }

    public double path_lo() {
        return this.pvals[0];
    }

    public double path_hi() {
        return this.pvals[8999];
    }

    public double modp(double p) {
        if (this.closed && (p < 0.0 || p > this.plen)) {
            p -= this.plen * Math.floor(p / this.plen);
        }
        return p;
    }

    protected abstract void initialize();

    protected abstract double x_func(double var1);

    protected abstract double y_func(double var1);

    protected double my_path_func(double x) {
        throw new RuntimeException();
    }

    protected double slope(double p) {
        throw new RuntimeException();
    }

    public boolean off_track(double x) {
        if (this.closed) {
            return false;
        }
        return x < this.xvals[0] || x > this.xvals[8999];
    }

    public double off_track_adjust(double x) {
        if (x < this.xvals[0]) {
            x = this.xvals[0] + 0.1;
        }
        if (x > this.xvals[8999]) {
            x = this.xvals[8999] - 0.1;
        }
        return x;
    }

    private int binSearch(double[] arr, double x, int guess) {
        int max;
        int min;
        boolean dir;
        int n = arr.length;
        if (n < 2) {
            throw new IllegalArgumentException("array must have more than one element");
        }
        boolean bl = dir = arr[0] < arr[n - 1];
        int i = guess < 0 ? 0 : (guess > 0 ? n - 1 : guess);
        if (dir) {
            min = 0;
            max = n - 1;
        } else {
            min = n - 1;
            max = 0;
        }
        if (dir) {
            if (x < arr[0]) {
                return -1;
            }
            if (x > arr[n - 1]) {
                return n;
            }
        } else {
            if (x < arr[n - 1]) {
                return n;
            }
            if (x > arr[0]) {
                return -1;
            }
        }
        while (Math.abs(max - min) > 1) {
            if (x > arr[i]) {
                if (dir) {
                    min = i;
                } else {
                    max = i;
                }
            } else if (dir) {
                max = i;
            } else {
                min = i;
            }
            if (dir) {
                i = min + (max - min) / 2;
                continue;
            }
            i = max + (min - max) / 2;
        }
        return i;
    }

    private void make_table_old() {
        double delta = (this.tHi - this.tLo) / 9000.0;
        double halfdelta = delta / 2.0;
        double t = this.tLo;
        double p = 0.0;
        for (int i = 0; i < 9000; ++i) {
            this.xvals[i] = this.x_func(t);
            this.pvals[i] = p;
            this.yvals[i] = this.y_func(t);
            double p1 = this.my_path_func(t) / 3.0;
            double p2 = 4.0 * this.my_path_func(t + halfdelta) / 3.0;
            double p3 = this.my_path_func(t + delta) / 3.0;
            p += halfdelta * (p1 + p2 + p3);
            t += delta;
        }
        this.plen = this.pvals[8999];
    }

    private void make_table() {
        boolean warn = true;
        double delta = (this.tHi - this.tLo) / 8999.0;
        double t = this.tLo;
        double p = 0.0;
        this.pvals[0] = 0.0;
        this.xvals[0] = this.x_func(t);
        this.yvals[0] = this.y_func(t);
        int i = 1;
        do {
            this.xvals[i] = this.x_func(t += delta);
            this.yvals[i] = this.y_func(t);
            double dx = this.xvals[i] - this.xvals[i - 1];
            if (warn && dx == 0.0) {
                System.out.println("track has a vertical section");
                warn = false;
            }
            double dy = this.yvals[i] - this.yvals[i - 1];
            this.pvals[i] = p += Math.sqrt(dx * dx + dy * dy);
        } while (++i < 9000);
        this.plen = this.pvals[8999];
    }

    private double interp4(double[] xx, double[] yy, double x, int i) {
        if (i < 0) {
            i = 0;
        }
        if (i > 8996) {
            i = 8996;
        }
        double c1 = yy[i + 0];
        double c2 = (yy[i + 1] - c1) / (xx[i + 1] - xx[i + 0]);
        double c3 = (yy[i + 2] - (c1 + c2 * (xx[i + 2] - xx[i + 0]))) / ((xx[i + 2] - xx[i + 0]) * (xx[i + 2] - xx[i + 1]));
        double c4 = yy[i + 3] - (c1 + c2 * (xx[i + 3] - xx[i + 0]) + c3 * (xx[i + 3] - xx[i + 0]) * (xx[i + 3] - xx[i + 1]));
        double y = (((c4 /= (xx[i + 3] - xx[i + 0]) * (xx[i + 3] - xx[i + 1]) * (xx[i + 3] - xx[i + 2])) * (x - xx[i + 2]) + c3) * (x - xx[i + 1]) + c2) * (x - xx[i + 0]) + c1;
        return y;
    }

    public void map_x(CPoint pt) {
        this.x_index[pt.ball] = this.binSearch(this.xvals, pt.x, this.x_index[pt.ball]);
        int k = this.x_index[pt.ball];
        pt.y = this.interp4(this.xvals, this.yvals, pt.x, k - 1);
        pt.p = this.interp4(this.xvals, this.pvals, pt.x, k - 1);
    }

    public double map_x_to_y(double x, int ball) {
        this.x_index[ball] = this.binSearch(this.xvals, x, this.x_index[ball]);
        return this.interp4(this.xvals, this.yvals, x, this.x_index[ball] - 1);
    }

    public double map_x_to_p(double x, int ball) {
        this.x_index[ball] = this.binSearch(this.xvals, x, this.x_index[ball]);
        return this.interp4(this.xvals, this.pvals, x, this.x_index[ball] - 1);
    }

    public double map_p_to_x(double p, int ball) {
        p = this.modp(p);
        this.p_index[ball] = this.binSearch(this.pvals, p, this.p_index[ball]);
        return this.interp4(this.pvals, this.xvals, p, this.p_index[ball] - 1);
    }

    public double map_p_to_y(double p, int ball) {
        p = this.modp(p);
        this.p_index[ball] = this.binSearch(this.pvals, p, this.p_index[ball]);
        return this.interp4(this.pvals, this.yvals, p, this.p_index[ball] - 1);
    }

    public double map_x_y_to_p(double x, double y) {
        double best_len = Double.MAX_VALUE;
        double p = -9.99999999E8;
        for (int i = 0; i < 9000; ++i) {
            double xd = x - this.xvals[i];
            double yd = y - this.yvals[i];
            double len = xd * xd + yd * yd;
            if (!(len < best_len)) continue;
            best_len = len;
            p = this.pvals[i];
        }
        return p;
    }

    public void closest_to_x_y(CPoint pt, double x, double y) {
        double best_len = Double.MAX_VALUE;
        for (int i = 0; i < 9000; ++i) {
            double xd = x - this.xvals[i];
            double yd = y - this.yvals[i];
            double len = xd * xd + yd * yd;
            if (!(len < best_len)) continue;
            best_len = len;
            pt.x = this.xvals[i];
            pt.y = this.yvals[i];
            pt.p = this.pvals[i];
        }
    }

    public void closest_slope(double x, double y, double p_guess, CPoint pt) {
        int i = this.binSearch(this.pvals, p_guess = this.modp(p_guess), this.p_index[pt.ball]);
        if (i < 0) {
            i = 1;
        } else if (i > 8999) {
            i = 8998;
        } else {
            double len;
            double xd = x - this.xvals[i];
            double yd = y - this.yvals[i];
            double best_len = xd * xd + yd * yd;
            while (i < 8998 && !((len = (xd = x - this.xvals[i + 1]) * xd + (yd = y - this.yvals[i + 1]) * yd) > best_len)) {
                ++i;
            }
            while (i > 1 && !((len = (xd = x - this.xvals[i - 1]) * xd + (yd = y - this.yvals[i - 1]) * yd) > best_len)) {
                --i;
            }
        }
        double dx = this.xvals[i + 1] - this.xvals[i - 1];
        double dy = this.yvals[i + 1] - this.yvals[i - 1];
        pt.slope = dy / dx;
        if (dx == 0.0) {
            System.out.println("**** infinite slope ****");
        }
        pt.p = this.pvals[i];
    }

    public void map_p_to_slope(CPoint pt) {
        pt.p = this.modp(pt.p);
        this.p_index[pt.ball] = this.binSearch(this.pvals, pt.p, this.p_index[pt.ball]);
        int k = this.p_index[pt.ball];
        if (k < 0) {
            k = 1;
        }
        if (k >= 8999) {
            k = 8998;
        }
        pt.x = this.interp4(this.pvals, this.xvals, pt.p, k - 1);
        pt.y = this.interp4(this.pvals, this.yvals, pt.p, k - 1);
        if (this.xvals[k + 1] == this.xvals[k]) {
            pt.direction = this.yvals[k + 1] > this.yvals[k] ? 1 : -1;
            pt.slope = this.exact_slope ? this.slope(pt.p) : Double.POSITIVE_INFINITY;
            pt.radius = Double.POSITIVE_INFINITY;
        } else {
            double dy;
            double dx;
            int n = pt.direction = this.xvals[k + 1] > this.xvals[k] ? 1 : -1;
            if (this.exact_slope) {
                pt.slope = this.slope(pt.p);
            } else {
                dx = this.xvals[k + 1] - this.xvals[k];
                dy = this.yvals[k + 1] - this.yvals[k];
                pt.slope = dy / dx;
            }
            if (pt.radius_flag) {
                if (k < 2 || k > 8996) {
                    pt.radius = Double.POSITIVE_INFINITY;
                } else {
                    dx = this.xvals[k] - this.xvals[k - 2];
                    dy = this.yvals[k] - this.yvals[k - 2];
                    double b1 = dy / dx;
                    double p1 = this.pvals[k - 1];
                    dx = this.xvals[k + 3] - this.xvals[k + 1];
                    dy = this.yvals[k + 3] - this.yvals[k + 1];
                    double b2 = dy / dx;
                    double p2 = this.pvals[k + 2];
                    pt.radius = (p2 - p1) / (Math.atan(b2) - Math.atan(b1));
                }
            }
        }
    }

    public void find_intersect(C2Points pts, double ax, double ay, double qx, double qy) {
        double y;
        double x;
        boolean flip = false;
        if (qx < ax) {
            double h = ax;
            ax = qx;
            qx = h;
            h = ay;
            ay = qy;
            qy = h;
            flip = true;
        }
        this.x_index[pts.ball] = this.binSearch(this.xvals, ax, this.x_index[pts.ball]);
        int k = this.x_index[pts.ball];
        if (k < 0) {
            k = 0;
        }
        if (k >= 9000) {
            k = 8999;
        }
        if (ax == qx) {
            double slope2 = (this.yvals[k + 1] - this.yvals[k]) / (this.xvals[k + 1] - this.xvals[k]);
            x = ax;
            y = this.yvals[k] + slope2 * (x - this.xvals[k]);
        } else {
            double slope1 = (qy - ay) / (qx - ax);
            y = this.interp4(this.xvals, this.yvals, ax, k - 1);
            if (y == ay) {
                x = ax;
                double slope2 = (this.yvals[k] - this.yvals[k - 1]) / (this.xvals[k] - this.xvals[k - 1]);
                System.out.println("exact intersection");
            } else {
                boolean below2;
                double traj_y = ay;
                boolean below = y < traj_y;
                int i = k;
                do {
                    if (++i > 8999) {
                        i = 8999;
                        break;
                    }
                    if (!(this.xvals[i - 1] > qx)) continue;
                    if (i == 1) {
                        i = 1;
                        break;
                    }
                    System.out.println("intersection trouble");
                    return;
                } while ((below2 = this.yvals[i] < (traj_y = ay + slope1 * (this.xvals[i] - ax))) == below);
                double slope2 = (this.yvals[i] - this.yvals[i - 1]) / (this.xvals[i] - this.xvals[i - 1]);
                x = (-slope1 * ax + slope2 * this.xvals[i] + ay - this.yvals[i]) / (slope2 - slope1);
                y = ay + slope1 * (x - ax);
            }
        }
        pts.x1 = x;
        pts.y1 = y;
    }

    public void draw(Graphics g, ConvertMap map) {
        double p_final = this.pvals[8999];
        double p_first = this.pvals[0];
        if (p_final <= p_first) {
            System.out.println("draw_track reports track data is out of order");
        }
        double delta = (p_final - p_first) / 500.0;
        int p_index = 0;
        double p_prev = this.pvals[p_index];
        double x = this.xvals[p_index];
        double y = this.yvals[p_index];
        int scrx = map.simToScreenX(x);
        int scry = map.simToScreenY(y);
        g.setPaintMode();
        g.setColor(Color.white);
        Rectangle r = map.getScreenRect();
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        while (true) {
            double p;
            if (++p_index > 8999) {
                p = p_final;
                p_index = 8999;
            } else {
                p = this.pvals[p_index];
                if (p - p_prev < delta) continue;
            }
            p_prev = p;
            int oldx = scrx;
            int oldy = scry;
            x = this.xvals[p_index];
            y = this.yvals[p_index];
            scrx = map.simToScreenX(x);
            scry = map.simToScreenY(y);
            g.drawLine(oldx, oldy, scrx, scry);
            if (!(p < p_final)) break;
        }
    }
}

