/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class Double2DSpring
extends Simulation
implements ActionListener {
    private CMass mass1;
    private CMass mass2;
    private CMass topMass;
    private CSpring spring1;
    private CSpring spring2;
    private double gravity = 9.8;
    private double damping = 0.0;
    private JButton button_stop;
    private static final String MASS1 = "mass1";
    private static final String MASS2 = "mass2";
    private static final String LENGTH1 = "spring1 length";
    private static final String LENGTH2 = "spring2 length";
    private static final String STIFF1 = "spring1 stiffness";
    private static final String STIFF2 = "spring2 stiffness";
    private static final String DAMPING = "damping";
    private static final String GRAVITY = "gravity";
    private String[] params = new String[]{"mass1", "mass2", "spring1 length", "spring2 length", "spring1 stiffness", "spring2 stiffness", "damping", "gravity"};

    public Double2DSpring(Container container) {
        super(container, 8);
        this.var_names = new String[]{"x1 position", "y1 position", "x2 position", "y2 position", "x1 velocity", "y1 velocity", "x2 velocity", "y2 velocity"};
        this.setCoordMap(new CoordMap(1, -6.0, 6.0, -6.0, 6.0, 0, 0));
        double xx = 0.0;
        double yy = -2.0;
        double w = 0.5;
        this.topMass = new CMass(xx - w / 2.0, yy - w, w, w, 1);
        this.cvs.addElement(this.topMass);
        this.spring1 = new CSpring(xx, yy, 1.0, 0.3);
        this.spring1.setX2(xx);
        this.spring1.m_SpringConst = 6.0;
        this.cvs.addElement(this.spring1);
        this.mass1 = new CMass(xx - w / 2.0, 0.0, w, w, 2);
        this.mass1.m_Mass = 0.5;
        this.mass2 = new CMass(xx - w / 2.0, 0.0, w, w, 2);
        this.mass2.m_Mass = 0.5;
        double yy2 = yy + this.spring1.m_RestLength + (this.mass1.m_Mass + this.mass2.m_Mass) * this.gravity / this.spring1.m_SpringConst;
        this.mass1.setY1(yy2 - w / 2.0);
        this.spring1.setY2(yy2);
        this.mass1.m_Damping = 0.0;
        this.cvs.addElement(this.mass1);
        this.spring2 = new CSpring(xx, yy2, 1.0, 0.3);
        this.spring2.setX2(xx);
        this.spring2.m_SpringConst = 6.0;
        this.cvs.addElement(this.spring2);
        double yy3 = yy2 + this.spring2.m_RestLength + this.mass2.m_Mass * this.gravity / this.spring2.m_SpringConst;
        this.mass2.setY1(yy3 - w / 2.0);
        this.spring2.setY2(yy3);
        this.mass2.m_Damping = 0.0;
        this.cvs.addElement(this.mass2);
        this.stopMotion();
        this.vars[0] = this.vars[0] + 0.5;
        this.vars[1] = this.vars[1] + 0.5;
        this.modifyObjects();
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 1);
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS1)) {
            this.mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            this.mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH1)) {
            this.spring1.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH2)) {
            this.spring2.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFF1)) {
            this.spring1.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFF2)) {
            this.spring2.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS1)) {
            return this.mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            return this.mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(LENGTH1)) {
            return this.spring1.m_RestLength;
        }
        if (name.equalsIgnoreCase(LENGTH2)) {
            return this.spring2.m_RestLength;
        }
        if (name.equalsIgnoreCase(STIFF1)) {
            return this.spring1.m_SpringConst;
        }
        if (name.equalsIgnoreCase(STIFF2)) {
            return this.spring2.m_SpringConst;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.damping;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    private void stopMotion() {
        double m1 = this.mass1.m_Mass;
        double m2 = this.mass2.m_Mass;
        double k1 = this.spring1.m_SpringConst;
        double k2 = this.spring2.m_SpringConst;
        double r1 = this.spring1.m_RestLength;
        double r2 = this.spring2.m_RestLength;
        double T = this.topMass.m_Y2;
        this.vars[0] = this.vars[2] = this.topMass.m_X1 + this.topMass.m_Width / 2.0;
        this.vars[1] = this.gravity * (m1 + m2) / k1 + r1 + T;
        this.vars[3] = this.gravity * (m2 / k2 + (m1 + m2) / k1) + r1 + r2 + T;
        this.vars[7] = 0.0;
        this.vars[6] = 0.0;
        this.vars[5] = 0.0;
        this.vars[4] = 0.0;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.stopMotion();
        }
    }

    public void modifyObjects() {
        double w = this.mass1.m_Width / 2.0;
        this.mass1.setPosition(this.vars[0] - w, this.vars[1] - w);
        this.mass2.setPosition(this.vars[2] - w, this.vars[3] - w);
        this.spring1.setX2(this.mass1.m_X1 + w);
        this.spring1.setY2(this.mass1.m_Y1 + w);
        this.spring2.setBounds(this.mass1.m_X1 + w, this.mass1.m_Y1 + w, this.mass2.m_X1 + w, this.mass2.m_Y1 + w);
    }

    public void startDrag(Dragable e) {
        if (e == this.mass1) {
            this.calc[5] = false;
            this.calc[4] = false;
            this.calc[1] = false;
            this.calc[0] = false;
        } else if (e == this.mass2) {
            this.calc[7] = false;
            this.calc[6] = false;
            this.calc[3] = false;
            this.calc[2] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        double w = this.mass1.m_Width / 2.0;
        if (e == this.topMass) {
            e.setPosition(x, y);
            this.spring1.setPosition(x + this.topMass.m_Width / 2.0, y + this.topMass.m_Height);
        } else if (e == this.mass1) {
            this.vars[0] = x + w;
            this.vars[1] = y + w;
            this.vars[5] = 0.0;
            this.vars[4] = 0.0;
            this.modifyObjects();
        } else if (e == this.mass2) {
            this.vars[2] = x + w;
            this.vars[3] = y + w;
            this.vars[7] = 0.0;
            this.vars[6] = 0.0;
            this.modifyObjects();
        }
    }

    public void evaluate(double[] x, double[] change) {
        double xx = x[0] - this.spring1.m_X1;
        double yy = x[1] - this.spring1.m_Y1;
        double len1 = Math.sqrt(xx * xx + yy * yy);
        double m1 = this.mass1.m_Mass;
        double xx2 = x[2] - x[0];
        double yy2 = x[3] - x[1];
        double len2 = Math.sqrt(xx2 * xx2 + yy2 * yy2);
        double m2 = this.mass2.m_Mass;
        change[0] = x[4];
        change[1] = x[5];
        change[2] = x[6];
        change[3] = x[7];
        double r = -(this.spring1.m_SpringConst / m1) * (len1 - this.spring1.m_RestLength) * xx / len1;
        r += this.spring2.m_SpringConst / m1 * (len2 - this.spring2.m_RestLength) * xx2 / len2;
        if (this.damping != 0.0) {
            r -= this.damping / m1 * x[4];
        }
        change[4] = r;
        r = this.gravity - this.spring1.m_SpringConst / m1 * (len1 - this.spring1.m_RestLength) * yy / len1;
        r += this.spring2.m_SpringConst / m1 * (len2 - this.spring2.m_RestLength) * yy2 / len2;
        if (this.damping != 0.0) {
            r -= this.damping / m1 * x[5];
        }
        change[5] = r;
        r = -(this.spring2.m_SpringConst / m2) * (len2 - this.spring2.m_RestLength) * xx2 / len2;
        if (this.damping != 0.0) {
            r -= this.damping / m2 * x[6];
        }
        change[6] = r;
        r = this.gravity - this.spring2.m_SpringConst / m2 * (len2 - this.spring2.m_RestLength) * yy2 / len2;
        if (this.damping != 0.0) {
            r -= this.damping / m2 * x[7];
        }
        change[7] = r;
    }
}

