/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class DoubleSpringSim
extends Simulation
implements ActionListener {
    private CSpring m_Spring1;
    private CSpring m_Spring2;
    private CSpring m_Spring3;
    private CMass m_Mass1;
    private CMass m_Mass2;
    private JButton button_stop;
    private static final String MASS_L = "left mass";
    private static final String LENGTH_1 = "spring 1 length";
    private static final String STIFF_1 = "spring 1 stiffness";
    private static final String MASS_R = "right mass";
    private static final String STIFF_3 = "spring 3 stiffness";
    private static final String LENGTH_3 = "spring 3 length";
    private static final String STIFF_2 = "spring 2 stiffness";
    private static final String LENGTH_2 = "spring 2 length";
    private static final String WALL_R = "right wall position";
    private String[] params = new String[]{"left mass", "right mass", "spring 1 stiffness", "spring 1 length", "spring 2 stiffness", "spring 2 length"};
    private String[] params3 = new String[]{"left mass", "right mass", "spring 1 stiffness", "spring 1 length", "spring 2 stiffness", "spring 2 length", "spring 3 stiffness", "spring 3 length", "right wall position"};

    public DoubleSpringSim(Container container, int numSprings) {
        super(container, 4);
        if (numSprings == 3) {
            this.params = this.params3;
        }
        this.var_names = new String[]{"position left", "position right", "velocity left", "velocity right", "acceleration left", "acceleration right", "total energy"};
        this.setCoordMap(new CoordMap(1, -0.5, 9.5, -1.5, 1.5, 1, 0));
        this.m_Spring1 = new CSpring(0.0, 0.0, 2.0, 0.5);
        this.m_Spring1.m_SpringConst = 6.0;
        this.cvs.addElement(this.m_Spring1);
        double w = 0.75;
        this.m_Mass1 = new CMass(this.m_Spring1.m_X2 + 0.5, -w / 2.0, w, w, 1);
        this.m_Mass1.m_Mass = 1.0;
        this.cvs.addElement(this.m_Mass1);
        this.m_Spring2 = new CSpring(this.m_Mass1.m_X2, 0.0, 2.0, 0.5);
        this.m_Spring2.m_SpringConst = 6.0;
        this.cvs.addElement(this.m_Spring2);
        this.m_Mass2 = new CMass(this.m_Spring2.m_X2 + 1.0, -w / 2.0, w, w, 1);
        this.m_Mass2.m_Mass = 1.0;
        this.cvs.addElement(this.m_Mass2);
        this.m_Spring3 = new CSpring(this.m_Mass2.m_X2, 0.0, 2.0, 0.5);
        this.m_Spring3.m_SpringConst = numSprings == 3 ? 6.0 : 0.0;
        this.m_Spring3.m_X2 += 1.0;
        this.cvs.addElement(this.m_Spring3);
        this.vars[0] = this.m_Mass1.m_X1;
        this.vars[1] = this.m_Mass2.m_X1;
        this.vars[2] = 0.0;
        this.vars[3] = 0.0;
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        this.showGraph(false);
        if (this.graph != null) {
            this.graph.setVars(0, 1);
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS_L)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFF_1)) {
            this.m_Spring1.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH_1)) {
            this.m_Spring1.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS_R)) {
            this.m_Mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFF_2)) {
            this.m_Spring2.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH_2)) {
            this.m_Spring2.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFF_3)) {
            this.m_Spring3.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH_3)) {
            this.m_Spring3.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(WALL_R)) {
            this.m_Spring3.setX2(value);
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS_L)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(STIFF_1)) {
            return this.m_Spring1.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH_1)) {
            return this.m_Spring1.m_RestLength;
        }
        if (name.equalsIgnoreCase(MASS_R)) {
            return this.m_Mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(STIFF_2)) {
            return this.m_Spring2.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH_2)) {
            return this.m_Spring2.m_RestLength;
        }
        if (name.equalsIgnoreCase(STIFF_3)) {
            return this.m_Spring3.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH_3)) {
            return this.m_Spring3.m_RestLength;
        }
        if (name.equalsIgnoreCase(WALL_R)) {
            return this.m_Spring3.m_X2;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            double k1 = this.m_Spring1.m_SpringConst;
            double k2 = this.m_Spring2.m_SpringConst;
            double k3 = this.m_Spring3.m_SpringConst;
            double w1 = this.m_Mass1.m_Width;
            double w2 = this.m_Mass2.m_Width;
            double R1 = this.m_Spring1.m_RestLength;
            double R2 = this.m_Spring2.m_RestLength;
            double R3 = this.m_Spring3.m_RestLength;
            double Wall2 = this.m_Spring3.m_X2;
            if (k2 == 0.0) {
                this.vars[0] = R1;
                this.vars[1] = Wall2 - R3 - w2;
            } else {
                double u1 = k1 * R1 + k3 * (Wall2 + k1 * R1 / k2 - w1 - R2 - w2 - R3);
                this.vars[0] = u1 /= k1 + k3 * (1.0 + k1 / k2);
                this.vars[1] = k1 / k2 * (u1 - R1) + u1 + w1 + R2;
            }
            this.vars[2] = 0.0;
            this.vars[3] = 0.0;
        }
    }

    public void modifyObjects() {
        this.m_Mass1.setX1(this.vars[0]);
        this.m_Spring1.setX2(this.m_Mass1.m_X1);
        this.m_Mass2.setX1(this.vars[1]);
        this.m_Spring2.setX1(this.m_Mass1.m_X2);
        this.m_Spring2.setX2(this.m_Mass2.m_X1);
        this.m_Spring3.setX1(this.m_Mass2.m_X2);
    }

    public void startDrag(Dragable e) {
        if (e == this.m_Mass1) {
            this.calc[0] = false;
            this.calc[2] = false;
        } else if (e == this.m_Mass2) {
            this.calc[1] = false;
            this.calc[3] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.m_Mass1) {
            this.vars[0] = x;
            this.vars[2] = 0.0;
        } else if (e == this.m_Mass2) {
            this.vars[1] = x;
            this.vars[3] = 0.0;
        }
        this.modifyObjects();
    }

    public int numVariables() {
        return this.var_names.length;
    }

    public double getVariable(int i) {
        if (i <= 3) {
            return this.vars[i];
        }
        if (i <= 5) {
            double[] rate = new double[this.vars.length];
            this.evaluate(this.vars, rate);
            return rate[i - 2];
        }
        double k = 0.5 * (this.m_Mass1.m_Mass * this.vars[2] * this.vars[2] + this.m_Mass2.m_Mass * this.vars[3] * this.vars[3]);
        double x1 = this.vars[0] - this.m_Spring1.m_RestLength;
        double x2 = this.vars[1] - this.vars[0] - this.m_Mass1.m_Width - this.m_Spring2.m_RestLength;
        double x3 = this.m_Spring3.m_X2 - (this.vars[1] + this.m_Mass2.m_Width) - this.m_Spring3.m_RestLength;
        double p = 0.5 * (this.m_Spring1.m_SpringConst * x1 * x1 + this.m_Spring2.m_SpringConst * x2 * x2 + this.m_Spring3.m_SpringConst * x3 * x3);
        return k + p;
    }

    public void evaluate(double[] x, double[] change) {
        change[0] = x[2];
        change[1] = x[3];
        double r1 = -(this.m_Spring1.m_SpringConst / this.m_Mass1.m_Mass) * (x[0] - this.m_Spring1.m_RestLength);
        double r2 = this.m_Spring2.m_SpringConst / this.m_Mass1.m_Mass * (x[1] - x[0] - this.m_Mass1.m_Width - this.m_Spring2.m_RestLength);
        change[2] = r1 + r2;
        change[3] = -(this.m_Spring2.m_SpringConst / this.m_Mass2.m_Mass) * (x[1] - x[0] - this.m_Mass1.m_Width - this.m_Spring2.m_RestLength);
        change[3] = change[3] + this.m_Spring3.m_SpringConst / this.m_Mass2.m_Mass * (this.m_Spring3.m_X2 - (x[1] + this.m_Mass2.m_Width) - this.m_Spring3.m_RestLength);
    }
}

