/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CollideSpring;
import com.myphysicslab.simlab.ContactSim;
import com.myphysicslab.simlab.DangleStick;
import com.myphysicslab.simlab.Double2DSpring;
import com.myphysicslab.simlab.DoublePendulum;
import com.myphysicslab.simlab.DoubleSpringSim;
import com.myphysicslab.simlab.Graph;
import com.myphysicslab.simlab.Molecule1;
import com.myphysicslab.simlab.Molecule3;
import com.myphysicslab.simlab.MoveableDoublePendulum;
import com.myphysicslab.simlab.Pendulum2;
import com.myphysicslab.simlab.PendulumCart;
import com.myphysicslab.simlab.PendulumSim;
import com.myphysicslab.simlab.Roller1;
import com.myphysicslab.simlab.Roller2;
import com.myphysicslab.simlab.Roller3;
import com.myphysicslab.simlab.Roller4;
import com.myphysicslab.simlab.Roller5;
import com.myphysicslab.simlab.SimFrame;
import com.myphysicslab.simlab.SimThread;
import com.myphysicslab.simlab.Simulation;
import com.myphysicslab.simlab.Spring2DSim;
import com.myphysicslab.simlab.SpringSim1;
import com.myphysicslab.simlab.String1;
import com.myphysicslab.simlab.Thruster5;
import com.myphysicslab.simlab.Utility;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JApplet;
import javax.swing.JComboBox;

public class Lab
extends JApplet
implements ItemListener {
    private SimThread timer = null;
    private Simulation sim = null;
    private JComboBox simMenu = null;
    private boolean browserMode = true;
    private boolean gameMode = false;
    private int currentSimMenuItem = -1;
    private String[] sims = new String[]{"single spring", "double spring", "pendulum", "2D spring", "double pendulum", "double 2D spring", "collide spring", "molecule", "molecule 2", "molecule 3", "molecule 4", "molecule 5", "molecule 6", "pendulum cart", "dangle stick", "rigid body collisions", "contact", "roller coaster", "Roller Coaster with Spring", "Roller Coaster with 2 Balls", "Roller Coaster with Flight", "Roller Coaster Lagrangian", "string", "Moveable Double Pendulum", "pendulum 2"};

    public static void main(String[] args) {
        Lab applet = new Lab(false);
        SimFrame frame = new SimFrame(applet);
        frame.setContentPane(applet.getContentPane());
        frame.setVisible(true);
        ((Applet)applet).init();
    }

    public Lab() {
    }

    public Lab(boolean browserMode) {
        this();
        this.browserMode = browserMode;
    }

    public void init() {
        int i;
        String s;
        System.out.println("starting MyPhysicsLab 0.9.1_04");
        if (!this.browserMode) {
            this.createMenu();
        }
        this.gameMode = (s = this.getParameter("game")) != null ? s.equalsIgnoreCase("true") : false;
        s = this.getParameter("simulation");
        if (s != null) {
            for (i = 0; i < this.sims.length; ++i) {
                if (!s.equalsIgnoreCase(this.sims[i])) continue;
                this.startSim(i);
                break;
            }
        }
        if (this.sim == null) {
            throw new IllegalStateException("unable to create simulation " + s);
        }
        Utility.println("Simulation " + s + " created.");
        s = this.getParameter("showControls");
        if (s != null) {
            this.sim.showControls(s.equalsIgnoreCase("true"));
        }
        if ((s = this.getParameter("showGraph")) != null) {
            this.sim.showGraph(s.equalsIgnoreCase("true"));
        }
        if (this.sim.getGraph() != null) {
            s = this.getParameter("graphXVar");
            if (s != null) {
                this.sim.getGraph().setXVar(Integer.parseInt(s));
            }
            if ((s = this.getParameter("graphYVar")) != null) {
                this.sim.getGraph().setYVar(Integer.parseInt(s));
            }
            if ((s = this.getParameter("graphMode")) != null) {
                if (s.equalsIgnoreCase("dots")) {
                    this.sim.getGraph().setDrawMode(0);
                } else if (s.equalsIgnoreCase("lines")) {
                    this.sim.getGraph().setDrawMode(1);
                } else {
                    Utility.println("Could not set graphMode to " + s);
                }
            }
        }
        for (i = 0; i < this.sim.numVariables(); ++i) {
            s = this.getParameter("variable" + i);
            if (s == null) continue;
            this.sim.setVariable(i, new Double(s));
        }
        String[] params = this.sim.getParameterNames();
        for (int i2 = 0; i2 < params.length; ++i2) {
            s = this.getParameter(params[i2]);
            if (s == null) continue;
            this.sim.setParameter(params[i2], new Double(s));
        }
    }

    private void createMenu() {
        this.simMenu = new JComboBox();
        for (int i = 0; i < this.sims.length; ++i) {
            this.simMenu.addItem(this.sims[i]);
        }
        this.simMenu.addItemListener(this);
        this.getContentPane().add(this.simMenu);
    }

    public String[] getSimNames() {
        return (String[])this.sims.clone();
    }

    private void startSim(int simIndex) {
        Utility.println("startSim(" + simIndex + ")");
        if (this.sim != null) {
            Utility.println("stopping and shutting down " + this.sim);
            this.stop();
            this.sim.shutDown();
            this.sim = null;
            this.currentSimMenuItem = -1;
        }
        if (simIndex < 0) {
            return;
        }
        System.out.println("starting simulation " + this.sims[simIndex]);
        switch (simIndex) {
            case 0: {
                this.sim = new SpringSim1(this.getContentPane());
                break;
            }
            case 1: {
                this.sim = new DoubleSpringSim(this.getContentPane(), 2);
                break;
            }
            case 2: {
                this.sim = new PendulumSim(this.getContentPane());
                break;
            }
            case 3: {
                this.sim = new Spring2DSim(this.getContentPane());
                break;
            }
            case 4: {
                this.sim = new DoublePendulum(this.getContentPane());
                break;
            }
            case 5: {
                this.sim = new Double2DSpring(this.getContentPane());
                break;
            }
            case 6: {
                this.sim = new CollideSpring(this.getContentPane());
                break;
            }
            case 7: {
                this.sim = new Molecule1(this.getContentPane());
                break;
            }
            case 8: {
                this.sim = new Molecule3(this.getContentPane(), 2);
                break;
            }
            case 9: {
                this.sim = new Molecule3(this.getContentPane(), 3);
                break;
            }
            case 10: {
                this.sim = new Molecule3(this.getContentPane(), 4);
                break;
            }
            case 11: {
                this.sim = new Molecule3(this.getContentPane(), 5);
                break;
            }
            case 12: {
                this.sim = new Molecule3(this.getContentPane(), 6);
                break;
            }
            case 13: {
                this.sim = new PendulumCart(this.getContentPane());
                break;
            }
            case 14: {
                this.sim = new DangleStick(this.getContentPane());
                break;
            }
            case 15: {
                this.sim = new Thruster5(this.getContentPane(), this.gameMode);
                break;
            }
            case 16: {
                this.sim = new ContactSim(this.getContentPane());
                break;
            }
            case 17: {
                this.sim = new Roller1(this.getContentPane(), 0);
                break;
            }
            case 18: {
                this.sim = new Roller2(this.getContentPane(), 0);
                break;
            }
            case 19: {
                this.sim = new Roller3(this.getContentPane(), 0);
                break;
            }
            case 20: {
                this.sim = new Roller4(this.getContentPane());
                break;
            }
            case 21: {
                this.sim = new Roller5(this.getContentPane(), 0);
                break;
            }
            case 22: {
                this.sim = new String1(this.getContentPane());
                break;
            }
            case 23: {
                this.sim = new MoveableDoublePendulum(this.getContentPane());
                break;
            }
            case 24: {
                this.sim = new Pendulum2(this.getContentPane());
                break;
            }
            default: {
                this.sim = null;
            }
        }
        this.currentSimMenuItem = simIndex;
        Utility.println("created simulation " + this.sim);
        Utility.println(" with rootpane.isDoubleBuffered=" + this.getRootPane().isDoubleBuffered());
        this.sim.setupControls();
        this.sim.setupGraph();
        this.getContentPane().setLayout(this.sim.makeLayoutManager());
        this.getContentPane().invalidate();
        this.getContentPane().validate();
        this.getContentPane().repaint();
        this.start();
        if (this.simMenu != null && this.simMenu.getSelectedIndex() != simIndex) {
            this.simMenu.setSelectedIndex(simIndex);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        int i = this.simMenu.getSelectedIndex();
        if (i != this.currentSimMenuItem) {
            this.startSim(this.simMenu.getSelectedIndex());
        }
    }

    public void start() {
        Utility.println("Lab.start ");
        if (this.timer == null && this.sim != null) {
            this.timer = new SimThread((Runnable)this.sim, 10L);
            this.timer.start();
        }
    }

    public void stop() {
        Utility.println("Lab.stop ");
        if (this.timer != null) {
            this.timer.interrupt();
            this.timer = null;
        }
    }

    public void setVar(int n, String value) {
        this.sim.setVariable(n, new Double(value));
    }

    public void setGraphXVar(int n) {
        Graph g = this.sim.getGraph();
        g.setXVar(n);
    }

    public void setGraphYVar(int n) {
        Graph g = this.sim.getGraph();
        g.setYVar(n);
    }

    public void setParameter(String name, String value) {
        this.sim.setParameter(name, new Double(value));
    }

    public void graphRepaint() {
        this.sim.getGraph().reset();
    }

    public void setSize(int width, int height) {
        Utility.println("Lab.setSize " + width + " " + height);
        super.setSize(width, height);
    }

    public void setSize(Dimension d) {
        Utility.println("Lab.setSize " + d);
        super.setSize(d);
    }
}

