/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CGradient;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CRect;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CText;
import com.myphysicslab.simlab.CollidingSim;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.MySlider;
import com.myphysicslab.simlab.ObjectListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;

public class Molecule3
extends CollidingSim
implements ActionListener,
ObjectListener {
    private int nm = 2;
    private CMass[] m;
    private CSpring[] s;
    private CText tx;
    private CRect m_Walls;
    private CGradient gradient;
    private int gradientMass = 0;
    private boolean showGradient = false;
    private double m_Elasticity = 0.8;
    private double m_Damping = 1.0;
    private double m_Gravity = 0.0;
    private double m_Left;
    private double m_Right;
    private double m_Top;
    private double m_Bottom;
    private static final int TOP_WALL = 1;
    private static final int BOTTOM_WALL = 2;
    private static final int LEFT_WALL = 3;
    private static final int RIGHT_WALL = 4;
    private Vector collisions = new Vector(10);
    private static final String MASS_SPECIAL = "red mass";
    private static final String MASS = "other mass";
    private static final String ELASTICITY = "elasticity";
    private static final String GRAVITY = "gravity";
    private static final String DAMPING = "damping";
    private static final String LENGTH = "spring rest length";
    private static final String STIFFNESS = "spring stiffness";
    private static final String LENGTH_SPECIAL = "red spring length";
    private static final String STIFF_SPECIAL = "red spring stiffness";
    private static final String GRADIENT = "show gradient";
    private String[] params = new String[]{"red mass", "other mass", "elasticity", "gravity", "damping", "spring stiffness", "spring rest length", "red spring stiffness", "red spring length"};
    private int[][] msm;
    private int[][] msm2 = new int[][]{{0, 1}};
    private int[][] msm3 = new int[][]{{0, 1}, {1, 2}, {2, 0}};
    private int[][] msm4 = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {1, 3}, {0, 2}};
    private int[][] msm5 = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 4}, {4, 0}, {4, 2}, {4, 1}, {0, 3}, {1, 3}, {0, 2}};
    private int[][] msm6 = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 0}, {0, 2}, {2, 4}, {4, 0}, {1, 3}, {3, 5}, {5, 1}, {0, 3}, {1, 4}, {2, 5}};
    private int[] sg;
    private int[] sg2 = new int[0];
    private int[] sg3 = new int[]{0};
    private int[] sg4 = new int[]{0, 3, 5};
    private int[] sg5 = new int[]{0, 4, 7, 9};
    private int[] sg6 = new int[]{12, 13, 14};
    private int[] nsg;
    private JButton button_stop;

    public Molecule3(Container container, int nm) {
        super(container, nm * 4);
        int i;
        if (nm == 3) {
            this.gradientMass = 2;
        }
        this.cvs.expandMap();
        this.setCoordMap(new CoordMap(-1, -6.0, 6.0, -6.0, 6.0, 0, 0));
        this.gradient = new CGradient();
        if (this.showGradient) {
            this.cvs.addElement(this.gradient);
        }
        this.tx = new CText(3.0, 3.0, "energy ");
        this.cvs.addElement(this.tx);
        double w = 0.5;
        Color[] cm = new Color[]{Color.red, Color.blue, Color.magenta, Color.orange, Color.gray, Color.green};
        DoubleRect box = this.cvs.getSimBounds();
        this.m_Walls = new CRect(box);
        this.m_Left = box.getXMin() + w / 2.0;
        this.m_Right = box.getXMax() - w / 2.0;
        this.m_Bottom = box.getYMin() + w / 2.0;
        this.m_Top = box.getYMax() - w / 2.0;
        this.cvs.addElement(this.m_Walls);
        this.cvs.setObjectListener(this);
        switch (nm) {
            case 2: {
                this.msm = this.msm2;
                this.sg = this.sg2;
                break;
            }
            case 3: {
                this.msm = this.msm3;
                this.sg = this.sg3;
                break;
            }
            case 4: {
                this.msm = this.msm4;
                this.sg = this.sg4;
                break;
            }
            case 5: {
                this.msm = this.msm5;
                this.sg = this.sg5;
                break;
            }
            case 6: {
                this.msm = this.msm6;
                this.sg = this.sg6;
            }
        }
        this.nsg = new int[this.msm.length - this.sg.length];
        int j = 0;
        int k = 0;
        if (this.sg.length > 0) {
            for (i = 0; i < this.msm.length; ++i) {
                if (j < this.sg.length && i == this.sg[j]) {
                    ++j;
                    continue;
                }
                this.nsg[k++] = i;
            }
        }
        this.m = new CMass[nm];
        for (i = 0; i < this.m.length; ++i) {
            this.m[i] = new CMass(0.0, 0.0, w, w, 5);
            this.m[i].m_Mass = 0.5;
            this.m[i].m_Color = cm[i];
            this.m[i].m_Damping = 0.1;
            this.cvs.addElement(this.m[i]);
        }
        this.s = new CSpring[this.msm.length];
        for (i = 0; i < this.s.length; ++i) {
            this.s[i] = new CSpring(0.0, 0.0, 3.0, 0.3);
            this.s[i].m_SpringConst = 6.0;
            this.s[i].m_Color = Color.green.darker();
            this.s[i].m_Color2 = Color.green;
            this.cvs.addElement(this.s[i]);
        }
        for (i = 0; i < this.sg.length; ++i) {
            this.s[this.sg[i]].m_Color = Color.red.darker();
            this.s[this.sg[i]].m_Color2 = Color.red;
        }
        this.stop();
        this.modifyObjects();
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        this.addObserverControl(new DoubleField(this, MASS_SPECIAL, 2));
        this.addObserverControl(new DoubleField(this, MASS, 2));
        this.addObserverControl(new DoubleField(this, ELASTICITY, 2));
        this.addObserverControl(new DoubleField(this, GRAVITY, 2));
        this.addObserverControl(new DoubleField(this, DAMPING, 2));
        this.addObserverControl(new DoubleField(this, STIFFNESS, 2));
        this.addObserverControl(new DoubleField(this, LENGTH, 2));
        this.addObserverControl(new MySlider(this, STIFF_SPECIAL, 0.0, 12.0, 120, 1));
        this.addObserverControl(new MySlider(this, LENGTH_SPECIAL, 0.0, 12.0, 120, 1));
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 1);
        }
        this.showGraph(false);
    }

    public String getVariableName(int i) {
        int j = i % 4;
        int obj = i / 4;
        switch (j) {
            case 0: {
                return "x position " + obj;
            }
            case 1: {
                return "y position " + obj;
            }
            case 2: {
                return "x velocity " + obj;
            }
            case 3: {
                return "y velocity " + obj;
            }
        }
        return "";
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS_SPECIAL)) {
            this.m[0].m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS)) {
            for (int i = 1; i < this.m.length; ++i) {
                this.m[i].m_Mass = value;
            }
            return true;
        }
        if (name.equalsIgnoreCase(ELASTICITY)) {
            this.m_Elasticity = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.m_Gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.m_Damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            for (int i = 0; i < this.nsg.length; ++i) {
                this.s[this.nsg[i]].m_SpringConst = value;
            }
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            for (int i = 0; i < this.nsg.length; ++i) {
                this.s[this.nsg[i]].m_RestLength = value;
            }
            return true;
        }
        if (name.equalsIgnoreCase(STIFF_SPECIAL)) {
            for (int i = 0; i < this.sg.length; ++i) {
                this.s[this.sg[i]].m_SpringConst = value;
            }
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH_SPECIAL)) {
            for (int i = 0; i < this.sg.length; ++i) {
                this.s[this.sg[i]].m_RestLength = value;
            }
            return true;
        }
        if (name.equalsIgnoreCase(GRADIENT)) {
            boolean wantGradient;
            boolean bl = wantGradient = value != 0.0;
            if (wantGradient && !this.showGradient) {
                this.cvs.prependElement(this.gradient);
                this.showGradient = true;
            } else if (!wantGradient && this.showGradient) {
                this.cvs.removeElement(this.gradient);
                this.showGradient = false;
            }
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS_SPECIAL)) {
            return this.m[0].m_Mass;
        }
        if (name.equalsIgnoreCase(MASS)) {
            return this.m[1].m_Mass;
        }
        if (name.equalsIgnoreCase(ELASTICITY)) {
            return this.m_Elasticity;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.m_Gravity;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.m_Damping;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.s[this.nsg[0]].m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.s[this.nsg[0]].m_RestLength;
        }
        if (name.equalsIgnoreCase(STIFF_SPECIAL)) {
            return this.sg.length > 0 ? this.s[this.sg[0]].m_SpringConst : 0.0;
        }
        if (name.equalsIgnoreCase(LENGTH_SPECIAL)) {
            return this.sg.length > 0 ? this.s[this.sg[0]].m_RestLength : 0.0;
        }
        if (name.equalsIgnoreCase(GRADIENT)) {
            return this.showGradient ? 1.0 : 0.0;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void objectChanged(Object o) {
        if (o == this.cvs) {
            DoubleRect box = this.cvs.getSimBounds();
            this.m_Walls.setBounds(box);
            double w = this.m[0].m_Width;
            this.m_Left = box.getXMin() + w / 2.0;
            this.m_Right = box.getXMax() - w / 2.0;
            this.m_Bottom = box.getYMin() + w / 2.0;
            this.m_Top = box.getYMax() - w / 2.0;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.stop();
        }
    }

    private void stop() {
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i] = 0.0;
        }
        double r = 1.0;
        for (int i = 0; i < this.m.length; ++i) {
            double rnd = 1.0 + 0.1 * Math.random();
            this.vars[0 + i * 4] = r * Math.cos(rnd * (double)i * 2.0 * Math.PI / (double)this.m.length);
            this.vars[1 + i * 4] = r * Math.sin(rnd * (double)i * 2.0 * Math.PI / (double)this.m.length);
        }
    }

    public void modifyObjects() {
        int i;
        double w = this.m[0].m_Width / 2.0;
        for (i = 0; i < this.m.length; ++i) {
            this.m[i].setX1(this.vars[4 * i] - w);
            this.m[i].setY1(this.vars[1 + 4 * i] - w);
        }
        for (i = 0; i < this.msm.length; ++i) {
            CSpring spr = this.s[i];
            CMass m1 = this.m[this.msm[i][0]];
            spr.setX1(m1.m_X1 + w);
            spr.setY1(m1.m_Y1 + w);
            CMass m2 = this.m[this.msm[i][1]];
            spr.setX2(m2.m_X1 + w);
            spr.setY2(m2.m_Y1 + w);
        }
        this.tx.setNumber(this.getEnergy());
        if (this.showGradient) {
            this.gatherMatrix();
        }
    }

    private void gatherMatrix() {
        double y;
        double x;
        double[][] mat = this.gradient.getMatrix();
        CMass m1 = this.m[this.gradientMass];
        double saveX = m1.m_X1;
        double saveY = m1.m_Y1;
        double w = m1.m_Width / 2.0;
        this.gradient.setCenterX(m1.m_X1 + w);
        this.gradient.setCenterY(m1.m_Y1 + w);
        int R = mat.length;
        if (R == 0) {
            return;
        }
        int C = mat[0].length;
        if (C == 0) {
            return;
        }
        double gradW = this.gradient.getWidth();
        double gradH = this.gradient.getHeight();
        double incX = gradW / (double)C;
        double incY = gradH / (double)R;
        double left = m1.m_X1 + w - gradW / 2.0;
        double bottom = m1.m_Y1 + w - gradH / 2.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < R; ++i) {
            for (int j = 0; j < C; ++j) {
                double e;
                x = left + incX * (double)i;
                y = bottom + incY * (double)j;
                for (int l = 0; l < this.msm.length; ++l) {
                    if (this.msm[l][0] == this.gradientMass) {
                        this.s[l].setX1(x);
                        this.s[l].setY1(y);
                    }
                    if (this.msm[l][1] != this.gradientMass) continue;
                    this.s[l].setX2(x);
                    this.s[l].setY2(y);
                }
                m1.m_X1 = x - w;
                m1.m_Y1 = y - w;
                mat[i][j] = e = this.getEnergy();
                if (e < min) {
                    min = e;
                }
                if (!(e > max)) continue;
                max = e;
            }
        }
        double range = max - min;
        for (int i = 0; i < R; ++i) {
            for (int j = 0; j < C; ++j) {
                mat[i][j] = Math.pow((mat[i][j] - min) / range, 0.33333333);
            }
        }
        x = saveX + w;
        y = saveY + w;
        for (int l = 0; l < this.msm.length; ++l) {
            if (this.msm[l][0] == this.gradientMass) {
                this.s[l].setX1(x);
                this.s[l].setY1(y);
            }
            if (this.msm[l][1] != this.gradientMass) continue;
            this.s[l].setX2(x);
            this.s[l].setY2(y);
        }
        m1.m_X1 = saveX;
        m1.m_Y1 = saveY;
    }

    private double getEnergy() {
        double ke = 0.0;
        for (int i = 0; i < this.m.length; ++i) {
            double vx = this.vars[2 + i * 4];
            double vy = this.vars[3 + i * 4];
            ke += 0.5 * this.m[i].m_Mass * (vx * vx + vy * vy);
        }
        double se = 0.0;
        for (int i = 0; i < this.s.length; ++i) {
            double dx = this.s[i].m_X1 - this.s[i].m_X2;
            double dy = this.s[i].m_Y1 - this.s[i].m_Y2;
            double len = Math.sqrt(dx * dx + dy * dy);
            double x = len - this.s[i].m_RestLength;
            se += 0.5 * this.s[i].m_SpringConst * x * x;
        }
        double ge = 0.0;
        for (int i = 0; i < this.m.length; ++i) {
            ge += this.m[i].m_Mass * this.m_Gravity * (this.m[i].m_Y1 + this.m[i].m_Width / 2.0 - this.m_Bottom);
        }
        return ke + se + ge;
    }

    public void startDrag(Dragable e) {
        for (int i = 0; i < this.m.length; ++i) {
            if (e != this.m[i]) continue;
            for (int j = 0; j < 4; ++j) {
                this.calc[j + 4 * i] = false;
            }
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        double w = this.m[0].m_Width / 2.0;
        x += w;
        y += w;
        if (x < this.m_Left) {
            x = this.m_Left + 1.0E-4;
        }
        if (x > this.m_Right) {
            x = this.m_Right - 1.0E-4;
        }
        if (y < this.m_Bottom) {
            y = this.m_Bottom + 1.0E-4;
        }
        if (y > this.m_Top) {
            y = this.m_Top - 1.0E-4;
        }
        for (int i = 0; i < this.m.length; ++i) {
            if (e != this.m[i]) continue;
            this.vars[4 * i] = x;
            this.vars[1 + 4 * i] = y;
            this.vars[2 + 4 * i] = 0.0;
            this.vars[3 + 4 * i] = 0.0;
        }
    }

    private void addCollision(int obj1, int obj2) {
        this.collisions.addElement(new int[]{obj1, obj2});
    }

    public Vector findAllCollisions() {
        this.collisions.removeAllElements();
        for (int j = 0; j < this.m.length; ++j) {
            if (this.vars[4 * j] < this.m_Left) {
                this.addCollision(3, j);
            }
            if (this.vars[4 * j] > this.m_Right) {
                this.addCollision(4, j);
            }
            if (this.vars[1 + 4 * j] < this.m_Bottom) {
                this.addCollision(2, j);
            }
            if (!(this.vars[1 + 4 * j] > this.m_Top)) continue;
            this.addCollision(1, j);
        }
        return this.collisions.size() > 0 ? this.collisions : null;
    }

    public void handleCollisions(Vector collisions) {
        block4: for (int i = 0; i < collisions.size(); ++i) {
            int[] objs = (int[])collisions.elementAt(i);
            int idx = 4 * objs[1];
            switch (objs[0]) {
                case 3: 
                case 4: {
                    this.vars[2 + idx] = -this.m_Elasticity * this.vars[2 + idx];
                    continue block4;
                }
                case 1: 
                case 2: {
                    this.vars[3 + idx] = -this.m_Elasticity * this.vars[3 + idx];
                }
            }
        }
    }

    public void evaluate(double[] x, double[] change) {
        double DIST_TOL = 0.02;
        double timeStep = 0.03;
        for (int i = 0; i < this.vars.length; ++i) {
            double f;
            double sc;
            CSpring spr;
            double len;
            double yy;
            double xx;
            int obj2;
            int k;
            int j = i % 4;
            int obj = i / 4;
            if (j == 0 || j == 1) {
                change[i] = x[i + 2];
                continue;
            }
            double r = 0.0;
            double mass = this.m[obj].m_Mass;
            for (k = 0; k < this.msm.length; ++k) {
                if (this.msm[k][0] != obj) continue;
                obj2 = this.msm[k][1];
                xx = x[4 * obj2] - x[4 * obj];
                yy = x[1 + 4 * obj2] - x[1 + 4 * obj];
                len = Math.sqrt(xx * xx + yy * yy);
                spr = this.s[k];
                sc = spr.m_SpringConst;
                f = sc / mass * (len - spr.m_RestLength) / len;
                r += j == 2 ? f * xx : -this.m_Gravity + f * yy;
            }
            for (k = 0; k < this.msm.length; ++k) {
                if (this.msm[k][1] != obj) continue;
                obj2 = this.msm[k][0];
                xx = x[4 * obj2] - x[4 * obj];
                yy = x[1 + 4 * obj2] - x[1 + 4 * obj];
                len = Math.sqrt(xx * xx + yy * yy);
                spr = this.s[k];
                sc = spr.m_SpringConst;
                f = sc / mass * (len - spr.m_RestLength) / len;
                r += j == 2 ? f * xx : -this.m_Gravity + f * yy;
            }
            if (this.m_Damping != 0.0) {
                r -= this.m_Damping / mass * x[i];
            }
            if (j == 3) {
                if (r < 0.0 && Math.abs(x[4 * obj + 1] - this.m_Bottom) < DIST_TOL && Math.abs(x[4 * obj + 3]) < -r * timeStep / (2.0 * mass)) {
                    x[4 * obj + 3] = 0.0;
                    r = 0.0;
                    x[4 * obj + 1] = this.m_Bottom;
                } else if (r > 0.0 && Math.abs(x[4 * obj + 1] - this.m_Top) < DIST_TOL && Math.abs(x[4 * obj + 3]) < r * timeStep / (2.0 * mass)) {
                    x[4 * obj + 3] = 0.0;
                    r = 0.0;
                    x[4 * obj + 1] = this.m_Top;
                }
            } else if (j == 2) {
                if (r < 0.0 && Math.abs(x[4 * obj] - this.m_Left) < DIST_TOL && Math.abs(x[4 * obj + 2]) < -r * timeStep / (2.0 * mass)) {
                    x[4 * obj + 2] = 0.0;
                    r = 0.0;
                    x[4 * obj] = this.m_Left;
                } else if (r > 0.0 && Math.abs(x[4 * obj] - this.m_Right) < DIST_TOL && Math.abs(x[4 * obj + 2]) < r * timeStep / (2.0 * mass)) {
                    x[4 * obj + 2] = 0.0;
                    r = 0.0;
                    x[4 * obj] = this.m_Right;
                }
            }
            change[i] = r;
        }
    }
}

