/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CArc;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;

public class PendulumSim
extends Simulation {
    private CMass m_Mass;
    private CSpring m_Spring;
    private CArc m_Drive;
    private double driveAmplitude = 1.15;
    private double m_DriveFrequency = 0.6666666666666666;
    private double m_Gravity = 1.0;
    private static final String MASS = "mass";
    private static final String DAMPING = "damping";
    private static final String LENGTH = "length";
    private static final String AMPLITUDE = "drive amplitude";
    private static final String FREQUENCY = "drive frequency";
    private static final String GRAVITY = "gravity";
    private static final String RADIUS = "radius";
    private String[] params = new String[]{"mass", "damping", "length", "drive amplitude", "drive frequency", "gravity", "radius"};

    public String toString() {
        return "Pendulum simulation";
    }

    public PendulumSim(Container container) {
        super(container, 3);
        this.var_names = new String[]{"angle", "angular velocity", "time", "angular accel"};
        this.setCoordMap(new CoordMap(1, -1.5, 1.5, -1.5, 1.5, 0, 0));
        this.m_Drive = new CArc(0.0, 0.0, 0.5 * this.driveAmplitude, -90.0, 0.0);
        this.cvs.addElement(this.m_Drive);
        double len = 1.0;
        this.m_Spring = new CSpring(0.0, 0.0, len, 0.4);
        this.m_Spring.m_DrawMode = 4;
        this.cvs.addElement(this.m_Spring);
        double w = 0.3;
        this.m_Mass = new CMass(-w / 2.0 + Math.sin(0.0) * len, -w / 2.0 + Math.cos(0.0) * len, w, w, 2);
        this.m_Spring.setX2(this.m_Mass.m_X2 + w / 2.0);
        this.m_Spring.setY2(this.m_Mass.m_Y2 + w / 2.0);
        this.m_Mass.m_Mass = 1.0;
        this.m_Mass.m_Damping = 0.5;
        this.cvs.addElement(this.m_Mass);
        this.vars[0] = 0.7853981633974483;
        this.vars[1] = 0.0;
        this.vars[2] = 0.0;
        this.modifyObjects();
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setDrawMode(0);
            this.graph.setZVar(3);
        }
    }

    public void setupControls() {
        super.setupControls();
        this.addObserverControl(new DoubleField(this, MASS, 3));
        this.addObserverControl(new DoubleField(this, DAMPING, 3));
        this.addObserverControl(new DoubleField(this, LENGTH, 3));
        this.addObserverControl(new DoubleField(this, AMPLITUDE, 3));
        this.addObserverControl(new DoubleField(this, FREQUENCY, 7));
        this.addObserverControl(new DoubleField(this, GRAVITY, 3));
        this.showControls(true);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS)) {
            this.m_Mass.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.m_Mass.m_Damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            this.m_Spring.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(AMPLITUDE)) {
            this.driveAmplitude = value;
            this.m_Drive.m_Radius = 0.5 * value;
            return true;
        }
        if (name.equalsIgnoreCase(FREQUENCY)) {
            this.m_DriveFrequency = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.m_Gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(RADIUS)) {
            this.m_Mass.setHeight(2.0 * value);
            this.m_Mass.setWidth(2.0 * value);
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS)) {
            return this.m_Mass.m_Mass;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.m_Mass.m_Damping;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.m_Spring.m_RestLength;
        }
        if (name.equalsIgnoreCase(AMPLITUDE)) {
            return this.driveAmplitude;
        }
        if (name.equalsIgnoreCase(FREQUENCY)) {
            return this.m_DriveFrequency;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.m_Gravity;
        }
        if (name.equalsIgnoreCase(RADIUS)) {
            return this.m_Mass.getWidth() * 2.0;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void modifyObjects() {
        if (this.vars[0] > Math.PI) {
            this.vars[0] = this.vars[0] - Math.PI * 2 * Math.floor(this.vars[0] / Math.PI);
        } else if (this.vars[0] < -Math.PI) {
            this.vars[0] = this.vars[0] - Math.PI * 2 * Math.ceil(this.vars[0] / Math.PI);
        }
        double len = this.m_Spring.m_RestLength;
        double w = this.m_Mass.m_Width / 2.0;
        this.m_Mass.setX1(len * Math.sin(this.vars[0]) - w);
        this.m_Mass.setY1(len * Math.cos(this.vars[0]) - w);
        this.m_Spring.setX2(this.m_Mass.m_X1 + w);
        this.m_Spring.setY2(this.m_Mass.m_Y1 + w);
        double t = this.m_DriveFrequency * this.vars[2];
        t = 180.0 * t / Math.PI;
        t -= 360.0 * Math.floor(t / 360.0);
        t = t > 0.0 && t <= 180.0 ? 90.0 - t : (t -= 270.0);
        this.m_Drive.m_Angle = t;
    }

    public int numVariables() {
        return this.var_names.length;
    }

    public double getVariable(int i) {
        if (i <= 2) {
            return this.vars[i];
        }
        double[] rate = new double[this.vars.length];
        this.evaluate(this.vars, rate);
        return rate[1];
    }

    public void startDrag(Dragable e) {
        if (e == this.m_Mass) {
            this.calc[0] = false;
            this.calc[1] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.m_Mass) {
            double th;
            double w = this.m_Mass.m_Width / 2.0;
            this.vars[0] = th = Math.atan2(x + w, y + w);
            this.vars[1] = 0.0;
        }
    }

    public void evaluate(double[] x, double[] change) {
        change[0] = x[1];
        double l = this.m_Spring.m_RestLength;
        double dd = -(this.m_Gravity / l) * Math.sin(x[0]);
        double mlsq = this.m_Mass.m_Mass * l * l;
        dd += -(this.m_Mass.m_Damping / mlsq) * x[1];
        change[1] = dd += this.driveAmplitude / mlsq * Math.cos(this.m_DriveFrequency * x[2]);
        change[2] = 1.0;
    }
}

