/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CBitmap;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CPath;
import com.myphysicslab.simlab.CPoint;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CText;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.MyCheckbox;
import com.myphysicslab.simlab.MyChoice;
import com.myphysicslab.simlab.ObjectListener;
import com.myphysicslab.simlab.PathName;
import com.myphysicslab.simlab.Simulation;
import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;

public class Roller3
extends Simulation
implements ObjectListener {
    private CMass m_Mass1;
    private CMass m_Mass2;
    private CSpring m_Spring;
    private CBitmap m_TrackBM;
    private double gravity = 9.8;
    private CPath m_Path;
    private CPoint m_Point1 = new CPoint(0);
    private CPoint m_Point2 = new CPoint(1);
    private int m_Path_Num = 0;
    protected CText m_Text = null;
    protected boolean showEnergy = false;
    protected static final String RED_MASS = "red mass";
    protected static final String BLUE_MASS = "blue mass";
    protected static final String DAMPING = "damping";
    protected static final String GRAVITY = "gravity";
    protected static final String PATH = "path";
    protected static final String SHOW_ENERGY = "show energy";
    protected static final String STIFF = "spring stiffness";
    protected static final String LENGTH = "spring restlength";

    public Roller3(Container app, int the_path) {
        super(app, 4);
        double damp;
        this.setCoordMap(new CoordMap(-1, 0.0, 1.0, 0.0, 1.0, 0, 0));
        this.var_names = new String[]{"position red", "velocity red", "position blue", "velocity blue"};
        this.m_Text = new CText(0.0, 0.0, "energy ");
        if (this.showEnergy) {
            this.cvs.addElement(this.m_Text);
        }
        double w = 0.3;
        this.m_Mass1 = new CMass(1.0, 1.0, w, w, 5);
        this.m_Mass1.m_Mass = 0.5;
        this.m_Mass1.m_Damping = damp = 0.001;
        this.cvs.addElement(this.m_Mass1);
        this.m_Spring = new CSpring(0.0, 0.0, 1.0, 0.5);
        this.m_Spring.m_SpringConst = 5.0;
        this.cvs.addElement(this.m_Spring);
        this.m_Mass2 = new CMass(0.0, 0.0, w, w, 5);
        this.m_Mass2.m_Mass = 0.5;
        this.m_Mass2.m_Damping = damp;
        this.m_Mass2.m_Color = Color.blue;
        this.cvs.addElement(this.m_Mass2);
        this.set_path(the_path);
        this.modifyObjects();
        this.cvs.setObjectListener(this);
    }

    public void setupControls() {
        super.setupControls();
        this.addObserverControl(new MyChoice(this, PATH, this.m_Path_Num, 0.0, PathName.getPathNames()));
        this.addObserverControl(new DoubleField(this, RED_MASS, 2));
        this.addObserverControl(new DoubleField(this, BLUE_MASS, 2));
        this.addObserverControl(new DoubleField(this, DAMPING, 3));
        this.addObserverControl(new DoubleField(this, GRAVITY, 2));
        this.addObserverControl(new DoubleField(this, LENGTH, 2));
        this.addObserverControl(new DoubleField(this, STIFF, 2));
        this.addObserverControl(new MyCheckbox(this, SHOW_ENERGY));
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 2);
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(RED_MASS)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(BLUE_MASS)) {
            this.m_Mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.m_Mass1.m_Damping = this.m_Mass2.m_Damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            this.m_Spring.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFF)) {
            this.m_Spring.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(PATH)) {
            this.set_path((int)value);
            this.modifyObjects();
            return true;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            boolean wantEnergy;
            boolean bl = wantEnergy = value != 0.0;
            if (wantEnergy && !this.showEnergy) {
                this.cvs.addElement(this.m_Text);
            } else if (!wantEnergy && this.showEnergy) {
                this.cvs.removeElement(this.m_Text);
            }
            this.showEnergy = wantEnergy;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(RED_MASS)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(BLUE_MASS)) {
            return this.m_Mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.m_Mass1.m_Damping;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.m_Spring.m_RestLength;
        }
        if (name.equalsIgnoreCase(STIFF)) {
            return this.m_Spring.m_SpringConst;
        }
        if (name.equalsIgnoreCase(PATH)) {
            return this.m_Path_Num;
        }
        if (name.equalsIgnoreCase(SHOW_ENERGY)) {
            return this.showEnergy ? 1.0 : 0.0;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{RED_MASS, BLUE_MASS, DAMPING, GRAVITY, PATH, SHOW_ENERGY, STIFF, LENGTH};
        return params;
    }

    protected void resetTrackBitmap() {
        if (this.m_TrackBM != null) {
            this.cvs.removeElement(this.m_TrackBM);
        }
        this.m_TrackBM = new CBitmap(this.container, this.m_Path);
        Rectangle r = this.cvs.getConvertMap().getScreenRect();
        this.m_TrackBM.setGraphicsTopLeft(r.x, r.y);
        this.cvs.prependElement(this.m_TrackBM);
    }

    protected void set_path(int the_path) {
        PathName[] pNames = PathName.getPathNames();
        if (the_path >= 0 && the_path < pNames.length) {
            this.m_Path_Num = the_path;
            this.m_Path = CPath.makePath(pNames[the_path]);
            this.cvs.getCoordMap().setRange(this.m_Path.left, this.m_Path.right, this.m_Path.bottom, this.m_Path.top);
            this.resetTrackBitmap();
            if (this.graph != null) {
                this.graph.reset();
            }
        } else {
            throw new IllegalArgumentException("no such path number " + the_path);
        }
        DoubleRect r = this.cvs.getCoordMap().getSimBounds();
        this.m_Text.setX1(r.getXMin() + r.getWidth() * 0.1);
        this.m_Text.setY1(r.getYMax() - r.getHeight() * 0.1);
        this.vars[0] = this.m_Path.map_x_y_to_p(r.getXMin() + r.getWidth() * 0.1, r.getYMax() - r.getHeight() * 0.1);
        this.vars[1] = 0.0;
        this.vars[2] = this.m_Path.map_x_y_to_p(r.getXMin() + r.getWidth() * 0.2, r.getYMax() - r.getHeight() * 0.3);
        this.vars[3] = 0.0;
    }

    public void objectChanged(Object o) {
        if (this.cvs == o) {
            this.resetTrackBitmap();
        }
    }

    public void modifyObjects() {
        this.vars[0] = this.m_Path.modp(this.vars[0]);
        this.m_Point1.p = this.vars[0];
        this.m_Path.map_p_to_slope(this.m_Point1);
        this.m_Mass1.setCenterX(this.m_Point1.x);
        this.m_Mass1.setCenterY(this.m_Point1.y);
        this.m_Spring.setX2(this.m_Point1.x);
        this.m_Spring.setY2(this.m_Point1.y);
        this.vars[2] = this.m_Path.modp(this.vars[2]);
        this.m_Point2.p = this.vars[2];
        this.m_Path.map_p_to_slope(this.m_Point2);
        this.m_Mass2.setCenterX(this.m_Point2.x);
        this.m_Mass2.setCenterY(this.m_Point2.y);
        this.m_Spring.setX1(this.m_Point2.x);
        this.m_Spring.setY1(this.m_Point2.y);
        this.m_Text.setNumber(this.getEnergy());
    }

    protected double getEnergy() {
        double e = 0.5 * this.m_Mass1.m_Mass * this.vars[1] * this.vars[1];
        e += 0.5 * this.m_Mass2.m_Mass * this.vars[3] * this.vars[3];
        e += this.m_Mass1.m_Mass * this.gravity * this.m_Mass1.getCenterY();
        e += this.m_Mass2.m_Mass * this.gravity * this.m_Mass2.getCenterY();
        return e += this.m_Spring.getEnergy();
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.m_Mass1) {
            double w = this.m_Mass1.m_Width / 2.0;
            this.vars[0] = this.m_Path.map_x_y_to_p(x + w, y + w);
            this.vars[1] = 0.0;
            this.modifyObjects();
        } else if (e == this.m_Mass2) {
            double w = this.m_Mass2.m_Width / 2.0;
            this.vars[2] = this.m_Path.map_x_y_to_p(x + w, y + w);
            this.vars[3] = 0.0;
            this.modifyObjects();
        }
    }

    public void startDrag(Dragable e) {
        if (e == this.m_Mass1) {
            this.calc[0] = false;
            this.calc[1] = false;
        } else if (e == this.m_Mass2) {
            this.calc[2] = false;
            this.calc[3] = false;
        }
    }

    public void evaluate(double[] x, double[] change) {
        change[0] = x[1];
        this.m_Point1.p = x[0];
        this.m_Path.map_p_to_slope(this.m_Point1);
        double k = this.m_Point1.slope;
        double sinTheta = Double.isInfinite(k) ? 1.0 : k / Math.sqrt(1.0 + k * k);
        change[1] = -this.gravity * (double)this.m_Point1.direction * sinTheta;
        change[1] = change[1] - this.m_Mass1.m_Damping * x[1] / this.m_Mass1.m_Mass;
        this.m_Point2.p = x[2];
        this.m_Path.map_p_to_slope(this.m_Point2);
        double sx = this.m_Point2.x - this.m_Point1.x;
        double sy = this.m_Point2.y - this.m_Point1.y;
        double slen = Math.sqrt(sx * sx + sy * sy);
        double cosTheta = Double.isInfinite(k) ? (double)this.m_Point1.direction * sy / slen : (double)this.m_Point1.direction * (sx + k * sy) / (slen * Math.sqrt(1.0 + k * k));
        if (cosTheta > 1.0 || cosTheta < -1.0) {
            System.out.println("cosTheta out of range in evaluate");
        }
        double stretch = slen - this.m_Spring.m_RestLength;
        change[1] = change[1] + cosTheta * stretch * this.m_Spring.m_SpringConst / this.m_Mass1.m_Mass;
        change[2] = x[3];
        k = this.m_Point2.slope;
        sinTheta = Double.isInfinite(k) ? 1.0 : k / Math.sqrt(1.0 + k * k);
        change[3] = -this.gravity * (double)this.m_Point2.direction * sinTheta;
        change[3] = change[3] - this.m_Mass2.m_Damping * x[3] / this.m_Mass2.m_Mass;
        sx = -sx;
        sy = -sy;
        cosTheta = Double.isInfinite(k) ? (double)this.m_Point2.direction * sy / slen : (double)this.m_Point2.direction * (sx + k * sy) / (slen * Math.sqrt(1.0 + k * k));
        if (cosTheta > 1.0 || cosTheta < -1.0) {
            System.out.println("cosTheta out of range in evaluate");
        }
        change[3] = change[3] + cosTheta * stretch * this.m_Spring.m_SpringConst / this.m_Mass2.m_Mass;
    }
}

