/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Roller2;
import java.awt.Color;
import java.awt.Container;
import java.util.Vector;

public class Roller4
extends Roller2 {
    protected static final double TRACK = 0.0;
    protected static final double FREE = 1.0;
    protected static final int MODE = 4;
    private Vector collisions = new Vector(10);
    private double stickiness = 0.1;
    protected static final String ELASTICITY = "elasticity";
    protected static final String STICKINESS = "stickiness";

    public Roller4(Container app) {
        super(app, 0);
    }

    public void setupControls() {
        super.setupControls();
        this.removeObserverControl(this.pathControl);
        this.addObserverControl(new DoubleField(this, ELASTICITY, 3));
        this.addObserverControl(new DoubleField(this, STICKINESS, 3));
    }

    public void setupGraph() {
    }

    protected void createElements() {
        super.createElements();
        double p = this.vars[0];
        this.vars = new double[5];
        this.vars[0] = p;
        this.vars[3] = 0.0;
        this.vars[2] = 0.0;
        this.vars[4] = 0.0;
        this.calc = new boolean[5];
        for (int i = 0; i < this.calc.length; ++i) {
            this.calc[i] = true;
        }
        this.calc[4] = false;
        this.m_Point.radius_flag = true;
        double x = -4.0;
        double y = 4.0;
        this.m_TopMass.setCenterX(x);
        this.m_TopMass.setCenterY(y);
        this.m_Spring.setX1(x);
        this.m_Spring.setY1(y);
        this.m_Spring.m_SpringConst = 0.0;
        this.m_Mass1.m_Color = Color.blue;
        this.m_Mass1.m_Elasticity = 0.8;
        this.gravity = 10.0;
        this.cvs.expandMap();
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(ELASTICITY)) {
            this.m_Mass1.m_Elasticity = value;
            return true;
        }
        if (name.equalsIgnoreCase(STICKINESS)) {
            if (value < 0.001) {
                value = 0.001;
            }
            if (value > 1.0) {
                value = 1.0;
            }
            this.stickiness = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(ELASTICITY)) {
            return this.m_Mass1.m_Elasticity;
        }
        if (name.equalsIgnoreCase(STICKINESS)) {
            return this.stickiness;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"mass", "damping", "gravity", "show energy", "spring stiffness", "spring rest length", ELASTICITY, STICKINESS};
        return params;
    }

    protected double getEnergy() {
        double v = this.vars[4] == 0.0 ? this.vars[1] * this.vars[1] : this.vars[2] * this.vars[2] + this.vars[3] * this.vars[3];
        double e = 0.5 * this.m_Mass1.m_Mass * v;
        e += this.m_Mass1.m_Mass * this.gravity * this.m_Mass1.getCenterY();
        return e += this.m_Spring.getEnergy();
    }

    public void startDrag(Dragable e) {
        if (e == this.m_Mass1) {
            for (int i = 0; i < this.calc.length; ++i) {
                this.calc[i] = false;
            }
        }
    }

    public void finishDrag(Dragable e) {
        super.finishDrag(e);
        this.calc[4] = false;
    }

    public synchronized void constrainedSet(Dragable e, double x, double y) {
        if (e == this.m_TopMass) {
            super.constrainedSet(e, x, y);
        } else if (e == this.m_Mass1) {
            double w = this.m_Mass1.m_Width / 2.0;
            y += w;
            if (this.m_Path.off_track(x += w)) {
                this.vars[4] = 0.0;
                this.m_Path.closest_to_x_y(this.m_Point, x, y);
                this.vars[0] = this.m_Point.p;
                this.vars[1] = 0.0;
                this.m_Mass1.m_Color = Color.blue;
            } else if (y < this.m_Path.map_x_to_y(x, 0)) {
                this.vars[4] = 0.0;
                this.m_Path.closest_to_x_y(this.m_Point, x, y);
                this.vars[0] = this.m_Point.p;
                this.vars[1] = 0.0;
                this.m_Mass1.m_Color = Color.blue;
            } else {
                this.vars[4] = 1.0;
                this.vars[0] = x;
                this.vars[1] = y;
                this.vars[2] = 0.0;
                this.vars[3] = 0.0;
                this.m_Mass1.m_Color = Color.red;
            }
        }
    }

    public void modifyObjects() {
        if (this.vars[4] == 0.0) {
            double sinth;
            this.m_Point.p = this.vars[0];
            this.m_Path.map_p_to_slope(this.m_Point);
            double x = this.m_Point.x;
            double y = this.m_Point.y;
            this.m_Mass1.setCenterX(x);
            this.m_Mass1.setCenterY(y);
            this.m_Spring.setX2(x);
            this.m_Spring.setY2(y);
            double r = this.m_Point.radius;
            int direction = this.m_Point.direction;
            double k = this.m_Point.slope;
            double slopeDenom = Math.sqrt(1.0 + k * k);
            double g = this.gravity / slopeDenom;
            if (r > 0.0) {
                g = -g;
            }
            double ar = g;
            double b = y - k * x;
            int below = this.m_Spring.m_Y1 < k * this.m_Spring.m_X1 + b ? 1 : -1;
            double sx = this.m_Spring.m_X1 - x;
            double sy = this.m_Spring.m_Y1 - y;
            double slen = Math.sqrt(sx * sx + sy * sy);
            double costh = (double)direction * (sx + k * sy) / slen;
            if ((sinth = Math.sqrt(1.0 - (costh /= slopeDenom) * costh)) > 1.0 || sinth < 0.0) {
                System.out.println("problem in roller4:doModifyObjects");
            }
            double stretch = slen - this.m_Spring.m_RestLength;
            double as = sinth * stretch * this.m_Spring.m_SpringConst / this.m_Mass1.m_Mass;
            ar = r < 0.0 ? (ar += (double)below * as) : (ar -= (double)below * as);
            double v = this.vars[1];
            double av = v * v / r;
            if (av < 0.0) {
                av = -av;
            }
            if (r < 0.0 && ar < av || r > 0.0 && ar > av) {
                this.vars[4] = 1.0;
                this.vars[0] = x;
                this.vars[1] = y;
                this.m_Point.x = this.vars[0];
                this.m_Path.map_x(this.m_Point);
                if (this.vars[1] < this.m_Point.y) {
                    this.vars[1] = this.m_Point.y;
                }
                this.m_Mass1.m_Color = Color.red;
                this.vars[2] = v / slopeDenom;
                this.vars[3] = v * k / slopeDenom;
            }
        } else if (this.vars[4] == 1.0) {
            this.m_Mass1.setCenterX(this.vars[0]);
            this.m_Mass1.setCenterY(this.vars[1]);
            this.m_Spring.setX2(this.vars[0]);
            this.m_Spring.setY2(this.vars[1]);
        }
        this.m_Text.setNumber(this.getEnergy());
    }

    public void evaluate(double[] x, double[] change) {
        if (x[4] == 0.0) {
            super.evaluate(x, change);
            change[4] = 0.0;
            change[3] = 0.0;
            change[2] = 0.0;
        } else {
            change[0] = x[2];
            change[1] = x[3];
            double xx = x[0] - this.m_Spring.m_X1;
            double yy = x[1] - this.m_Spring.m_Y1;
            double len = Math.sqrt(xx * xx + yy * yy);
            double m = this.m_Mass1.m_Mass;
            change[2] = -(this.m_Spring.m_SpringConst / m) * (len - this.m_Spring.m_RestLength) * xx / len;
            change[2] = change[2] - this.m_Mass1.m_Damping / m * x[2];
            change[3] = -this.gravity - this.m_Spring.m_SpringConst / m * (len - this.m_Spring.m_RestLength) * yy / len;
            change[3] = change[3] - this.m_Mass1.m_Damping / m * x[3];
            change[4] = 0.0;
        }
    }

    public Vector findAllCollisions() {
        this.collisions.removeAllElements();
        if (this.vars[4] == 1.0) {
            this.m_Point.x = this.vars[0];
            this.m_Path.map_x(this.m_Point);
            if (this.vars[1] < this.m_Point.y) {
                this.collisions.addElement(new Double(this.m_Point.p));
            }
        }
        return this.collisions.size() > 0 ? this.collisions : null;
    }

    public void handleCollisions(Vector collisions) {
        if (collisions.size() == 0 || this.vars[4] == 0.0) {
            return;
        }
        Double pt = (Double)collisions.firstElement();
        this.m_Path.closest_slope(this.vars[0], this.vars[1], pt, this.m_Point);
        double k = this.m_Point.slope;
        if (this.m_Path.off_track(this.vars[0])) {
            this.vars[0] = this.m_Path.off_track_adjust(this.vars[0]);
            this.vars[2] = 0.0;
            this.vars[3] = 0.0;
        } else {
            double rv;
            double d;
            double vx = this.vars[2];
            double vy = this.vars[3];
            double cx = d = (vx + k * vy) / (1.0 + k * k);
            double cy = d * k;
            double nx = vx - cx;
            double ny = vy - cy;
            double rx = cx - this.m_Mass1.m_Elasticity * nx;
            double ry = cy - this.m_Mass1.m_Elasticity * ny;
            this.vars[2] = rx;
            this.vars[3] = ry;
            double nv = this.m_Mass1.m_Elasticity * Math.sqrt(nx * nx + ny * ny);
            if (nv / (rv = Math.sqrt(rx * rx + ry * ry)) < this.stickiness) {
                this.vars[4] = 0.0;
                this.vars[0] = this.m_Point.p;
                this.vars[1] = Math.sqrt(cx * cx + cy * cy) * (double)(cx > 0.0 ? 1 : -1);
                this.m_Mass1.m_Color = Color.blue;
            }
        }
    }
}

