/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.DiffEq;
import com.myphysicslab.simlab.DiffEqSolver;

public class RungeKutta
implements DiffEqSolver {
    DiffEq ode;
    double[] inp;
    double[] k1;
    double[] k2;
    double[] k3;
    double[] k4;

    public RungeKutta(DiffEq ode) {
        this.ode = ode;
    }

    public void step(double stepSize) {
        int i;
        double[] vars = this.ode.getVars();
        int N = vars.length;
        if (this.inp == null || this.inp.length != N) {
            this.inp = new double[N];
            this.k1 = new double[N];
            this.k2 = new double[N];
            this.k3 = new double[N];
            this.k4 = new double[N];
        }
        this.ode.evaluate(vars, this.k1);
        for (i = 0; i < N; ++i) {
            this.inp[i] = vars[i] + this.k1[i] * stepSize / 2.0;
        }
        this.ode.evaluate(this.inp, this.k2);
        for (i = 0; i < N; ++i) {
            this.inp[i] = vars[i] + this.k2[i] * stepSize / 2.0;
        }
        this.ode.evaluate(this.inp, this.k3);
        for (i = 0; i < N; ++i) {
            this.inp[i] = vars[i] + this.k3[i] * stepSize;
        }
        this.ode.evaluate(this.inp, this.k4);
        boolean[] calc = this.ode.getCalc();
        for (i = 0; i < N; ++i) {
            if (!calc[i]) continue;
            vars[i] = vars[i] + (this.k1[i] + 2.0 * this.k2[i] + 2.0 * this.k3[i] + this.k4[i]) * stepSize / 6.0;
        }
    }
}

