/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CElement;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Simulation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class Spring2DSim
extends Simulation
implements ActionListener {
    private CSpring spring;
    private CMass bob;
    private CMass topMass;
    private JButton button_stop;
    private double gravity = 9.8;
    private double m_Damping = 0.0;
    private static final String MASS = "mass";
    private static final String DAMPING = "damping";
    private static final String LENGTH = "spring rest length";
    private static final String STIFFNESS = "spring stiffness";
    private static final String GRAVITY = "gravity";
    private String[] params = new String[]{"mass", "damping", "spring stiffness", "spring rest length", "gravity"};

    public Spring2DSim(Container container) {
        super(container, 4);
        this.setCoordMap(new CoordMap(-1, -6.0, 6.0, -6.0, 6.0, 0, 0));
        double w = 1.0;
        this.topMass = new CMass(-w / 2.0, 3.0, w, w, 1);
        this.cvs.addElement(this.topMass);
        this.bob = new CMass(-2.5, -2.0, w, w, 2);
        this.bob.m_Mass = 0.5;
        this.cvs.addElement(this.bob);
        this.spring = new CSpring(this.topMass.m_X1 + w / 2.0, this.topMass.m_Y1, 2.5, 0.6);
        this.spring.m_SpringConst = 6.0;
        this.cvs.addElement(this.spring);
        this.var_names = new String[]{"x position", "y position", "x velocity", "y velocity"};
        this.vars[0] = this.bob.m_X1 + this.bob.m_Width / 2.0;
        this.vars[1] = this.bob.m_Y1 + this.bob.m_Height / 2.0;
        this.vars[2] = 0.0;
        this.vars[3] = 0.0;
        this.modifyObjects();
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 1);
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS)) {
            this.bob.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.m_Damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            this.spring.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            this.spring.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS)) {
            return this.bob.m_Mass;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.m_Damping;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.spring.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.spring.m_RestLength;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.vars[0] = this.topMass.m_X1 + this.topMass.m_Width / 2.0;
            this.vars[1] = this.topMass.m_Y1 - this.spring.m_RestLength - this.bob.m_Mass * this.gravity / this.spring.m_SpringConst;
            this.vars[2] = 0.0;
            this.vars[3] = 0.0;
        }
    }

    public void modifyObjects() {
        this.bob.setX1(this.vars[0] - this.bob.m_Width / 2.0);
        this.bob.setY1(this.vars[1] - this.bob.m_Height / 2.0);
        this.spring.setX2(this.vars[0]);
        this.spring.setY2(this.vars[1]);
    }

    public void startDrag(Dragable e) {
        if (e == this.bob) {
            this.calc[0] = false;
            this.calc[1] = false;
            this.calc[2] = false;
            this.calc[3] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.topMass) {
            ((CElement)((Object)e)).setX1(x);
            ((CElement)((Object)e)).setY1(y);
            this.spring.setX1(x + this.topMass.m_Width / 2.0);
            this.spring.setY1(y);
        } else if (e == this.bob) {
            this.vars[0] = x + this.bob.m_Width / 2.0;
            this.vars[1] = y + this.bob.m_Height / 2.0;
            this.vars[2] = 0.0;
            this.vars[3] = 0.0;
            this.modifyObjects();
        }
    }

    public void evaluate(double[] x, double[] change) {
        double m = this.bob.m_Mass;
        double b = this.m_Damping;
        double xx = x[0] - this.spring.m_X1;
        double yy = -x[1] + this.spring.m_Y1;
        double len = Math.sqrt(xx * xx + yy * yy);
        change[0] = x[2];
        change[1] = x[3];
        double r = -(this.spring.m_SpringConst / m) * (len - this.spring.m_RestLength) * xx / len;
        if (b != 0.0) {
            r -= b / m * x[2];
        }
        change[2] = r;
        r = -this.gravity + this.spring.m_SpringConst / m * (len - this.spring.m_RestLength) * yy / len;
        if (b != 0.0) {
            r -= b / m * x[3];
        }
        change[3] = r;
    }
}

