/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.Collision;
import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.Dragable;
import java.awt.Color;
import java.awt.Graphics;
import java.text.NumberFormat;

class Thruster5Object
implements Dragable {
    protected static final int BOTTOM = 0;
    protected static final int RIGHT = 1;
    protected static final int TOP = 2;
    protected static final int LEFT = 3;
    protected static final int X = 0;
    protected static final int VX = 1;
    protected static final int Y = 2;
    protected static final int VY = 3;
    protected static final int W = 4;
    protected static final int VW = 5;
    public double x = 0.0;
    public double y = 0.0;
    public double angle = 0.0;
    protected double width = 0.5;
    protected double height = 3.0;
    public double cmx;
    public double cmy;
    public double thrustX;
    public double thrustY;
    public double[] tAngle;
    public boolean[] active;
    public double tMagnitude = 0.5;
    public double mass = 1.0;
    public double ax;
    public double ay;
    public double bx;
    public double by;
    public double cx;
    public double cy;
    public double dx;
    public double dy;
    public double tx;
    public double ty;
    public Color color = Color.black;

    public Thruster5Object() {
        this.initialize();
    }

    public Thruster5Object(double width, double height) {
        this.initialize();
        this.setWidth(width);
        this.setHeight(height);
        this.thrustX = width / 2.0;
        this.thrustY = 0.8 * height;
    }

    private void initialize() {
        this.thrustX = this.width / 2.0;
        this.thrustY = 0.8 * this.height;
        this.tAngle = new double[4];
        this.tAngle[0] = 1.5707963267948966;
        this.tAngle[1] = -1.5707963267948966;
        this.tAngle[2] = 0.0;
        this.tAngle[3] = Math.PI;
        this.active = new boolean[4];
        this.active[3] = false;
        this.active[2] = false;
        this.active[1] = false;
        this.active[0] = false;
        this.moveTo(this.x, this.y, this.angle);
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(7);
        return "Thruster5Object x=" + nf.format(this.x) + " y=" + nf.format(this.y) + " angle=" + nf.format(this.angle) + " width=" + nf.format(this.width) + " height=" + nf.format(this.height) + " mass=" + nf.format(this.mass) + "\n" + " cornerA=(" + nf.format(this.ax) + "," + nf.format(this.ay) + ") cornerB=(" + nf.format(this.bx) + "," + nf.format(this.by) + ")\n" + " cornerC=(" + nf.format(this.cx) + "," + nf.format(this.cy) + ") cornerD=(" + nf.format(this.dx) + "," + nf.format(this.dy) + ")";
    }

    public boolean isDragable() {
        return this.mass != Double.POSITIVE_INFINITY;
    }

    public double distanceSquared(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setPosition(double x, double y) {
        this.moveTo(x, y, this.angle);
    }

    public double getCornerX(int corner) {
        switch (corner) {
            case 1: {
                return this.ax;
            }
            case 2: {
                return this.bx;
            }
            case 3: {
                return this.cx;
            }
            case 4: {
                return this.dx;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getCornerY(int corner) {
        switch (corner) {
            case 1: {
                return this.ay;
            }
            case 2: {
                return this.by;
            }
            case 3: {
                return this.cy;
            }
            case 4: {
                return this.dy;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getMinHeight() {
        return this.width < this.height ? this.width / 2.0 : this.height / 2.0;
    }

    public void setWidth(double width) {
        this.width = width;
        this.cmx = width / 2.0;
    }

    public void setHeight(double height) {
        this.height = height;
        this.cmy = height / 2.0;
    }

    public double invMass() {
        return this.mass == Double.POSITIVE_INFINITY ? 0.0 : 1.0 / this.mass;
    }

    public double invMomentAboutCM() {
        return this.mass == Double.POSITIVE_INFINITY ? 0.0 : 12.0 / (this.mass * (this.width * this.width + this.height * this.height));
    }

    public double momentAboutCM() {
        return this.mass * (this.width * this.width + this.height * this.height) / 12.0;
    }

    public double kineticEnergy(double vx, double vy, double w) {
        double e = this.translationalEnergy(vx, vy);
        return e += this.rotationalEnergy(w);
    }

    public double rotationalEnergy(double w) {
        return 0.5 * this.momentAboutCM() * w * w;
    }

    public double translationalEnergy(double vx, double vy) {
        double e = 0.5 * this.mass * (vx * vx + vy * vy);
        return e;
    }

    public double[] momentum(double vx, double vy, double w) {
        double[] result = new double[]{this.mass * vx, this.mass * vy, this.momentAboutCM() * w + this.mass * (this.x * vy - this.y * vx)};
        return result;
    }

    public double[] setCornerAt(double H, double V, double angle) {
        double[] r = new double[2];
        double cosa = Math.cos(angle);
        double sina = Math.sin(angle);
        if (angle >= 0.0 && angle <= Math.PI) {
            r[0] = H - sina * this.cmy + cosa * this.cmx;
            r[1] = V + cosa * this.cmy + sina * this.cmx;
        } else if (angle < 0.0 && angle >= -Math.PI) {
            r[0] = H - sina * this.cmy + cosa * this.cmx - cosa * this.width;
            r[1] = V + cosa * this.cmy + sina * this.cmx - sina * this.width;
        } else {
            throw new IllegalArgumentException("setCorner can only handle angles from -PI/2 to PI/2  but angle=" + angle);
        }
        return r;
    }

    public double[] calcVectors(double x, double y, double angle, int thruster) {
        double sinAngle = Math.sin(angle);
        double cosAngle = Math.cos(angle);
        double ex = x + sinAngle * this.cmy;
        double ey = y - cosAngle * this.cmy;
        double ax = ex - cosAngle * this.cmx;
        double ay = ey - sinAngle * this.cmx;
        double tx = ax + cosAngle * this.thrustX - sinAngle * this.thrustY;
        double ty = ay + sinAngle * this.thrustX + cosAngle * this.thrustY;
        double tx2 = tx - Math.sin(angle + this.tAngle[thruster]) * this.tMagnitude;
        double ty2 = ty + Math.cos(angle + this.tAngle[thruster]) * this.tMagnitude;
        double rx = tx - x;
        double ry = ty - y;
        double rlen = Math.sqrt(rx * rx + ry * ry);
        double[] result = new double[]{rx, ry, rx / rlen, ry / rlen, tx2 - tx, ty2 - ty};
        return result;
    }

    public void moveTo(double x, double y, double angle) {
        this.x = x;
        this.y = y;
        this.angle = angle;
        double sinAngle = Math.sin(this.angle);
        double cosAngle = Math.cos(this.angle);
        double ex = this.x + sinAngle * this.cmy;
        double ey = this.y - cosAngle * this.cmy;
        this.ax = ex - cosAngle * this.cmx;
        this.ay = ey - sinAngle * this.cmx;
        this.bx = this.ax + cosAngle * this.width;
        this.by = this.ay + sinAngle * this.width;
        this.cx = this.bx - sinAngle * this.height;
        this.cy = this.by + cosAngle * this.height;
        this.dx = this.ax - sinAngle * this.height;
        this.dy = this.ay + cosAngle * this.height;
        this.tx = this.ax + cosAngle * this.thrustX - sinAngle * this.thrustY;
        this.ty = this.ay + sinAngle * this.thrustX + cosAngle * this.thrustY;
    }

    public void draw(Graphics g, ConvertMap map) {
        int[] xPoints = new int[5];
        int[] yPoints = new int[5];
        int i = 0;
        xPoints[i] = map.simToScreenX(this.ax);
        yPoints[i++] = map.simToScreenY(this.ay);
        xPoints[i] = map.simToScreenX(this.bx);
        yPoints[i++] = map.simToScreenY(this.by);
        xPoints[i] = map.simToScreenX(this.cx);
        yPoints[i++] = map.simToScreenY(this.cy);
        xPoints[i] = map.simToScreenX(this.dx);
        yPoints[i++] = map.simToScreenY(this.dy);
        xPoints[i] = map.simToScreenX(this.ax);
        yPoints[i++] = map.simToScreenY(this.ay);
        g.setColor(this.color);
        g.fillPolygon(xPoints, yPoints, 5);
        if (this.mass != Double.POSITIVE_INFINITY) {
            double sz = 0.15 * (this.width < this.height ? this.width : this.height);
            int w = map.simToScreenScaleX(2.0 * sz);
            int sx = map.simToScreenX(this.tx - sz);
            int sy = map.simToScreenY(this.ty + sz);
            g.setColor(Color.gray);
            g.fillOval(sx, sy, w, w);
            for (int k = 0; k < 4; ++k) {
                if (!this.active[k]) continue;
                double len = Math.log(1.0 + this.tMagnitude) / 0.693219;
                double tx2 = this.tx + Math.sin(this.angle + this.tAngle[k]) * len;
                double ty2 = this.ty - Math.cos(this.angle + this.tAngle[k]) * len;
                g.setColor(Color.red);
                g.drawLine(map.simToScreenX(this.tx), map.simToScreenY(this.ty), map.simToScreenX(tx2), map.simToScreenY(ty2));
            }
        }
    }

    public Collision testCollision(double gx, double gy, int objIndex, int selfIndex) {
        double px = (gx -= this.x) * Math.cos(-this.angle) - (gy -= this.y) * Math.sin(-this.angle);
        double py = gx * Math.sin(-this.angle) + gy * Math.cos(-this.angle);
        px += this.cmx;
        py += this.cmy;
        int edge = 0;
        double d = this.width - px;
        double dist = py;
        if (d < dist) {
            dist = d;
            edge = 1;
        }
        if ((d = this.height - py) < dist) {
            dist = d;
            edge = 2;
        }
        if ((d = px) < dist) {
            dist = d;
            edge = 3;
        }
        if (dist > 0.0) {
            Collision result = new Collision();
            result.colliding = true;
            result.depth = dist;
            result.impactX = gx;
            result.impactY = gy;
            result.normalObj = selfIndex;
            result.object = objIndex;
            this.getNormalForEdge(result, edge);
            return result;
        }
        return null;
    }

    protected void getNormalForEdge(Collision c, int edge) {
        double py;
        double px;
        switch (edge) {
            case 0: {
                px = 0.0;
                py = -1.0;
                break;
            }
            case 1: {
                px = 1.0;
                py = 0.0;
                break;
            }
            case 2: {
                px = 0.0;
                py = 1.0;
                break;
            }
            case 3: {
                px = -1.0;
                py = 0.0;
                break;
            }
            default: {
                throw new IllegalStateException("Can't find normal, no edge specified for " + c);
            }
        }
        c.normalX = px * Math.cos(this.angle) - py * Math.sin(this.angle);
        c.normalY = px * Math.sin(this.angle) + py * Math.cos(this.angle);
    }
}

