/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CElement;
import com.myphysicslab.simlab.ConvertMap;
import java.awt.Color;
import java.awt.Graphics;

class CSpring
extends CElement {
    public double m_RestLength = 1.0;
    public double m_Thickness = 0.5;
    public double m_SpringConst = 1.0;
    public Color m_Color2 = null;

    public CSpring(double X1, double Y1, double restLen, double thick) {
        super(X1, Y1, X1 + restLen, Y1);
        this.m_Thickness = thick;
        this.m_Mass = 0.0;
        this.m_SpringConst = 1.0;
        this.m_RestLength = restLen;
        this.m_DrawMode = 3;
        this.m_Color = Color.red;
        this.m_Color2 = Color.green;
    }

    public double getStretch() {
        double x = this.m_X2 - this.m_X1;
        double y = this.m_Y2 - this.m_Y1;
        return Math.sqrt(x * x + y * y) - this.m_RestLength;
    }

    public double getEnergy() {
        double stretch = this.getStretch();
        return 0.5 * this.m_SpringConst * stretch * stretch;
    }

    public void draw(Graphics g, ConvertMap map) {
        if (this.m_Color2 == null) {
            this.m_Color2 = this.m_Color.brighter();
        }
        int cycles = 3;
        double x1 = this.m_X1;
        double x2 = this.m_X2;
        double y1 = this.m_Y1;
        double y2 = this.m_Y2;
        double theta = Math.atan((y2 - y1) / (x2 - x1));
        if (x2 < x1) {
            theta += Math.acos(-1.0);
        }
        double cos_theta = Math.cos(theta);
        double sin_theta = Math.sin(theta);
        double len = Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
        if (len == 0.0) {
            return;
        }
        if (this.m_DrawMode == 3 && this.m_SpringConst == 0.0) {
            return;
        }
        double h = this.m_Thickness;
        double w = len / 16.0;
        int xscr0 = map.simToScreenX(x1);
        int yscr0 = map.simToScreenY(y1);
        if (this.m_DrawMode == 4) {
            x2 = len;
            y2 = 0.0;
            double x = x1 + cos_theta * x2 - sin_theta * y2;
            double y = y1 + sin_theta * x2 + cos_theta * y2;
            int xscr = map.simToScreenX(x);
            int yscr = map.simToScreenY(y);
            g.setColor(this.m_Color);
            g.drawLine(xscr0, yscr0, xscr, yscr);
        } else if (this.m_DrawMode == 3) {
            int nPoints = 5 + 2 * cycles;
            int i = 0;
            int[] xPoints = new int[nPoints];
            int[] yPoints = new int[nPoints];
            xPoints[i] = xscr0;
            yPoints[i++] = yscr0;
            if (len < this.m_RestLength) {
                g.setColor(this.m_Color);
            } else {
                g.setColor(this.m_Color2);
            }
            x2 = w;
            y2 = 0.0;
            double x = x1 + cos_theta * x2 - sin_theta * y2;
            double y = y1 + sin_theta * x2 + cos_theta * y2;
            xPoints[i] = map.simToScreenX(x);
            yPoints[i++] = map.simToScreenY(y);
            x2 = 2.0 * w;
            y2 = -h / 2.0;
            x = x1 + cos_theta * x2 - sin_theta * y2;
            y = y1 + sin_theta * x2 + cos_theta * y2;
            xPoints[i] = map.simToScreenX(x);
            yPoints[i++] = map.simToScreenY(y);
            for (int j = 1; j <= cycles; ++j) {
                x2 = (double)(4 * j) * w;
                y2 = h / 2.0;
                x = x1 + cos_theta * x2 - sin_theta * y2;
                y = y1 + sin_theta * x2 + cos_theta * y2;
                xPoints[i] = map.simToScreenX(x);
                yPoints[i++] = map.simToScreenY(y);
                x2 = (double)(4 * j + 2) * w;
                y2 = -h / 2.0;
                x = x1 + cos_theta * x2 - sin_theta * y2;
                y = y1 + sin_theta * x2 + cos_theta * y2;
                xPoints[i] = map.simToScreenX(x);
                yPoints[i++] = map.simToScreenY(y);
            }
            x2 = (double)(3 + cycles * 4) * w;
            y2 = 0.0;
            x = x1 + cos_theta * x2 - sin_theta * y2;
            y = y1 + sin_theta * x2 + cos_theta * y2;
            xPoints[i] = map.simToScreenX(x);
            yPoints[i++] = map.simToScreenY(y);
            x2 = len;
            y2 = 0.0;
            x = x1 + cos_theta * x2 - sin_theta * y2;
            y = y1 + sin_theta * x2 + cos_theta * y2;
            xPoints[i] = map.simToScreenX(x);
            yPoints[i++] = map.simToScreenY(y);
            g.drawPolyline(xPoints, yPoints, nPoints);
        }
    }
}

