/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Simulation;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class DoublePendulum
extends Simulation
implements ActionListener {
    private CMass m_Mass1;
    private CMass m_Mass2;
    private CSpring m_Stick1;
    private CSpring m_Stick2;
    private double gravity = 9.8;
    private JButton button_stop;
    private static final String MASS1 = "mass1";
    private static final String MASS2 = "mass2";
    private static final String LENGTH1 = "stick1 length";
    private static final String LENGTH2 = "stick2 length";
    private static final String GRAVITY = "gravity";
    private String[] params = new String[]{"mass1", "mass2", "stick1 length", "stick2 length", "gravity"};

    public DoublePendulum(Container container) {
        super(container, 4);
        this.var_names = new String[]{"angle1", "angle1 velocity", "angle2", "angle2 velocity"};
        this.setCoordMap(new CoordMap(-1, -2.0, 2.0, -2.2, 1.5, 0, 0));
        this.m_Stick1 = new CSpring(0.0, 0.0, 1.0, 0.4);
        this.m_Stick1.m_DrawMode = 4;
        this.cvs.addElement(this.m_Stick1);
        this.m_Stick2 = new CSpring(0.0, 0.0, 1.0, 0.4);
        this.m_Stick2.m_DrawMode = 4;
        this.cvs.addElement(this.m_Stick2);
        double w = 0.2;
        this.m_Mass1 = new CMass(0.0, 0.0, w, w, 5);
        this.m_Mass1.m_Mass = 0.5;
        this.m_Mass1.m_Color = Color.blue;
        this.cvs.addElement(this.m_Mass1);
        this.m_Mass2 = new CMass(0.0, 0.0, w, w, 5);
        this.m_Mass2.m_Mass = 0.5;
        this.m_Mass2.m_Damping = 0.0;
        this.m_Mass2.m_Color = Color.blue;
        this.cvs.addElement(this.m_Mass2);
        this.vars[0] = 0.39269908169872414;
        this.modifyObjects();
    }

    public void setupControls() {
        super.setupControls();
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 2);
        }
    }

    protected void setValue(int param, double value) {
        switch (param) {
            case 0: {
                this.m_Mass1.m_Mass = value;
                break;
            }
            case 1: {
                this.m_Mass2.m_Mass = value;
                break;
            }
            case 2: {
                this.m_Stick1.m_RestLength = value;
                break;
            }
            case 3: {
                this.m_Stick2.m_RestLength = value;
                break;
            }
            case 4: {
                this.gravity = value;
            }
        }
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS1)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            this.m_Mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH1)) {
            this.m_Stick1.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH2)) {
            this.m_Stick2.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS1)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            return this.m_Mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(LENGTH1)) {
            return this.m_Stick1.m_RestLength;
        }
        if (name.equalsIgnoreCase(LENGTH2)) {
            return this.m_Stick2.m_RestLength;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.vars[3] = 0.0;
            this.vars[2] = 0.0;
            this.vars[1] = 0.0;
            this.vars[0] = 0.0;
        }
    }

    public void modifyObjects() {
        if (this.vars[0] > Math.PI) {
            this.vars[0] = this.vars[0] - Math.PI * 2 * Math.floor(this.vars[0] / Math.PI);
        } else if (this.vars[0] < -Math.PI) {
            this.vars[0] = this.vars[0] - Math.PI * 2 * Math.ceil(this.vars[0] / Math.PI);
        }
        if (this.vars[2] > Math.PI) {
            this.vars[2] = this.vars[2] - Math.PI * 2 * Math.floor(this.vars[2] / Math.PI);
        } else if (this.vars[2] < -Math.PI) {
            this.vars[2] = this.vars[2] - Math.PI * 2 * Math.ceil(this.vars[2] / Math.PI);
        }
        double w = this.m_Mass1.m_Width / 2.0;
        double L1 = this.m_Stick1.m_RestLength;
        double L2 = this.m_Stick2.m_RestLength;
        double th1 = this.vars[0];
        double th2 = this.vars[2];
        double x1 = L1 * Math.sin(th1);
        double y1 = -L1 * Math.cos(th1);
        double x2 = x1 + L2 * Math.sin(th2);
        double y2 = y1 - L2 * Math.cos(th2);
        this.m_Stick1.setBounds(0.0, 0.0, x1, y1);
        this.m_Mass1.setPosition(x1 - w, y1 - w);
        this.m_Stick2.setBounds(x1, y1, x2, y2);
        this.m_Mass2.setPosition(x2 - w, y2 - w);
    }

    public void startDrag(Dragable e) {
        if (e == this.m_Mass1 || e == this.m_Mass2) {
            this.calc[3] = false;
            this.calc[2] = false;
            this.calc[1] = false;
            this.calc[0] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        double w = this.m_Mass1.m_Width / 2.0;
        if (e == this.m_Mass1) {
            double th1;
            double xx = x + w;
            double yy = y + w;
            this.vars[0] = th1 = Math.atan2(xx, -yy);
            this.vars[1] = 0.0;
            this.vars[3] = 0.0;
            this.modifyObjects();
        } else if (e == this.m_Mass2) {
            double L1 = this.m_Stick1.m_RestLength;
            double L2 = this.m_Stick2.m_RestLength;
            double x1 = L1 * Math.sin(this.vars[0]);
            double y1 = -L1 * Math.cos(this.vars[0]);
            double x2 = x + w;
            double y2 = y + w;
            double th2 = Math.atan2(x2 - x1, -(y2 - y1));
            this.vars[1] = 0.0;
            this.vars[2] = th2;
            this.vars[3] = 0.0;
            this.modifyObjects();
        }
    }

    public void evaluate(double[] x, double[] change) {
        double th1 = x[0];
        double dth1 = x[1];
        double th2 = x[2];
        double dth2 = x[3];
        double m2 = this.m_Mass2.m_Mass;
        double m1 = this.m_Mass1.m_Mass;
        double L1 = this.m_Stick1.m_RestLength;
        double L2 = this.m_Stick2.m_RestLength;
        double g = this.gravity;
        change[0] = dth1;
        double num = -g * (2.0 * m1 + m2) * Math.sin(th1);
        num -= g * m2 * Math.sin(th1 - 2.0 * th2);
        num -= 2.0 * m2 * dth2 * dth2 * L2 * Math.sin(th1 - th2);
        num -= m2 * dth1 * dth1 * L1 * Math.sin(2.0 * (th1 - th2));
        change[1] = num /= L1 * (2.0 * m1 + m2 - m2 * Math.cos(2.0 * (th1 - th2)));
        change[2] = dth2;
        num = (m1 + m2) * dth1 * dth1 * L1;
        num += g * (m1 + m2) * Math.cos(th1);
        num += m2 * dth2 * dth2 * L2 * Math.cos(th1 - th2);
        num = num * 2.0 * Math.sin(th1 - th2);
        change[3] = num /= L2 * (2.0 * m1 + m2 - m2 * Math.cos(2.0 * (th1 - th2)));
    }
}

