/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

final class DoubleRect {
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;

    public DoubleRect(double xMin, double yMin, double xMax, double yMax) {
        if (xMin > xMax) {
            throw new IllegalArgumentException("xMin=" + xMin + " must be less than xMax=" + xMax);
        }
        if (yMin > yMax) {
            throw new IllegalArgumentException("yMin=" + yMin + " must be less than yMax=" + yMax);
        }
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    public String toString() {
        return "DoubleRect xMin=" + this.xMin + " xMax=" + this.xMax + " yMin=" + this.yMin + " yMax=" + this.yMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getWidth() {
        return this.xMax - this.xMin;
    }

    public double getHeight() {
        return this.yMax - this.yMin;
    }
}

