/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.Graphable;
import com.myphysicslab.simlab.MyLabel;
import com.myphysicslab.simlab.SimPanel;
import com.myphysicslab.simlab.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Graph
extends JComponent
implements MouseListener,
ItemListener,
ActionListener,
SimPanel {
    public static final int DOTS = 0;
    public static final int LINES = 1;
    private Image offScreen = null;
    private Graphable sim;
    private CoordMap map;
    private int xVar = 0;
    private int yVar = 1;
    private int zVar = 2;
    private int drawMode = 1;
    private int dotSize = 1;
    private NumberFormat nf;
    private Font numFont = null;
    private FontMetrics numFM = null;
    private boolean autoScale;
    private boolean rangeSet;
    private boolean rangeDirty;
    private double rangeXHi;
    private double rangeXLo;
    private double rangeYHi;
    private double rangeYLo;
    private double rangeTime = 0.0;
    private boolean needRedraw = true;
    private static final int memLen = 3000;
    private double[] memX = new double[3000];
    private double[] memY = new double[3000];
    private double[] memZ = new double[3000];
    private int memIndex = 0;
    private int memSize = 0;
    private int memDraw = 0;
    private JComboBox yGraphChoice;
    private JPanel yPanel;
    private JComboBox xGraphChoice;
    private JPanel xPanel;
    private JComboBox dotChoice;
    private JButton clearButton;
    private Container container;
    private double startTime = (double)System.currentTimeMillis() / 1000.0;
    private static float[] red;
    private static float[] blue;
    private static float redHue;
    private static float blueHue;
    private static float diffHue;
    private static float lowHue;
    private static boolean zMode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Graph(Graphable sim, Container applet) {
        this.sim = sim;
        this.container = applet;
        int sz = 10;
        this.map = new CoordMap(-1, -sz, sz, -sz, sz, 0, 0);
        this.nf = NumberFormat.getNumberInstance();
        this.map.setFillScreen(true);
        this.setAutoScale(true);
        this.addMouseListener(this);
        if (!this.isOpaque()) {
            Utility.println("setting Graph to be opaque!");
            this.setOpaque(true);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    private void dbg(String s) {
        double now = this.getTime();
        System.out.println(s + " " + now);
    }

    public void createButtons(Container container, int index) {
        int i;
        this.clearButton = new JButton("clear graph");
        this.clearButton.addActionListener(this);
        int n = this.sim.numVariables();
        this.yPanel = new JPanel();
        this.yPanel.setLayout(new BorderLayout(1, 1));
        this.yPanel.add((Component)new MyLabel("Y:"), "West");
        this.yGraphChoice = new JComboBox();
        for (i = 0; i < n; ++i) {
            this.yGraphChoice.addItem(this.sim.getVariableName(i));
        }
        this.yGraphChoice.addItemListener(this);
        this.yGraphChoice.setSelectedIndex(this.yVar);
        this.yPanel.add((Component)this.yGraphChoice, "East");
        this.xPanel = new JPanel();
        this.xPanel.setLayout(new BorderLayout(1, 1));
        this.xPanel.add((Component)new MyLabel("X:"), "West");
        this.xGraphChoice = new JComboBox();
        for (i = 0; i < n; ++i) {
            this.xGraphChoice.addItem(this.sim.getVariableName(i));
        }
        this.xGraphChoice.addItemListener(this);
        this.xGraphChoice.setSelectedIndex(this.xVar);
        this.xPanel.add((Component)this.xGraphChoice, "East");
        this.dotChoice = new JComboBox();
        this.dotChoice.addItem("dots");
        this.dotChoice.addItem("lines");
        this.dotChoice.setSelectedIndex(this.drawMode);
        this.dotChoice.addItemListener(this);
        this.showControls(container, index);
    }

    public void enableControls(boolean b) {
        this.yGraphChoice.setEnabled(b);
        this.xGraphChoice.setEnabled(b);
        this.dotChoice.setEnabled(b);
        this.clearButton.setEnabled(b);
    }

    public void hideControls(Container container) {
        container.remove(this.yPanel);
        container.remove(this.xPanel);
        container.remove(this.dotChoice);
        container.remove(this.clearButton);
    }

    public void showControls(Container container, int index) {
        container.add((Component)this.clearButton, index);
        container.add((Component)this.yPanel, ++index);
        container.add((Component)this.xPanel, ++index);
        container.add((Component)this.dotChoice, ++index);
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.yGraphChoice != null) {
            this.yVar = this.yGraphChoice.getSelectedIndex();
        }
        if (this.xGraphChoice != null) {
            this.xVar = this.xGraphChoice.getSelectedIndex();
        }
        if (this.dotChoice != null) {
            this.drawMode = this.dotChoice.getSelectedIndex();
        }
        this.reset();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clearButton) {
            this.reset();
        }
    }

    public void setXVar(int xVar) {
        if (xVar >= 0 && xVar < this.sim.numVariables()) {
            this.xVar = xVar;
            this.xGraphChoice.setSelectedIndex(xVar);
            this.reset();
        }
    }

    public void setYVar(int yVar) {
        if (yVar >= 0 && yVar < this.sim.numVariables()) {
            this.yVar = yVar;
            this.yGraphChoice.setSelectedIndex(yVar);
            this.reset();
        }
    }

    public void setZVar(int zVar) {
        if (zVar >= 0 && zVar < this.sim.numVariables()) {
            this.zVar = zVar;
            zMode = true;
            zMode = false;
            this.reset();
        }
    }

    public void setVars(int xVar, int yVar) {
        this.setXVar(xVar);
        this.setYVar(yVar);
    }

    public void setDrawMode(int drawMode) {
        this.drawMode = drawMode;
        this.dotChoice.setSelectedIndex(drawMode);
        this.reset();
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public synchronized void reset() {
        this.rangeSet = false;
        this.rangeDirty = false;
        this.rangeTime = 0.0;
        this.memDraw = 0;
        this.memSize = 0;
        this.memIndex = 0;
        this.needRedraw = true;
        Utility.println("**** reset is calling repaint()");
        this.repaint();
    }

    public void setSize(int width, int height) {
        Utility.println("*****  Graph.setSize(" + width + ", " + height + ")");
        super.setSize(width, height);
        this.freeOffScreen();
        this.map.setScreen(0, 0, width, height);
        this.needRedraw = true;
    }

    private static Color zToColor(double z) {
        float zFraction = ((float)z - -1.7f) / 3.4f;
        return Color.getHSBColor(zFraction * diffHue + lowHue, 1.0f, 1.0f);
    }

    public void freeOffScreen() {
        this.offScreen = null;
    }

    public synchronized void memorize() {
        this.memX[this.memIndex] = this.sim.getVariable(this.xVar);
        this.memY[this.memIndex] = this.sim.getVariable(this.yVar);
        if (zMode) {
            this.memZ[this.memIndex] = this.sim.getVariable(this.zVar);
        }
        if (this.autoScale) {
            this.rangeCheck(this.memX[this.memIndex], this.memY[this.memIndex]);
        }
        ++this.memIndex;
        if (this.memSize < 3000) {
            ++this.memSize;
        }
        if (this.memIndex >= 3000) {
            this.memIndex = 0;
        }
    }

    private int drawPoints(Graphics g, int from) {
        int pointer = from;
        if (this.memSize > 0) {
            while (true) {
                int h;
                int w;
                int y;
                int x;
                int i1 = pointer;
                int i2 = (pointer + 1) % 3000;
                if (i2 == this.memIndex) break;
                g.setColor(Color.black);
                if (zMode) {
                    g.setColor(Graph.zToColor(this.memZ[i1]));
                }
                if (this.drawMode == 0) {
                    x = this.map.simToScreenX(this.memX[i1]);
                    y = this.map.simToScreenY(this.memY[i1]);
                    w = this.dotSize;
                    h = this.dotSize;
                    g.fillRect(x, y, w, h);
                } else {
                    int x1 = this.map.simToScreenX(this.memX[i1]);
                    int y1 = this.map.simToScreenY(this.memY[i1]);
                    int x2 = this.map.simToScreenX(this.memX[i2]);
                    int y2 = this.map.simToScreenY(this.memY[i2]);
                    x = x1 < x2 ? x1 : x2;
                    y = y1 < y2 ? y1 : y2;
                    w = 1 + (x1 < x2 ? x2 - x1 : x1 - x2);
                    h = 1 + (y1 < y2 ? y2 - y1 : y1 - y2);
                    g.drawLine(x1, y1, x2, y2);
                }
                pointer = i2;
            }
        }
        return pointer;
    }

    private void updateOSB() {
        if (this.offScreen == null) {
            this.offScreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        if (!$assertionsDisabled && this.offScreen == null) {
            throw new AssertionError();
        }
        Graphics osb = this.offScreen.getGraphics();
        if (!$assertionsDisabled && osb == null) {
            throw new AssertionError();
        }
        if (this.needRedraw) {
            Rectangle b = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            osb.setColor(Color.white);
            osb.fillRect(b.x, b.y, b.width, b.height);
            osb.setColor(Color.lightGray);
            osb.drawRect(b.x, b.y, b.width - 1, b.height - 1);
            this.drawAxes(osb);
            int start = this.memSize < 3000 ? 0 : this.memIndex;
            this.memDraw = this.drawPoints(osb, start);
            this.needRedraw = false;
        } else {
            this.memDraw = this.drawPoints(osb, this.memDraw);
        }
        osb.dispose();
    }

    protected synchronized void paintComponent(Graphics g) {
        this.updateOSB();
        Rectangle clip = g.getClipBounds();
        g.drawImage(this.offScreen, clip.x, clip.y, clip.width, clip.height, null);
        int xorX = this.map.simToScreenX(this.memX[this.memDraw]) - 1;
        int xorY = this.map.simToScreenY(this.memY[this.memDraw]) - 1;
        Color saveColor = g.getColor();
        g.setColor(Color.red);
        g.fillRect(xorX, xorY, 4, 4);
        g.setColor(saveColor);
    }

    public void setAutoScale(boolean auto) {
        this.autoScale = auto;
        this.rangeSet = false;
        this.rangeDirty = false;
        this.rangeTime = 0.0;
    }

    private double getTime() {
        double time = (double)System.currentTimeMillis() / 1000.0;
        return time;
    }

    private void rangeCheck(double nowX, double nowY) {
        if (!this.rangeSet) {
            this.rangeXHi = nowX;
            this.rangeXLo = nowX;
            this.rangeYHi = nowY;
            this.rangeYLo = nowY;
            this.rangeSet = true;
        } else {
            double xspan = this.rangeXHi - this.rangeXLo;
            double yspan = this.rangeYHi - this.rangeYLo;
            double extra = 0.1;
            if (nowX <= this.rangeXLo) {
                this.rangeXLo = nowX - extra * xspan;
                this.rangeDirty = true;
            }
            if (nowX >= this.rangeXHi) {
                this.rangeXHi = nowX + extra * xspan;
                this.rangeDirty = true;
            }
            if (nowY <= this.rangeYLo) {
                this.rangeYLo = nowY - extra * yspan;
                this.rangeDirty = true;
            }
            if (nowY >= this.rangeYHi) {
                this.rangeYHi = nowY + extra * yspan;
                this.rangeDirty = true;
            }
        }
        double now = this.getTime();
        if (this.rangeTime == 0.0) {
            this.rangeTime = now;
        }
        if (this.rangeDirty && now > this.rangeTime + 2.0) {
            this.rangeTime = now;
            this.map.setRange(this.rangeXLo, this.rangeXHi, this.rangeYLo, this.rangeYHi);
            this.needRedraw = true;
            this.repaint();
            this.rangeDirty = false;
        }
    }

    private void setAxesFont(Graphics g) {
        if (this.numFont == null) {
            this.numFont = new Font("SansSerif", 0, 12);
            this.numFM = g.getFontMetrics(this.numFont);
        }
        g.setFont(this.numFont);
    }

    private void drawAxes(Graphics g) {
        this.setAxesFont(g);
        double sim_x1 = this.map.getMinX();
        double sim_x2 = this.map.getMaxX();
        double sim_y1 = this.map.getMinY();
        double sim_y2 = this.map.getMaxY();
        int x0 = this.map.simToScreenX(sim_x1 + 0.05 * (sim_x2 - sim_x1));
        int y0 = this.map.simToScreenY(sim_y1) - (10 + this.numFM.getAscent() + this.numFM.getDescent());
        g.setColor(Color.darkGray);
        g.drawLine(this.map.simToScreenX(sim_x1), y0, this.map.simToScreenX(sim_x2), y0);
        g.drawLine(x0, this.map.simToScreenY(sim_y1), x0, this.map.simToScreenY(sim_y2));
        this.drawHorizTicks(y0, g);
        this.drawVertTicks(x0, g);
    }

    private void drawHorizTicks(int y0, Graphics g) {
        int y1 = y0 - 4;
        int y2 = y1 + 8;
        double sim_x1 = this.map.getMinX();
        double sim_x2 = this.map.getMaxX();
        double graphDelta = this.getNiceIncrement(sim_x2 - sim_x1);
        for (double x_sim = this.getNiceStart(sim_x1, graphDelta); x_sim < sim_x2; x_sim += graphDelta) {
            int x_screen = this.map.simToScreenX(x_sim);
            g.setColor(Color.black);
            g.drawLine(x_screen, y1, x_screen, y2);
            g.setColor(Color.gray);
            String s = this.nf.format(x_sim);
            int textWidth = this.numFM.stringWidth(s);
            g.drawString(s, x_screen - textWidth / 2, y2 + this.numFM.getAscent());
        }
        String hname = this.sim.getVariableName(this.xVar);
        int w = this.numFM.stringWidth(hname);
        g.drawString(hname, this.map.simToScreenX(sim_x2) - w - 5, y0 - 8);
    }

    private void drawVertTicks(int x0, Graphics g) {
        int x1 = x0 - 4;
        int x2 = x1 + 8;
        double sim_y1 = this.map.getMinY();
        double sim_y2 = this.map.getMaxY();
        double graphDelta = this.getNiceIncrement(sim_y2 - sim_y1);
        for (double y_sim = this.getNiceStart(sim_y1, graphDelta); y_sim < sim_y2; y_sim += graphDelta) {
            int y_screen = this.map.simToScreenY(y_sim);
            g.setColor(Color.black);
            g.drawLine(x1, y_screen, x2, y_screen);
            g.setColor(Color.gray);
            String s = this.nf.format(y_sim);
            int textWidth = this.numFM.stringWidth(s);
            g.drawString(s, x2 + 5, y_screen + this.numFM.getAscent() / 2);
        }
        String vname = this.sim.getVariableName(this.yVar);
        int w = this.numFM.stringWidth(vname);
        g.drawString(vname, x0 + 6, this.map.simToScreenY(sim_y2) + 13);
    }

    private double getNiceIncrement(double range) {
        double power = Math.pow(10.0, Math.floor(Math.log(range) / Math.log(10.0)));
        double logTot = range / power;
        double incr = logTot >= 8.0 ? 2.0 : (logTot >= 5.0 ? 1.0 : (logTot >= 3.0 ? 0.5 : (logTot >= 2.0 ? 0.4 : 0.2)));
        double dlog = Math.log(incr *= power) / Math.log(10.0);
        int digits = dlog < 0.0 ? (int)Math.ceil(-dlog) : 0;
        this.nf.setMaximumFractionDigits(digits);
        this.nf.setMinimumFractionDigits(0);
        return incr;
    }

    private double getNiceStart(double start, double incr) {
        return Math.ceil(start / incr) * incr;
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    static {
        $assertionsDisabled = !Graph.class.desiredAssertionStatus();
        red = Color.RGBtoHSB(1, 0, 0, null);
        blue = Color.RGBtoHSB(0, 0, 1, null);
        redHue = red[0];
        blueHue = blue[0];
        diffHue = redHue < blueHue ? blueHue - redHue : redHue - blueHue;
        lowHue = redHue < blueHue ? redHue : blueHue;
        zMode = false;
    }
}

