/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.Observer;
import com.myphysicslab.simlab.Subject;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;

class MyChoice
extends JComboBox
implements ItemListener,
Observer {
    private double value;
    private double min;
    private String name;
    private Subject subj;

    public MyChoice(Subject subj, String name, double value, double min, Object[] choices) {
        this.subj = subj;
        this.name = name;
        this.value = value;
        this.min = min;
        int index = (int)(value - min);
        if (index < 0 || index >= choices.length) {
            throw new IllegalArgumentException("Value=" + value + " but must be in range " + min + " to " + (min + (double)choices.length - 1.0));
        }
        for (int i = 0; i < choices.length; ++i) {
            this.addItem(choices[i].toString());
        }
        this.setSelectedIndex(index);
        this.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        this.value = this.min + (double)this.getSelectedIndex();
        if (this.subj != null) {
            this.subj.setParameter(this.name, this.value);
        }
    }

    public void update(Subject subj, String param, double value) {
        if (param.equalsIgnoreCase(this.name) && value != this.value) {
            int index = (int)(Math.floor(value) - this.min);
            if (index < 0 || index >= this.getItemCount()) {
                throw new IllegalArgumentException("Value=" + value + " but must be in range " + this.min + " to " + (this.min + (double)this.getItemCount() - 1.0));
            }
            this.value = Math.floor(value);
            this.setSelectedIndex((int)(this.value - this.min));
        }
    }
}

