/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CVector;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.Drawable;
import com.myphysicslab.simlab.Simulation;
import com.myphysicslab.simlab.Utility;
import java.awt.Color;
import java.awt.Container;
import java.util.Vector;

public class Pendulum2
extends Simulation {
    private CMass m_Mass;
    private CMass m_Mass2;
    private double radius = 0.4;
    private double mass = 1.0;
    private double damping = 0.0;
    private CSpring m_Spring;
    private CSpring m_Spring2;
    private double m_Gravity = 1.0;
    protected Vector rxnForces = new Vector(20);
    private double offsetX = 0.5;
    private double offsetY = 0.0;
    private static final String MASS = "mass";
    private static final String DAMPING = "damping";
    private static final String LENGTH = "length";
    private static final String AMPLITUDE = "drive amplitude";
    private static final String FREQUENCY = "drive frequency";
    private static final String GRAVITY = "gravity";
    private static final String RADIUS = "radius";
    private String[] params = new String[]{"mass", "damping", "length", "drive amplitude", "drive frequency", "gravity", "radius"};

    public String toString() {
        return "Pendulum2 simulation";
    }

    public Pendulum2(Container container) {
        super(container, 8);
        this.var_names = new String[]{"x position", "x velocity", "y position", "y velocity", "angle", "angular velocity", "angle2", "angle2 velocity"};
        this.setCoordMap(new CoordMap(-1, -1.5, 1.5, -1.5, 1.5, 0, 0));
        double len = 1.0;
        double len2 = (this.radius * this.radius / 2.0 + len * len) / len;
        System.out.println("len=" + len + " len2=" + len2);
        this.m_Spring2 = new CSpring(0.0, 0.0, len2, 0.4);
        this.m_Spring2.m_DrawMode = 4;
        this.m_Spring2.m_Color = Color.blue;
        this.cvs.addElement(this.m_Spring2);
        this.m_Mass2 = new CMass(0.0, 0.0, this.radius * 2.0, this.radius * 2.0, 2);
        this.cvs.addElement(this.m_Mass2);
        this.m_Spring = new CSpring(0.0, 0.0, len, 0.4);
        this.m_Spring.m_DrawMode = 4;
        this.m_Spring.m_Color = Color.green;
        this.cvs.addElement(this.m_Spring);
        this.m_Mass = new CMass(0.0, 0.0, this.radius * 2.0, this.radius * 2.0, 2);
        this.cvs.addElement(this.m_Mass);
        this.vars[4] = 2.356194490192345;
        this.vars[0] = len * Math.sin(this.vars[4]);
        this.vars[2] = -len * Math.cos(this.vars[4]);
        this.vars[5] = 0.0;
        this.vars[3] = 0.0;
        this.vars[1] = 0.0;
        this.vars[6] = this.vars[4];
        this.vars[7] = 0.0;
        this.modifyObjects();
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setDrawMode(0);
            this.graph.setXVar(4);
            this.graph.setYVar(5);
        }
    }

    public void setupControls() {
        super.setupControls();
        this.addObserverControl(new DoubleField(this, MASS, 3));
        this.addObserverControl(new DoubleField(this, DAMPING, 3));
        this.addObserverControl(new DoubleField(this, LENGTH, 3));
        this.addObserverControl(new DoubleField(this, GRAVITY, 3));
        this.showControls(true);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS)) {
            this.mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            this.m_Spring.m_RestLength = value;
            this.vars[0] = value * Math.sin(this.vars[4]);
            this.vars[2] = -value * Math.cos(this.vars[4]);
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.m_Gravity = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS)) {
            return this.mass;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.damping;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.m_Spring.m_RestLength;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.m_Gravity;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void modifyObjects() {
        if (this.vars[4] > Math.PI) {
            this.vars[4] = this.vars[4] - Math.PI * 2 * Math.floor(this.vars[4] / Math.PI);
        } else if (this.vars[4] < -Math.PI) {
            this.vars[4] = this.vars[4] - Math.PI * 2 * Math.ceil(this.vars[4] / Math.PI);
        }
        double len = this.m_Spring.m_RestLength;
        this.m_Spring.setX1(this.vars[0] - len * Math.sin(this.vars[4]));
        this.m_Spring.setY1(this.vars[2] + len * Math.cos(this.vars[4]));
        this.m_Spring.setX2(this.vars[0]);
        this.m_Spring.setY2(this.vars[2]);
        this.m_Mass.setCenterX(this.m_Spring.m_X2);
        this.m_Mass.setCenterY(this.m_Spring.m_Y2);
        double len2 = this.m_Spring2.m_RestLength;
        this.m_Spring2.setX1(0.0 + this.offsetX);
        this.m_Spring2.setY1(0.0 + this.offsetY);
        this.m_Spring2.setX2(len2 * Math.sin(this.vars[6]) + this.offsetX);
        this.m_Spring2.setY2(-len2 * Math.cos(this.vars[6]) + this.offsetY);
        this.m_Mass2.setCenterX(this.m_Spring2.m_X2);
        this.m_Mass2.setCenterY(this.m_Spring2.m_Y2);
    }

    public int numVariables() {
        return this.var_names.length;
    }

    public void evaluate2(double[] x, double[] change) {
        double a;
        double m = this.mass;
        change[0] = x[1];
        change[1] = 0.0;
        change[2] = x[3];
        change[3] = -this.m_Gravity;
        change[4] = x[5];
        change[5] = 0.0;
        double len = this.m_Spring.m_RestLength;
        double nx = 0.0;
        double ny = 1.0;
        double rx = -len * Math.sin(x[4]);
        double ry = len * Math.cos(x[4]);
        double w = x[5];
        double vx = x[1];
        double vy = x[3];
        double[][] A = new double[1][2];
        double[] B = new double[1];
        double[] f = new double[1];
        double b = 0.0;
        B[0] = b += nx * (change[1] - change[5] * ry - w * w * rx) + ny * (change[3] + change[5] * rx - w * w * ry);
        double I = m * (len * len) / 12.0;
        A[0][0] = a = nx * (nx / m - ry * (rx * ny - ry * nx) / I) + ny * (ny / m + rx * (rx * ny - ry * nx) / I);
        A[0][1] = -B[0];
        Utility.matrixSolve(A, f);
        change[1] = change[1] + f[0] * nx / m;
        change[3] = change[3] + f[0] * ny / m;
        change[5] = change[5] + (rx * f[0] * ny - ry * f[0] * nx) / I;
        double py = change[3] + change[5] * rx - w * w * ry;
        System.out.println("py''= " + py);
    }

    public void evaluate(double[] x, double[] change) {
        double b;
        while (!this.rxnForces.isEmpty()) {
            Drawable d = (Drawable)this.rxnForces.lastElement();
            this.cvs.removeElement(d);
            this.rxnForces.removeElement(d);
        }
        double m = this.mass;
        change[0] = x[1];
        change[1] = -this.damping * x[1];
        change[2] = x[3];
        change[3] = -this.m_Gravity - this.damping * x[3];
        change[4] = x[5];
        change[5] = 0.0;
        change[6] = x[7];
        double l2 = this.m_Spring2.m_RestLength;
        double dd = -(this.m_Gravity / l2) * Math.sin(x[6]);
        double mlsq = m * l2 * l2;
        change[7] = dd += -(this.damping / mlsq) * x[7];
        double len = this.m_Spring.m_RestLength;
        double I = m * (this.radius * this.radius / 2.0);
        double n0x = 0.0;
        double n0y = -1.0;
        double n1x = -1.0;
        double n1y = 0.0;
        double rx = -len * Math.sin(x[4]);
        double ry = len * Math.cos(x[4]);
        double vx = x[1];
        double vy = x[3];
        double w = x[5];
        double[][] A = new double[2][3];
        double[] B = new double[2];
        double[] f = new double[2];
        double nx = n0x;
        double ny = n0y;
        B[0] = b = nx * (change[1] - change[5] * ry - w * w * rx) + ny * (change[3] + change[5] * rx - w * w * ry);
        nx = n1x;
        ny = n1y;
        B[1] = b = nx * (change[1] - change[5] * ry - w * w * rx) + ny * (change[3] + change[5] * rx - w * w * ry);
        nx = n0x;
        ny = n0y;
        double nix = n0x;
        double niy = n0y;
        A[0][0] = nix * (nx / m - ry * (rx * ny - ry * nx) / I) + niy * (ny / m + rx * (rx * ny - ry * nx) / I);
        nx = n1x;
        ny = n1y;
        nix = n0x;
        niy = n0y;
        A[0][1] = nix * (nx / m - ry * (rx * ny - ry * nx) / I) + niy * (ny / m + rx * (rx * ny - ry * nx) / I);
        nx = n0x;
        ny = n0y;
        nix = n1x;
        niy = n1y;
        A[1][0] = nix * (nx / m - ry * (rx * ny - ry * nx) / I) + niy * (ny / m + rx * (rx * ny - ry * nx) / I);
        nx = n1x;
        ny = n1y;
        nix = n1x;
        niy = n1y;
        A[1][1] = nix * (nx / m - ry * (rx * ny - ry * nx) / I) + niy * (ny / m + rx * (rx * ny - ry * nx) / I);
        A[0][2] = -B[0];
        A[1][2] = -B[1];
        Utility.matrixSolve(A, f);
        nx = n0x;
        ny = n0y;
        double Fx = f[0] * nx;
        double Fy = f[0] * ny;
        this.showForce(0.0, 0.0, f[0] * nx, f[0] * ny);
        change[1] = change[1] + f[0] * nx / m;
        change[3] = change[3] + f[0] * ny / m;
        change[5] = change[5] + (rx * f[0] * ny - ry * f[0] * nx) / I;
        nx = n1x;
        ny = n1y;
        Fx += f[1] * nx;
        Fy += f[1] * ny;
        this.showForce(0.0, 0.0, f[1] * nx, f[1] * ny);
        change[1] = change[1] + f[1] * nx / m;
        change[3] = change[3] + f[1] * ny / m;
        change[5] = change[5] + (rx * f[1] * ny - ry * f[1] * nx) / I;
        double px = change[1] - change[5] * ry - w * w * rx;
        double py = change[3] + change[5] * rx - w * w * ry;
        this.showForce(0.0, 0.0, Fx, Fy);
    }

    private void showForce(double x, double y, double fx, double fy) {
        CVector v = new CVector(x, y, fx, fy);
        this.cvs.addElement(v);
        this.rxnForces.addElement(v);
    }
}

