/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Drawable;
import com.myphysicslab.simlab.MouseDragHandler;
import com.myphysicslab.simlab.ObjectListener;
import com.myphysicslab.simlab.SimPanel;
import com.myphysicslab.simlab.Utility;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class SimCanvas
extends JComponent
implements KeyListener,
MouseListener,
MouseMotionListener,
SimPanel {
    private Image offScreen = null;
    private Graphics offScreenGraphics = null;
    protected MouseDragHandler mdh = null;
    private boolean needExpand = false;
    protected Dragable dragObj = null;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private Vector drawables = new Vector(10);
    protected CoordMap map = new CoordMap();
    private ObjectListener objListen = null;

    public SimCanvas() {
        this(null);
    }

    public SimCanvas(MouseDragHandler mdh) {
        this.mdh = mdh;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        if (!this.isOpaque()) {
            Utility.println("setting SimCanvas to be opaque!");
            this.setOpaque(true);
        }
    }

    public String toString() {
        return this.getClass().getName() + " with offScreen= " + this.offScreen.toString();
    }

    public void setMouseDragHandler(MouseDragHandler mdh) {
        this.mdh = mdh;
    }

    public void freeOffscreen() {
        this.offScreen = null;
        if (this.offScreenGraphics != null) {
            this.offScreenGraphics.dispose();
            this.offScreenGraphics = null;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public void setObjectListener(ObjectListener objListen) {
        this.objListen = objListen;
    }

    public synchronized void prependElement(Drawable e) {
        this.drawables.insertElementAt(e, 0);
    }

    public synchronized void addElement(Drawable e) {
        this.drawables.addElement(e);
    }

    public synchronized void removeElement(Drawable e) {
        this.drawables.removeElement(e);
    }

    public synchronized void removeAllElements() {
        this.drawables.removeAllElements();
    }

    public synchronized boolean containsElement(Drawable e) {
        return this.drawables.contains(e);
    }

    public synchronized void setCoordMap(CoordMap map) {
        this.map = map;
        Dimension d = this.getSize();
        map.setScreen(0, 0, d.width, d.height);
        this.freeOffscreen();
        if (this.objListen != null) {
            this.objListen.objectChanged(this);
        }
    }

    public CoordMap getCoordMap() {
        return this.map;
    }

    public DoubleRect getSimBounds() {
        return this.map.getSimBounds();
    }

    public ConvertMap getConvertMap() {
        return this.map.getConvertMap();
    }

    public synchronized void setSize(int width, int height) {
        super.setSize(width, height);
        this.map.setScreen(0, 0, width, height);
        this.freeOffscreen();
        if (this.needExpand && this.map.expand()) {
            this.needExpand = false;
        }
        if (this.objListen != null) {
            this.objListen.objectChanged(this);
        }
    }

    public void expandMap() {
        this.needExpand = true;
    }

    public void paintComponent(Graphics g) {
        if (this.offScreen != null) {
            if (this.offScreenGraphics == null) {
                this.offScreenGraphics = this.offScreen.getGraphics();
            }
            Dimension size = this.getSize();
            this.offScreenGraphics.setClip(0, 0, size.width, size.height);
            this.offScreenGraphics.setColor(Color.white);
            this.offScreenGraphics.fillRect(0, 0, size.width, size.height);
            this.drawElements(this.offScreenGraphics, this.map.getConvertMap());
            g.drawImage(this.offScreen, 0, 0, null);
            g.drawRect(10, 10, 100, 100);
        } else {
            Dimension size = this.getSize();
            g.setClip(0, 0, size.width, size.height);
            g.setColor(Color.white);
            g.fillRect(0, 0, size.width, size.height);
            this.drawElements(g, this.map.getConvertMap());
        }
    }

    protected synchronized void drawElements(Graphics g, ConvertMap map) {
        Enumeration e = this.drawables.elements();
        while (e.hasMoreElements()) {
            ((Drawable)e.nextElement()).draw(g, map);
        }
    }

    private Frame getFrame() {
        Container c = this;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    protected synchronized Dragable findNearestDragable(double x, double y) {
        double distance = Double.POSITIVE_INFINITY;
        Dragable nearest = null;
        Enumeration e = this.drawables.elements();
        while (e.hasMoreElements()) {
            double dist;
            Dragable d;
            Object o = e.nextElement();
            if (!(o instanceof Dragable) || !(d = (Dragable)o).isDragable() || !((dist = d.distanceSquared(x, y)) < distance)) continue;
            distance = dist;
            nearest = d;
        }
        return nearest;
    }

    public void mousePressed(MouseEvent evt) {
        int scr_x = evt.getX();
        int scr_y = evt.getY();
        double sim_x = this.map.screenToSimX(scr_x);
        double sim_y = this.map.screenToSimY(scr_y);
        this.dragObj = this.findNearestDragable(sim_x, sim_y);
        if (this.dragObj != null) {
            this.dragOffsetX = scr_x - this.map.simToScreenX(this.dragObj.getX());
            this.dragOffsetY = scr_y - this.map.simToScreenY(this.dragObj.getY());
            if (this.mdh != null) {
                this.mdh.startDrag(this.dragObj);
            }
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.dragObj != null) {
            double sim_x = this.map.screenToSimX(evt.getX() - this.dragOffsetX);
            double sim_y = this.map.screenToSimY(evt.getY() - this.dragOffsetY);
            if (this.mdh != null) {
                this.mdh.constrainedSet(this.dragObj, sim_x, sim_y);
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.dragObj != null && this.mdh != null) {
            this.mdh.finishDrag(this.dragObj);
        }
        this.dragObj = null;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
    }

    public boolean isFocusable() {
        return true;
    }
}

