/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.Utility;

public class SimThread
extends Thread {
    private Runnable sim;
    private long delay;
    private boolean suspendRequested = false;

    SimThread(Runnable sim, long delay) {
        super("SimThread");
        this.sim = sim;
        this.delay = delay;
    }

    public void run() {
        try {
            while (!SimThread.interrupted()) {
                this.checkSuspended();
                this.sim.run();
                SimThread.sleep(this.delay);
            }
        }
        catch (InterruptedException e) {
            Utility.println("SimThread thread interrupted.");
        }
    }

    public void requestSuspend() {
        this.suspendRequested = true;
    }

    private synchronized void checkSuspended() throws InterruptedException {
        while (this.suspendRequested) {
            this.wait();
        }
    }

    public synchronized void requestResume() {
        this.suspendRequested = false;
        this.notifyAll();
    }
}

