/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CCurve;
import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.ObjectListener;
import com.myphysicslab.simlab.Simulation;
import java.awt.Color;
import java.awt.Container;

public class String1
extends Simulation
implements ObjectListener {
    public static final int FLAT = 0;
    public static final int TRIANGLE = 1;
    public static final int QUARTER_TRI = 2;
    public static final int SQUARE_PULSE = 3;
    public static final int SINE_PULSE = 4;
    public static final int HALF_SINE_PULSE = 5;
    public static final int FANCY_SINE = 6;
    private CCurve m_Curve;
    private CCurve m_Curve2;
    private CMass m_Block;
    private double m_Length;
    private double m_Tension;
    private double m_Density;
    private double m_Density2;
    private double m_damping;
    private double gravity;
    private int m_shape;
    private double[] w1;
    private double[] w2;
    private double[] w3;
    private double[] w4;
    private int w_idx;
    private double delta_x;
    private double delta_t;
    private double total_t;
    private double bead_y;
    private double bead_v;
    private double bead_mass;
    private static final int AVG_LEN = 10;
    private double[] times;
    private double[] stab;
    private int time_idx;
    private double last_time;
    private double now_time;
    private static final String SHAPE = "shape";
    private static final String TENSION = "tension";
    private static final String GRAVITY = "gravity";
    private static final String DENSITY = "density";
    private String[] params = new String[]{"tension", "gravity", "density"};
    private static final int STRING_POINTS = 501;

    public String1(Container app) {
        super(app);
        CoordMap map = new CoordMap(-1, 0.0, 15.0, -0.5, 0.5, 0, 0);
        this.setCoordMap(map);
        map.setFillScreen(true);
        map.setRange(0.0, 15.0, -0.25, 0.25);
        DoubleRect simRect = map.getSimBounds();
        this.var_names = new String[0];
        this.m_shape = 0;
        this.times = new double[10];
        this.stab = new double[10];
        this.last_time = -100.0;
        this.now_time = 0.0;
        this.time_idx = 0;
        this.bead_v = 0.0;
        this.bead_y = 0.0;
        this.bead_mass = 1.0;
        this.m_Length = 0.9 * simRect.getWidth();
        this.m_Tension = 2.0;
        this.m_Density = 1.0;
        this.m_Density2 = 4.0;
        this.m_damping = 2.0;
        this.gravity = 1.0;
        this.delta_x = this.m_Length / 500.0;
        System.out.println("string length= " + this.m_Length + "  delta_x= " + this.delta_x);
        this.delta_t = 0.005;
        System.out.println("delta_t = " + this.delta_t + " must be < " + this.delta_x * Math.sqrt(this.m_Density2 / this.m_Tension));
        this.total_t = 0.0;
        this.initializeShape();
        double bw = 0.7;
        double bh = 0.05;
        double h = simRect.getHeight() / 2.0;
        this.m_Curve = new CCurve(simRect.getXMin() + bw + 0.2, -h, this.m_Length, 2.0 * h, 501);
        this.cvs.addElement(this.m_Curve);
        this.m_Curve2 = new CCurve(simRect.getXMin() + 2.0 * bw, -h, this.m_Length, 2.0 * h, 501);
        this.m_Curve2.m_Data = this.w4;
        this.m_Curve2.m_Color = Color.red;
        this.m_Block = new CMass(this.m_Curve.m_X1 - bw, -bh / 2.0, bw, bh, 1);
        this.cvs.addElement(this.m_Block);
        this.modifyObjects();
        this.params = new String[]{GRAVITY, TENSION, DENSITY};
        this.modifyObjects();
        this.cvs.setObjectListener(this);
    }

    public void setupControls() {
        super.setupControls();
        this.addObserverControl(new DoubleField(this, GRAVITY, 2));
        this.addObserverControl(new DoubleField(this, TENSION, 2));
        this.addObserverControl(new DoubleField(this, DENSITY, 2));
        this.showControls(true);
    }

    public void setupGraph() {
    }

    private void initializeShape() {
        this.w_idx = 2;
        this.w1 = new double[501];
        this.w2 = new double[501];
        this.w3 = new double[501];
        this.w4 = new double[501];
        double r = this.delta_t * this.delta_t * this.m_Tension / this.m_Density / (this.delta_x * this.delta_x);
        this.w1[500] = 0.0;
        this.w1[0] = 0.0;
        this.w2[500] = 0.0;
        this.w2[0] = 0.0;
        for (int i = 1; i < 500; ++i) {
            this.w1[i] = this.init((double)i * this.delta_x);
            this.w2[i] = (1.0 - r) * this.init((double)i * this.delta_x) + r / 2.0 * (this.init((double)(i + 1) * this.delta_x) + this.init((double)(i - 1) * this.delta_x));
            int n = i;
            this.w2[n] = this.w2[n] + this.delta_t * Math.sqrt(this.m_Tension / this.m_Density) * this.velocity((double)i * this.delta_x);
        }
        this.total_t = 0.0;
    }

    private double velocity(double x) {
        switch (this.m_shape) {
            default: {
                return 0.0;
            }
            case 2: {
                double w = this.m_Length / 8.0;
                if ((x -= this.m_Length / 8.0) < -w || x > w) {
                    return 0.0;
                }
                return -(0.1 / w) * (double)(x < 0.0 ? 1 : -1);
            }
            case 4: 
        }
        double w = this.m_Length / 8.0;
        if ((x -= this.m_Length / 8.0) < -w || x > w) {
            return 0.0;
        }
        return -0.05 * (Math.PI / w) * Math.cos(Math.PI * x / w);
    }

    private double init(double x) {
        switch (this.m_shape) {
            default: {
                return 0.0;
            }
            case 1: {
                return 0.2 * (x < this.m_Length / 2.0 ? x / this.m_Length : 1.0 - x / this.m_Length);
            }
            case 2: {
                double w = this.m_Length / 8.0;
                if ((x -= this.m_Length / 8.0) < -w || x > w) {
                    return 0.0;
                }
                return 0.1 * (x < 0.0 ? x / w + 1.0 : -x / w + 1.0);
            }
            case 3: {
                double w = this.m_Length / 8.0;
                if ((x -= this.m_Length / 2.0) < -w || x > w) {
                    return 0.0;
                }
                return 0.1;
            }
            case 4: {
                double w = this.m_Length / 8.0;
                if ((x -= this.m_Length / 8.0) < -w || x > w) {
                    return 0.0;
                }
                return 0.05 * Math.sin(Math.PI * x / w);
            }
            case 5: {
                double w = this.m_Length / 3.0;
                if (x > w) {
                    return 0.0;
                }
                return Math.sin(Math.PI * x / w);
            }
            case 6: 
        }
        return 0.1 * (Math.sin(Math.PI * 2 * x / this.m_Length) + Math.sin(Math.PI * 4 * x / this.m_Length) + Math.sin(Math.PI * 6 * x / this.m_Length)) / 3.0;
    }

    public void modifyObjects() {
        double[] w;
        switch (this.w_idx) {
            default: {
                w = this.w1;
                break;
            }
            case 2: {
                w = this.w2;
                break;
            }
            case 3: {
                w = this.w3;
            }
        }
        this.m_Curve.m_Data = w;
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(TENSION)) {
            this.m_Tension = value;
            return true;
        }
        if (name.equalsIgnoreCase(DENSITY)) {
            this.m_Density = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.gravity = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(TENSION)) {
            return this.m_Tension;
        }
        if (name.equalsIgnoreCase(DENSITY)) {
            return this.m_Density;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.gravity;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void objectChanged(Object o) {
        if (this.cvs == o) {
            // empty if block
        }
    }

    public void evaluate(double[] x, double[] change) {
    }

    protected void advance(double time_step) {
        double[] w_new;
        double[] w_old;
        double[] w;
        this.total_t += this.delta_t;
        this.CalcAnalyticData(this.total_t);
        switch (this.w_idx) {
            default: {
                w = this.w1;
                w_old = this.w3;
                w_new = this.w2;
                this.w_idx = 2;
                break;
            }
            case 2: {
                w = this.w2;
                w_old = this.w1;
                w_new = this.w3;
                this.w_idx = 3;
                break;
            }
            case 3: {
                w = this.w3;
                w_old = this.w2;
                w_new = this.w1;
                this.w_idx = 1;
            }
        }
        boolean MODE = false;
        int N = 500;
        w_new[0] = 0.0;
        w_new[N] = 0.0;
        w_new[0] = this.m_Block.getCenterY();
        double r = this.delta_t * this.delta_t * this.m_Tension / this.m_Density / (this.delta_x * this.delta_x);
        if (this.m_shape == 0) {
            double c = Math.sqrt(this.m_Tension / this.m_Density);
            w_new[0] = this.total_t < Math.PI * 2 / c ? 0.05 * Math.sin(c * this.total_t) : w[1];
            w_new[N] = w[N - 1];
        }
        int midpt = 249;
        for (int i = 1; i <= N - 1; ++i) {
            w_new[i] = 2.0 * (1.0 - r) * w[i] + r * (w[i + 1] + w[i - 1]) - w_old[i];
        }
        if (++this.time_idx >= 10) {
            this.time_idx = 0;
        }
        this.times[this.time_idx] = time_step;
        this.now_time += time_step;
        this.stab[this.time_idx] = Math.sqrt(r);
        if (this.now_time - this.last_time > 1.0) {
            this.last_time = this.now_time;
            double d = 0.0;
            double e = 0.0;
            for (int i = 0; i < 10; ++i) {
                d += this.times[i];
                e += this.stab[i];
            }
            System.out.println("avg delta(t) = " + d / 10.0 + " stability =" + e / 10.0);
            double left = this.amplitude(0, w_new, this.delta_x);
            double right = this.amplitude(1, w_new, this.delta_x);
            System.out.println("amplitude left = " + left + "   right = " + right);
            left = this.energy(0, w, w_new, this.delta_x, this.delta_t);
            right = this.energy(1, w, w_new, this.delta_x, this.delta_t);
            System.out.println("energy left = " + left + "   right = " + right + "  total= " + (left + right));
            System.out.println("");
        }
        this.modifyObjects();
    }

    private double amplitude(int side, double[] w, double delta_x) {
        int start = side == 0 ? 0 : 250;
        int end = side == 0 ? 250 : 501;
        double a = 0.0;
        for (int i = start; i < end; ++i) {
            double m = w[i];
            if (m < 0.0) {
                m = -m;
            }
            if (!(m > a)) continue;
            a = m;
        }
        return a;
    }

    private double amplitude2(int side, double[] w, double delta_x) {
        int start = side == 0 ? 0 : 250;
        int end = side == 0 ? 250 : 501;
        double s = 0.0;
        for (int i = start; i < end; ++i) {
            s += w[i] * w[i] * delta_x;
        }
        return Math.sqrt(s);
    }

    private double energy(int side, double[] w, double[] w_new, double delta_x, double delta_t) {
        int start = side == 0 ? 1 : 250;
        int end = side == 0 ? 251 : 500;
        double k = 0.0;
        double v = 0.0;
        for (int i = start; i < end; ++i) {
            double diff = (w_new[i - 1] - w_new[i + 1]) / (2.0 * delta_x);
            v += diff * diff * delta_x;
            diff = (w_new[i] - w[i]) / delta_t;
            k += diff * diff * delta_x;
        }
        double density = side == 0 ? this.m_Density : this.m_Density2;
        return 0.5 * (this.m_Tension * v + density * k);
    }

    private void CalcAnalyticData(double t) {
    }
}

