/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import java.awt.Rectangle;
import java.util.Random;

public class Utility {
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_MIN = 1;
    public static final int DEBUG_MEDIUM = 2;
    public static final int DEBUG_MAX = 4;
    public static int debugSetting = 0;
    public static Random random = new Random(System.currentTimeMillis());

    public static boolean debug(int flag) {
        return 0 != (flag & debugSetting);
    }

    public static void println(String s) {
        if (debugSetting != 0) {
            System.out.println(s);
        }
    }

    private boolean rectIntersect(Rectangle r, Rectangle b) {
        int left = r.x > b.x ? r.x : b.x;
        int top = r.y > b.y ? r.y : b.y;
        int right = r.x + r.width < b.x + b.width ? r.x + r.width : b.x + b.width;
        int bottom = r.y + r.height < b.y + b.height ? r.y + r.height : b.y + b.height;
        r.x = left;
        r.y = top;
        r.width = right - left;
        r.height = bottom - top;
        return r.width > 0 && r.height > 0;
    }

    public static void matrixSolve(double[][] A, double[] x) {
        int i;
        int n = x.length;
        int[] nrow = new int[n];
        for (i = 0; i < n; ++i) {
            nrow[i] = i;
        }
        for (i = 0; i < n - 1; ++i) {
            int j;
            int p = i;
            double max = Math.abs(A[nrow[p]][i]);
            for (j = i + 1; j < n; ++j) {
                if (!(Math.abs(A[nrow[j]][i]) > max)) continue;
                max = Math.abs(A[nrow[j]][i]);
                p = j;
            }
            if (A[nrow[p]][i] == 0.0) {
                throw new IllegalStateException("matrixSolve: no unique solution exists");
            }
            if (nrow[i] != nrow[p]) {
                int ncopy = nrow[i];
                nrow[i] = nrow[p];
                nrow[p] = ncopy;
            }
            for (j = i + 1; j < n; ++j) {
                double m = A[nrow[j]][i] / A[nrow[i]][i];
                for (int k = 0; k < n + 1; ++k) {
                    double[] dArray = A[nrow[j]];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - m * A[nrow[i]][k];
                }
            }
        }
        if (A[nrow[n - 1]][n - 1] == 0.0) {
            throw new IllegalStateException("matrixSolve: no unique solution exists");
        }
        x[n - 1] = A[nrow[n - 1]][n] / A[nrow[n - 1]][n - 1];
        for (i = n - 2; i >= 0; --i) {
            double sum = 0.0;
            for (int j = i + 1; j < n; ++j) {
                sum += A[nrow[i]][j] * x[j];
            }
            x[i] = (A[nrow[i]][n] - sum) / A[nrow[i]][i];
        }
    }
}

